package com.ejianc.business.plan.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

@Component
public class OrgUtil {

    private static final String REFER_CACHE_KEY = "refer_cache_key:";

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IEmployeeApi employeeApi;

    public OrgVO findById(Long orgId) {
        OrgVO corp = new OrgVO();
//        CommonResponse<OrgVO> rootResp = orgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid());// 获取根组织
        CommonResponse<List<OrgVO>> rootResp = orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(1), null);
        Map<Long, OrgVO> corpMap = new HashMap<>();
        if (rootResp.isSuccess() && null != rootResp.getData()) {
            for(OrgVO root : rootResp.getData()){
                CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentId(root.getId());// 获取根组织下子级
                if (orgResp.isSuccess() && null != orgResp.getData()) {
                    List<OrgVO> orgList = orgResp.getData();
                    corpMap.putAll(orgList.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toMap(OrgVO::getId, Function.identity())));
                }
            }
        }
        CommonResponse<OrgVO> resp = orgApi.detailById(orgId);
        if (resp.isSuccess() && null != resp.getData()) {
            String innerCode = resp.getData().getInnerCode();
            for (Long key : corpMap.keySet()) {
                if (innerCode.contains(String.valueOf(key))) {
                    // 取最近分子公司
                    if(StringUtils.isNotEmpty(corp.getInnerCode()) && corp.getInnerCode().length() > innerCode.length()){
                        continue;
                    }
                    corp = corpMap.get(key);
                }
            }
        }
        return corp;
    }

    public Map<Long, OrgVO> findListByIds(List<Long> orgIds) {
        Map<Long, OrgVO> corp = new HashMap<>();
//        CommonResponse<OrgVO> rootResp = orgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid());// 获取根组织
        CommonResponse<List<OrgVO>> rootResp = orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(1), null);
        Map<Long, OrgVO> orgMap = new HashMap<>();
        Map<Long, OrgVO> corpMap = new HashMap<>();
        if (rootResp.isSuccess() && null != rootResp.getData()) {
            for(OrgVO root : rootResp.getData()){
                CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentId(root.getId());// 获取根组织下子级
                if (orgResp.isSuccess() && null != orgResp.getData()) {
                    List<OrgVO> orgList = orgResp.getData();
                    orgMap.putAll(orgList.stream().collect(Collectors.toMap(OrgVO::getId, Function.identity())));
                    corpMap.putAll(orgList.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toMap(OrgVO::getId, Function.identity())));
                }
            }
        }
        for (Long orgId : orgIds) {
            if (orgMap.containsKey(orgId)) {
                String innerCode = orgMap.get(orgId).getInnerCode();
                for (Long key : corpMap.keySet()) {
                    if (innerCode.contains(String.valueOf(key))) {
                        // 取最近分子公司
                        if(corp.containsKey(orgId) && corp.get(orgId).getInnerCode().length() > corpMap.get(key).getInnerCode().length()){
                            continue;
                        }
                        corp.put(orgId, corpMap.get(key));
                    }
                }
            }
        }
        return corp;
    }

    /**
     * 获取组织本上二级分子公司
     * @param orgIds
     * @return
     */
    public Map<Long, OrgVO> getCorpMapByIds(List<Long> orgIds) {
        Map<Long, OrgVO> corp = new HashMap<>();
        CommonResponse<List<OrgVO>> rootResp = orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(1), null);
        Map<Long, OrgVO> orgMap = new HashMap<>();
        Map<Long, OrgVO> corpMap = new HashMap<>();
        if (rootResp.isSuccess() && null != rootResp.getData()) {
            for(OrgVO root : rootResp.getData()){
                CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentId(root.getId());// 获取根组织下子级
                if (orgResp.isSuccess() && null != orgResp.getData()) {
                    List<OrgVO> orgList = orgResp.getData();
                    orgMap.putAll(orgList.stream().collect(Collectors.toMap(OrgVO::getId, Function.identity())));
                    corpMap.putAll(orgList.stream().filter(e -> e.getOrgType() == 1 || (e.getOrgType() == 2 && 1 == StringUtils.countMatches(e.getInnerCode(), "|"))).
                            collect(Collectors.toMap(OrgVO::getId, Function.identity())));
                }
            }
        }
        for (Long orgId : orgIds) {
            if (orgMap.containsKey(orgId)) {
                String innerCode = orgMap.get(orgId).getInnerCode();
                for (Long key : corpMap.keySet()) {
                    if (innerCode.contains(String.valueOf(key))) {
                        corp.put(orgId, corpMap.get(key));
                    }
                }
            }
        }
        return corp;
    }

    /**
     * 根据人员编码查询人员主键
     * @param userCode
     * @return
     */
    public static String getCreateUserId(String userCode) {
        try {
            MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
            if (StringUtils.isNotBlank(userCode) && StringUtils.isNotBlank(urlconstants.getBaseHost())) {
                String cacheKey = REFER_CACHE_KEY + "idm-employee:" + userCode;
                RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get(cacheKey);
                JSONObject jsonObject = null;
                if (cacheValue != null) {
                    jsonObject = JSON.parseObject(cacheValue.toString());
                } else {
                    String referData = getReferRestUrl("idm-employee");
                    JSONObject json = JSON.parseObject(referData);
                    String referUrl = json.get("projectName").toString();
                    Map<String, Object> reflist = new HashMap<>();
                    reflist = (Map<String, Object>) json.get("refMapList");
                    reflist.put("userCode", userCode);
                    String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getAuditInfo";
                    String jsonbackstr = null;
                    try {
                        jsonbackstr = ReferHttpClientUtils.getAndHeader(url, reflist);
                    } catch (Exception e) {
                    }
                    if (StringUtils.isNotBlank(jsonbackstr)) {
                        jsonObject = JSON.parseObject(jsonbackstr);
                        redisTemplate.opsForValue().set(cacheKey, jsonbackstr, 5, TimeUnit.DAYS);
                    }
                }
                if (jsonObject != null) {
                    return jsonObject.getString("id");
                }
            }
        } catch (Exception e) {
        }
        return userCode;
    }

    /**
     * 根据人员主键查询人员名称
     * @param userId
     * @return
     */
    public String getCreateUserName(Long userId) {
        try {
            MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
            if (userId != null && StringUtils.isNotBlank(urlconstants.getBaseHost())) {
                String cacheKey = REFER_CACHE_KEY + "idm-employee:" + userId;
                RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get(cacheKey);
                if (cacheValue != null) {
                    JSONArray jsonArray = JSONArray.parseArray(cacheValue.toString());
                    JSONObject jsonObject = JSONObject.parseObject(jsonArray.get(0).toString());
                    return jsonObject.getString("name");
                } else {
                    CommonResponse<EmployeeVO> resp = employeeApi.queryEmployeByUserId(userId);
                    if(resp.isSuccess()){
                        return resp.getData().getUserName();
                    }
                }
            }
        } catch (Exception e) {
        }
        return null;
    }

    /**
     * 通过元数据服务获取实体信息
     * @param referCode
     * @return
     */
    private static String getReferRestUrl(String referCode) {
        String data = null;
        MetaDataUrlconstants urlconstants = ContextUtil.getBean(MetaDataUrlconstants.class);
        String backData = null;
        try {
            backData = ReferHttpClientUtils.getAndHeader(urlconstants.getMetaDataBaseUrl() + referCode, null);
        } catch (Exception e) {
        }
        JSONObject jsonobject = JSON.parseObject(backData);
        if (jsonobject.getString("code").equals("0")) {
            if (jsonobject.getString("data") != null) {
                data = JSON.parseObject(jsonobject.getString("data")).toJSONString();
            }
        } else {
            ExceptionUtil.wrappBusinessException("参照编码" + referCode + "的实体没有发布元数据!");
        }
        return data;
    }

}
