package com.ejianc.business.probuilddiary.construct.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.probuilddiary.construct.mapper.ConstructAreaDetailMapper;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaDetailEntity;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaDetailService;

/**
 * 施工区域 详情表
 * 
 * @author generator
 * 
 */
@Service("constructAreaDetailService")
public class ConstructAreaDetailServiceImpl extends BaseServiceImpl<ConstructAreaDetailMapper, ConstructAreaDetailEntity> implements IConstructAreaDetailService{



    /**
     * 根据区域id，修改详情单据状态
     *
     * @param areaId        区域id
     * @param billStateCode 单据状态
     */
    @Override
    public void updateBillState(Long areaId, Integer billStateCode) {
        LambdaUpdateWrapper<ConstructAreaDetailEntity> updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(ConstructAreaDetailEntity::getAreaId, areaId);
        updateWrapper.set(ConstructAreaDetailEntity::getDetailBillState, billStateCode);
        super.update(updateWrapper);
    }
}
