package com.ejianc.business.probuilddiary.ledger.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.util.Date;

/**
 * 日志台账-施工组织设计、方案、交底、变更情况（技术负责人）
 *
 * @author baipengyan
 */
@TableName("ejc_probuilddiary_ledger_type")
public class LedgerTypeEntity extends BaseEntity {
	private static final long serialVersionUID = 7386090124374855303L;

	@TableField(value = "person_id")
	private Long personId; // 个人日志id
	@TableField(value = "work_type_id")
	private Long workTypeId; // 工作类别id
	@TableField(value = "work_type_name")
	private String workTypeName; // 工作类别名称
	@TableField(value = "work_type_code")
	private String workTypeCode; // 工作类别编码
	@TableField(value = "work_type_memo")
	private String workTypeMemo; // 主要工作内容
	@TableField(value = "commit_user_id")
	private Long commitUserId; // 提交人id
	@TableField(value = "commit_user_code")
	private String commitUserCode; // 提交人账号
	@TableField(value = "commit_user_name")
	private String commitUserName; // 提交人名称
	@TableField(value = "commit_date")
	private Date commitDate; // 提交日期
	@TableField(value = "project_log_id")
	private Long projectLogId; // 项目日志id
	@TableField(value = "ledger_id")
	private Long ledgerId; // 日志台账id
	@TableField(value = "file_type")
	private String fileType; // 文件类型
	@TableField(value = "log_number")
	private String logNumber; // 日志项编码
	@TableField(value = "project_manager_flag")
	private Boolean projectManagerFlag; // 项目经理标识

	@TableField(value="team_name")
	private String teamName; // 劳务、分包单位名称
	@TableField(value="work_num_day")
	private Integer workNumDay; // 作业人员数量（日）
	@TableField(value="work_num_night")
	private Integer workNumNight; // 作业人员数量（夜）


	public String getTeamName() {
		return teamName;
	}

	public void setTeamName(String teamName) {
		this.teamName = teamName;
	}

	public Integer getWorkNumDay() {
		return workNumDay;
	}

	public void setWorkNumDay(Integer workNumDay) {
		this.workNumDay = workNumDay;
	}

	public Integer getWorkNumNight() {
		return workNumNight;
	}

	public void setWorkNumNight(Integer workNumNight) {
		this.workNumNight = workNumNight;
	}

	public Long getPersonId() {
		return personId;
	}

	public void setPersonId(Long personId) {
		this.personId = personId;
	}

	public Long getWorkTypeId() {
		return workTypeId;
	}

	public void setWorkTypeId(Long workTypeId) {
		this.workTypeId = workTypeId;
	}

	public String getWorkTypeName() {
		return workTypeName;
	}

	public void setWorkTypeName(String workTypeName) {
		this.workTypeName = workTypeName;
	}

	public String getWorkTypeCode() {
		return workTypeCode;
	}

	public void setWorkTypeCode(String workTypeCode) {
		this.workTypeCode = workTypeCode;
	}

	public String getWorkTypeMemo() {
		return workTypeMemo;
	}

	public void setWorkTypeMemo(String workTypeMemo) {
		this.workTypeMemo = workTypeMemo;
	}

	public Long getCommitUserId() {
		return commitUserId;
	}

	public void setCommitUserId(Long commitUserId) {
		this.commitUserId = commitUserId;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public Long getProjectLogId() {
		return projectLogId;
	}

	public void setProjectLogId(Long projectLogId) {
		this.projectLogId = projectLogId;
	}

	public Long getLedgerId() {
		return ledgerId;
	}

	public void setLedgerId(Long ledgerId) {
		this.ledgerId = ledgerId;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public String getLogNumber() {
		return logNumber;
	}

	public void setLogNumber(String logNumber) {
		this.logNumber = logNumber;
	}

	public Boolean getProjectManagerFlag() {
		return projectManagerFlag;
	}

	public void setProjectManagerFlag(Boolean projectManagerFlag) {
		this.projectManagerFlag = projectManagerFlag;
	}
}
