package com.ejianc.business.probuilddiary.person.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fill.bean.DayFillDetailEntity;
import com.ejianc.business.fill.bean.DayFillEntity;
import com.ejianc.business.fill.service.IDayFillDetailService;
import com.ejianc.business.fill.service.IDayFillService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.vo.MonthPlanVO;
import com.ejianc.business.probuilddiary.person.bean.PersonEntity;
import com.ejianc.business.probuilddiary.person.mapper.*;
import com.ejianc.business.probuilddiary.person.service.IPersonService;
import com.ejianc.business.probuilddiary.person.vo.PersonDetailVO;
import com.ejianc.business.probuilddiary.person.vo.PersonScheduleVO;
import com.ejianc.business.probuilddiary.person.vo.PersonVO;
import com.ejianc.business.progress.utils.DetailListUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 个人施工日志
 * 
 * @author generator
 * 
 */
@Service("personService")
public class PersonServiceImpl extends BaseServiceImpl<PersonMapper, PersonEntity> implements IPersonService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private DetailListUtil detailListUtil;
    @Autowired
    private IDayFillService fillService;
    @Autowired
    private IDayFillDetailService fillDetailService;
    @Autowired
    private IMonthPlanService monthService;

    private static final String BILL_CODE = "ZJKJ_PERSON_LOG";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private PersonDetailMapper personDetailMapper;
    @Autowired
    private PersonScheduleMapper personScheduleMapper;
    @Autowired
    private PersonTypeMapper personTypeMapper;
    @Autowired
    private PersonQualityMapper personQualityMapper;
    @Autowired
    private PersonSafetyEntiyMapper personSafetyEntiyMapper;
    @Autowired
    private PersonMaterialEntiyMapper personMaterialEntiyMapper;
    @Autowired
    private PersonEquipmentMapper personEquipmentMapper;
    @Autowired
    private PersonExamineEntiyMapper personExamineEntiyMapper;
    @Autowired
    private PersonInformationMapper personInformationMapper;
    @Autowired
    private PersonOtherMapper personOtherMapper;
    @Override
    public CommonResponse<IPage<PersonVO>> newQuery(QueryParam param) {
        /** 模糊搜索配置字段示例  单据编码，项目名称，填报人，日志模板*/
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("informantName");
        fuzzyFields.add("logTemplate");
        List<PersonEntity> dataList =new ArrayList<>();
        IPage<PersonEntity> page;
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        //移动端查询
        if (StringUtils.isNotBlank(authOrgIds)) {
            //移动端有默认项目的存在，故传递默认项目对应项目部Id时，查询其本下数据，若未传递，则返回空数据
            if(null == param.getParams().get("orgId")) {
                page = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
            } else {
                page = super.queryPage(param, false);
                dataList = page.getRecords();
            }
        } else {
            //pc端查询
            //查询本下范围内日的合同
            Long orgId = InvocationInfoProxy.getOrgId();
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            page = super.queryPage(param, false);
            dataList = page.getRecords();
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if(null == param.getOrderMap().get("createTime")) {
            orderMap.put("create_time", QueryParam.DESC);
        }
        param.setOrderMap(orderMap);
        IPage<PersonVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PersonVO> applicationVOS = BeanMapper.mapList(dataList, PersonVO.class);
        pageData.setRecords(applicationVOS);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @Override
    public CommonResponse<PersonVO> newSaveOrUpdate(PersonVO saveOrUpdateVO) {
        PersonEntity entity = BeanMapper.map(saveOrUpdateVO, PersonEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            //查询当前合同是否存在自由态的单据
            QueryWrapper<PersonEntity> listQuery = new QueryWrapper<>();
            listQuery.eq("project_id", entity.getProjectId());
            listQuery.eq("informant_id", entity.getInformantId());
            listQuery.eq("informant_date", entity.getInformantDate());
            listQuery.eq("dr", 0);
            int resultCount = super.count(listQuery);
            if (resultCount > 0) {
                return CommonResponse.error("一个人一个项目当天只能有一个个人日志单据");
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            QueryWrapper<PersonEntity> listQuery = new QueryWrapper<>();
            listQuery.eq("project_id", entity.getProjectId());
            listQuery.eq("informant_id", entity.getInformantId());
            listQuery.eq("informant_date", entity.getInformantDate());
            listQuery.eq("dr", 0);
            PersonEntity one = super.getOne(listQuery);
            if (one!=null&&!one.getId().equals(entity.getId())) {
                return CommonResponse.error("一个人一个项目当天只能有一个个人日志单据");
            }
        }
        // 先删除所有子表数据再保存
        if (null != entity.getId()) {
            personDetailMapper.deleteByPersonId(entity.getId());
            personScheduleMapper.deleteByPersonId(entity.getId());
            personTypeMapper.deleteByPersonId(entity.getId());
            personQualityMapper.deleteByPersonId(entity.getId());
            personSafetyEntiyMapper.deleteByPersonId(entity.getId());
            personMaterialEntiyMapper.deleteByPersonId(entity.getId());
            personEquipmentMapper.deleteByPersonId(entity.getId());
            personExamineEntiyMapper.deleteByPersonId(entity.getId());
            personInformationMapper.deleteByPersonId(entity.getId());
            personOtherMapper.deleteByPersonId(entity.getId());
        }

        // 初始化汇总到项目日志-否
        entity.setGatherFlag(Boolean.FALSE);
        super.saveOrUpdate(entity, false);
        PersonVO personVO = BeanMapper.map(entity, PersonVO.class);
        return CommonResponse.success("保存或修改单据成功！",personVO);
    }


    /**
     * 查询自由态单据数量
     *
     * @param ids 主键
     *
     * @return Integer
     */
    @Override
    public Integer countUncommitedState(Set<Long> ids) {
        LambdaQueryWrapper<PersonEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.in(PersonEntity::getId, ids)
                .eq(PersonEntity::getBillState, BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        return super.count(lambdaQuery);
    }

    @Override
    public PersonVO autoPerson(PersonVO queryVO) {
        Long employeeId = queryVO.getInformantId();
        // 系统管理员主键特殊处理
        if(queryVO.getInformantId() != null && queryVO.getInformantId().equals(303581417601122400L)){
            employeeId = 1247777316689256450L;
        }
        PersonVO vo = new PersonVO();
        // 主要作业面情况：查询填报人是当前登录人且当日日反馈显示的任务节点，月计划取填报日期当月月计划
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, queryVO.getProjectId()));
        queryParam.getParams().put("fillUserId", new Parameter(QueryParam.EQ, employeeId));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        queryParam.getParams().put("fillDate", new Parameter(QueryParam.EQ, sdf.format(queryVO.getInformantDate())));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<DayFillEntity> fillList = fillService.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(fillList)){
            //查询子表
            QueryWrapper<DayFillDetailEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("progress_id", fillList.get(0).getId());
            queryWrapper.orderByAsc("tid");
            List<DayFillDetailEntity> detailList = fillDetailService.list(queryWrapper);
            Map<String, DayFillDetailEntity> structMap = detailList.stream().collect(Collectors.toMap(x->x.getStructCode(), x->x));
            detailList = detailList.stream().filter(x->x.getShowState() && x.getLeafFlag() && queryVO.getInformantId().equals(x.getEmployeeId())).
                    collect(Collectors.toList());
            // 生成主要工作面情况
            List<PersonDetailVO> pdList = this.transferDetailList(queryVO, detailList, structMap);
            vo.setDetailList(pdList);
            detailList = detailList.stream().filter(x->ComputeUtil.isGreaterThan(x.getDiffValue(), BigDecimal.ZERO)).collect(Collectors.toList());
            // 生成主要进度完成情况，过滤偏差值大于0的任务节点
            List<PersonScheduleVO> psList = this.transferScheduleList(detailList, structMap);
            vo.setScheduleList(psList);
        }
        // 其他七个查询填报人上次手动录入生效数据
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, queryVO.getProjectId()));
        param.getParams().put("informantId", new Parameter(QueryParam.EQ, queryVO.getInformantId()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<PersonEntity> list = super.queryList(param);
        if(CollectionUtils.isNotEmpty(list)){
            PersonVO data = BeanMapper.map(super.selectById(list.get(0).getId()), PersonVO.class);
            vo.setTypeList(restList(data.getTypeList()));
            vo.setQualityList(restList(data.getQualityList()));
            vo.setSafetyList(restList(data.getSafetyList()));
            vo.setMaterialList(restList(data.getMaterialList()));
            vo.setEquipmentList(restList(data.getEquipmentList()));
            vo.setInformationList(restList(data.getInformationList()));
            vo.setOtherList(restList(data.getOtherList()));
        }
        return vo;
    }

    /**
     * 处理历史数据
     * @param list
     * @param <T>
     * @return
     */
    private static <T extends BaseVO> List<T> restList(List<T> list){
        list.forEach(vo->{
            vo.setCreateTime(null);
            vo.setCreateUserCode(null);
            vo.setUpdateTime(null);
            vo.setUpdateUserCode(null);
            vo.setVersion(0);
            vo.setRowState("add");
        });
        return list;
    }

    /**
     * 生成主要进度完成情况
     * @param detailList
     * @param structMap
     * @return
     */
    private List<PersonScheduleVO> transferScheduleList(List<DayFillDetailEntity> detailList, Map<String, DayFillDetailEntity> structMap) {
        List<PersonScheduleVO> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            int i = 0;
            for(DayFillDetailEntity detail : detailList){
                PersonScheduleVO vo = new PersonScheduleVO();
                vo.setId(IdWorker.getId());
                vo.setScheduleId(detail.getId());
                vo.setScheduleCode(detail.getStructCode());
                // 根据结构码拼接任务名称
                String taskName = this.getTaskName(structMap, detail);
                vo.setScheduleName(taskName);
                vo.setDiffValue(detail.getDiffValue());
                vo.setDiffResson(detail.getDiffResson());
                vo.setPredictFinish(detail.getFinish());
                vo.setFileType("schedule_" + i + "_" + new Date().getTime());
                vo.setRowState("add");
                list.add(vo);
                i++;
            }
        }
        return list;
    }

    /**
     * 生成主要工作面情况
     * @param queryVO
     * @param detailList
     * @param structMap
     * @return
     */
    private List<PersonDetailVO> transferDetailList(PersonVO queryVO, List<DayFillDetailEntity> detailList,
                Map<String, DayFillDetailEntity> structMap) {
        // 查询月计划
        MonthPlanVO month = monthService.dateMonthPlan(queryVO.getProjectId(), queryVO.getInformantDate());
        List<PersonDetailVO> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            int i = 0;
            for(DayFillDetailEntity detail : detailList){
                PersonDetailVO vo = new PersonDetailVO();
                vo.setId(IdWorker.getId());
                vo.setConstructId(detail.getId());
                vo.setConstructCode(detail.getStructCode());
                // 根据结构码拼接任务名称
                String taskName = this.getTaskName(structMap, detail);
                vo.setConstructName(taskName);
                vo.setDutyId(String.valueOf(queryVO.getInformantId()));
                vo.setDutyCode(queryVO.getInformantCode());
                vo.setDutyName(queryVO.getInformantName());
                if(month != null){
                    vo.setPlanId(month.getId());
                    vo.setPlanCode(month.getBillCode());
                }
                vo.setFileType("detail_"+ i + "_" + new Date().getTime());
                vo.setRowState("add");
                list.add(vo);
                i++;
            }
        }
        return list;
    }

    /**
     * 根据结构码拼接任务名称
     * @param structMap
     * @param detail
     * @return
     */
    private String getTaskName(Map<String, DayFillDetailEntity> structMap, DayFillDetailEntity detail) {
        String taskName = "";
        String structCode = detail.getStructCode();
        String[] strs = structCode.split("@@");
        Set<String> codeList = new HashSet<>();
        codeList.add(structCode);
        for(int i=0; i< strs.length -1; i++){
            if(structCode.lastIndexOf("@@") > 0){
                structCode = structCode.substring(0, structCode.lastIndexOf("@@"));
                codeList.add(structCode);
            }
        }
        for(String code : codeList){
            if(structMap.containsKey(code)){
                taskName = taskName + structMap.get(code).getName() + "/";
            }
        }
        if(taskName.endsWith("/")) {
            taskName = taskName.substring(0, taskName.length() -1);
        } else {
            taskName = detail.getName();
        }
        return taskName;
    }

}
