package com.ejianc.business.progress.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 亮灯规则模板实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_progress_light_rule")
public class LightRuleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 模板编号
    @TableField(value="bill_name")
    private String billName; // 模板名称
    @TableField(value="org_id")
    private Long orgId; // 创建组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="industry_type_id")
    private Long industryTypeId; // 行业类型主键
    @TableField(value="industry_type_name")
    private String industryTypeName; // 行业类型名称
    @TableField(value="fill_type")
    private String fillType; // 填报周期 1-每天 2-每周 3-每月
    @TableField(value="fill_time")
    private String fillTime; // 填报日期
    @TableField(value="description")
    private String description; // 填报描述
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="apply_org_id")
    private Long applyOrgId; // 适用组织
    @TableField(value="apply_org_name")
    private String applyOrgName; // 适用组织

    @TableField(exist=false)
    @SubEntity(serviceName="lightRuleLevelService",pidName = "ruleId")
    private List<LightRuleLevelEntity> detailList = new ArrayList<>(); // 亮灯规则定义实体

    /**
     * 模板编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 模板编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 模板名称
     */
    public String getBillName() {
        return billName;
    }

    /**
     * 模板名称
     */
    public void setBillName(String billName) {
        this.billName = billName;
    }
    /**
     * 创建组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 创建组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 行业类型主键
     */
    public Long getIndustryTypeId() {
        return industryTypeId;
    }

    /**
     * 行业类型主键
     */
    public void setIndustryTypeId(Long industryTypeId) {
        this.industryTypeId = industryTypeId;
    }
    /**
     * 行业类型名称
     */
    public String getIndustryTypeName() {
        return industryTypeName;
    }

    /**
     * 行业类型名称
     */
    public void setIndustryTypeName(String industryTypeName) {
        this.industryTypeName = industryTypeName;
    }
    /**
     * 填报周期 1-每天 2-每周 3-每月
     */
    public String getFillType() {
        return fillType;
    }

    /**
     * 填报周期 1-每天 2-每周 3-每月
     */
    public void setFillType(String fillType) {
        this.fillType = fillType;
    }
    /**
     * 填报日期
     */
    public String getFillTime() {
        return fillTime;
    }

    /**
     * 填报日期
     */
    public void setFillTime(String fillTime) {
        this.fillTime = fillTime;
    }
    /**
     * 填报描述
     */
    public String getDescription() {
        return description;
    }

    /**
     * 填报描述
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getApplyOrgId() {
        return applyOrgId;
    }
    @ReferDeserialTransfer
    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    /**
     * 亮灯规则定义实体
     */
    public List<LightRuleLevelEntity> getDetailList() {
        return detailList;
    }

    /**
     * 亮灯规则定义实体
     */
    public void setDetailList(List<LightRuleLevelEntity> detailList) {
        this.detailList = detailList;
    }
}
