package com.ejianc.business.progress.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 推送设置层级实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_progress_push_set_level")
public class PushSetLevelEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="set_id")
    private Long setId; // 设置主键
    @TableField(value="level")
    private Integer level; // 层级 1-一级节点，2-一级、二级节点，3-所有节点，4-节点纠偏
    @TableField(value="org_type")
    private String orgType; // 消息推送组织 5、本组织；1、本集团；2、本分子公司；3、本经理部
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="pushSetReceiveService",pidName = "levelId")
    private List<PushSetReceiveEntity> receiveList = new ArrayList<>(); // 推送设置接收实体
    

    /**
     * 设置主键
     */
    public Long getSetId() {
        return setId;
    }

    /**
     * 设置主键
     */
    public void setSetId(Long setId) {
        this.setId = setId;
    }
    /**
     * 层级 1-一级节点，2-一级、二级节点，3-所有节点，4-节点纠偏
     */
    public Integer getLevel() {
        return level;
    }

    /**
     * 层级 1-一级节点，2-一级、二级节点，3-所有节点，4-节点纠偏
     */
    public void setLevel(Integer level) {
        this.level = level;
    }
    /**
     * 消息推送组织 5、本组织；1、本集团；2、本分子公司；3、本经理部
     */
    public String getOrgType() {
        return orgType;
    }

    /**
     * 消息推送组织 5、本组织；1、本集团；2、本分子公司；3、本经理部
     */
    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }
    
    /**
     * 推送设置接收实体
     */
    public List<PushSetReceiveEntity> getReceiveList() {
        return receiveList;
    }

    /**
     * 推送设置接收实体
     */
    public void setReceiveList(List<PushSetReceiveEntity> receiveList) {
        this.receiveList = receiveList;
    }
}
