package com.ejianc.business.progress.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName: RiskStateEnum
 * @Description:
 * @Author: 曹鹏辉
 * @Date: 2021/9/17 10:29
 */
public enum RiskStateEnum {

    CREATE("create", "创建"),
    DRAW("draw", "提请"),
    RETURN("return", "退回"),
    ACCEPT("accept", "受理"),
    SAVE("save", "纠偏措施"),
    RUNNING("running", "纠偏进度  纠偏中"),
    FINISH("finish", "纠偏进度  已完成");


    private final String code;
    private final String name;
    private static Map<String, RiskStateEnum> enumMap = new HashMap();

    private RiskStateEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static String getNameByCode(Long code) {
        RiskStateEnum riskStateEnum = enumMap.get(code);
        return riskStateEnum != null ? riskStateEnum.getName() : null;
    }

    static {
        enumMap = (Map) EnumSet.allOf(RiskStateEnum.class).stream().collect(Collectors.toMap(RiskStateEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }


}
