package com.ejianc.business.progress.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.progress.bean.RiskCorrectionEntity;
import com.ejianc.business.progress.bean.RiskCorrectionHistoryEntity;
import com.ejianc.business.progress.enums.RiskStateEnum;
import com.ejianc.business.progress.service.IRiskCorrectionHistoryService;
import com.ejianc.business.progress.service.IRiskCorrectionService;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("riskCorrection") 
public class RiskCorrectionBpmServiceImpl implements ICommonBusinessService {


	@Autowired
	private IRiskCorrectionService correctionService;

	@Autowired
	private IRiskCorrectionHistoryService historyService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO

		RiskCorrectionEntity entity = correctionService.selectById(billId);
		// 修改处理状态为 待处理
		entity.setHandleStatus("0");
		// 设置纠偏开始时间
		entity.setStartTime(new Date());
		correctionService.saveOrUpdate(entity);

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		LambdaQueryWrapper<RiskCorrectionHistoryEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(RiskCorrectionHistoryEntity::getRiskId, billId).eq(RiskCorrectionHistoryEntity::getDr, 0);

		List<RiskCorrectionHistoryEntity> list = historyService.list(wrapper);
		list = list.stream().filter(entity -> !entity.getRiskState().equals(RiskStateEnum.CREATE.getCode())).collect(Collectors.toList());

		if (CollectionUtil.isNotEmpty(list)) {
			return CommonResponse.error("撤回失败，当前纠偏单存在处理记录！");
		}

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){

		RiskCorrectionEntity entity = correctionService.selectById(billId);
		entity.setHandleStatus(null);
		entity.setStartTime(null);
		correctionService.saveOrUpdate(entity);

		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		RiskCorrectionEntity entity = correctionService.selectById(billId);
		// 修改处理状态为 待处理
		entity.setHandleStatus("0");
		// 设置纠偏开始时间
		entity.setStartTime(new Date());
		correctionService.saveOrUpdate(entity);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		LambdaQueryWrapper<RiskCorrectionHistoryEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(RiskCorrectionHistoryEntity::getRiskId, billId).eq(RiskCorrectionHistoryEntity::getDr, 0);

		List<RiskCorrectionHistoryEntity> list = historyService.list(wrapper);
		list = list.stream().filter(entity -> !entity.getRiskState().equals(RiskStateEnum.CREATE.getCode())).collect(Collectors.toList());

		if (CollectionUtil.isNotEmpty(list)) {
			return CommonResponse.error("撤回失败，当前纠偏单存在处理记录！");
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RiskCorrectionEntity entity = correctionService.selectById(billId);
		entity.setHandleStatus(null);
		entity.setStartTime(null);
		correctionService.saveOrUpdate(entity);

		return CommonResponse.success();
	}

}
