package com.ejianc.business.progress.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class DateUtil2 {
    /**
     * 两个日期相差的天数+1
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static Integer getSubDay(String startDate, String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        long betweenDays = 0L;
        try {
            cal.setTime(sdf.parse(startDate));
            long time1 = cal.getTimeInMillis();
            cal.setTime(sdf.parse(endDate));
            long time2 = cal.getTimeInMillis();
            betweenDays = (time2 - time1) / (1000 * 3600 * 24);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return Integer.parseInt(String.valueOf(betweenDays)) + 1;
    }

    /**
     * 两个日期相差的天数+1
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static Integer getSubDay(Date startDate, Date endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        long betweenDays = 0L;
        try {
            cal.setTime(sdf.parse(sdf.format(startDate)));
            long time1 = cal.getTimeInMillis();
            cal.setTime(sdf.parse(sdf.format(endDate)));
            long time2 = cal.getTimeInMillis();
            betweenDays = (time2 - time1) / (1000 * 3600 * 24);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return Integer.parseInt(String.valueOf(betweenDays)) + 1;
    }

    /**
     * 两个日期相差的天数+1
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static Integer getSubDay2(Date startDate, Date endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        long betweenDays = 0L;
        try {
            cal.setTime(sdf.parse(sdf.format(startDate)));
            long time1 = cal.getTimeInMillis();
            cal.setTime(sdf.parse(sdf.format(endDate)));
            long time2 = cal.getTimeInMillis();
            betweenDays = (time2 - time1) / (1000 * 3600 * 24);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        if (betweenDays < 0) {
            return Integer.parseInt(String.valueOf(betweenDays)) - 1;
        }else {
            return Integer.parseInt(String.valueOf(betweenDays)) + 1;
        }

    }

    /**
     * 比较日期大小,如2020-10-23格式
     *
     * @param t1
     * @param t2
     * @return
     */
    public static int compareTime(String t1, String t2) {
        int trr1 = Integer.parseInt(t1.replaceAll("-", ""));
        int trr2 = Integer.parseInt(t2.replaceAll("-", ""));
        if (trr1 > trr2) {
            return 1;
        } else if (trr1 < trr2) {
            return -1;
        }
        return 0;
    }

    /**
     * 获取某个日期的最后一天的日期
     *
     * @param t1
     * @return
     */
    public static String lastdayOfMonth(String t1) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(t1));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        //获取当前时间下，该月的最大日期的数字
        int lastDay = cal.getActualMaximum(Calendar.DAY_OF_MONTH);
        //将获取的最大日期数设置为Calendar实例的日期数
        cal.set(Calendar.DAY_OF_MONTH, lastDay);
        return sdf.format(cal.getTime());
    }

    /**
     * 查询日期集合中最大日期或最小日期
     *
     * @param list
     * @param type,0-最小值，1-最大值
     * @return
     */
    public static String mostDate(List<String> list, int type) {
        String t = null;
        if (list.size() <= 0) {
            return t;
        } else {
            t = list.get(0);
            for (String d : list) {
                if (type == 0) {
                    if (compareTime(t, d) > 0) {
                        t = d;
                    }
                }
                if (type == 1) {
                    if (compareTime(t, d) < 0) {
                        t = d;
                    }
                }
            }
            return t;
        }
    }


    /**
     * 格式化日期
     *
     * @param dateTime
     * @return
     */
    public static Date formatDate(String dateTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(dateTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return date;

    }

    /**
     * 取交集
     *
     * @return
     */
    public static Map<String, String> getMostDate(Date start1, Date end1, Date start2, Date end2) {
        Map<String, String> mostDate = new HashMap<>();
        // a,起始日期，b,结束日期
        // c,起始日期，d,结束日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        long a = start1.getTime();
        long b = end1.getTime();
        long c = start2.getTime();
        long d = end2.getTime();
        String start = null;
        String end = null;
        if (a >= c && a <= d) {
            start = sdf.format(a);
        } else if (a > c && a > d) {
            start = null;
        } else if (a <= c && c <= b) {
            start = sdf.format(c);
        } else if (a < c && b < c) {
            start = null;
        }

        if (d < a) {
            end = null;
        } else if (d >= a && d <= b) {
            end = sdf.format(d);
        } else if (d >= b && c <= b) {
            end = sdf.format(b);
        } else if (d > b && c > b) {
            end = null;
        }
        mostDate.put("start", start);
        mostDate.put("end", end);
        return mostDate;
    }

    /**
     * 加天数
     *
     * @param sdf
     * @param d
     * @param len
     * @return
     */
    public static String dateAdd(SimpleDateFormat sdf, String d, Integer len) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(d));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        cal.add(Calendar.DATE, len);
        return sdf.format(cal.getTime());
    }

    /**
     * 获取近 len 个月的第一个周一开始时间
     * @param format
     * @param len
     * @return
     */
    public static String getWeekOfMonthStartDate(SimpleDateFormat format, int len) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(Calendar.MONTH, 1-len);
        c.set(Calendar.DATE,1);
        c.setFirstDayOfWeek(Calendar.MONDAY);//设置一个星期的第一天，按中国的习惯一个星期的第一天是星期一
        c.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);//周一
        Date m1 = c.getTime();
        String mon1 = format.format(m1);
        return mon1;
    }


    public static void main(String[] args) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(Calendar.MONTH, -2);
        c.set(Calendar.DATE,1);
        int i = c.get(Calendar.DAY_OF_WEEK);
//        Date m3 = c.getTime();
//        String mon3 = format.format(m3);
//        System.out.println("进三个月："+mon3);
//        if(i==1){
//            System.out.println("今天是周"+7);
//        }else{
//            System.out.println("今天是周"+(i-1));
//        }
        c.setFirstDayOfWeek(Calendar.MONDAY);//设置一个星期的第一天，按中国的习惯一个星期的第一天是星期一
        c.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);//周一
        Date m1 = c.getTime();
        String mon1 = format.format(m1);
        System.out.println("周开始："+mon1);




    }
}
