package com.ejianc.business.progress.utils;

public class InnerCodeTool {

	public static synchronized String getNewValue(int length) {
		StringBuilder code = new StringBuilder();
		for (int i = 0; i < length - 1; i++) {
			code.append("0");
		}
		code.append("1");
		return code.toString();
	}

	/**
	 * 以 0-9 A-Z a-z 范围的字符计数器函数。计数顺序是以上述字符的ascii码的大小来排序。 考虑到可能运行在多线程环境，加了同步锁。
	 *
	 * @param param 计数参数
	 * @return param加1后的数值
	 * @throws Exception
	 */
	public static synchronized String getNextValue(String param, int length) {
		// 空值校验
		if (param == null || param.length() == 0) {
			return getNewValue(length);
		}
		// 非法字符校验
		char[] paramChars = param.toCharArray();
		for (int i = 0; i < paramChars.length; i++) {
			char chr = paramChars[i];
			boolean flag = (chr >= 48 && chr <= 57);
			if (!flag) {
				throw new RuntimeException("参数不合法，含有非数字的字符！");
			}
		}
		// 计数上限校验，不能超过最大长度位数。
//		if (length > 0) {
//			StringBuilder sb = new StringBuilder();
//			for (int i = 0; i < length; i++) {
//				sb.append('9');
//			}
//			if (sb.toString().equals(param)) {
//				throw new RuntimeException("参数不合法，已达上限'" + sb.toString() + "'！");
//			}
//		}

		boolean carry = false;
		for (int i = paramChars.length - 1; i >= 0; i--) {
			char chr = paramChars[i];
			// 逢'9'进位
			if (chr == '9') {
				paramChars[i] = '0';
				if (i == 0) {
					carry = true;
				}
			} else {
				chr++;
				paramChars[i] = chr;
				carry = false;
				break;
			}
		}
		param = new String(paramChars);
		if (carry) {
			param = "1" + param;
		}

		return param;
	}

}
