/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bim.helper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bim.helper.CacheHelper;
import com.ejianc.business.bim.helper.HttpDelTookit;
import com.ejianc.business.bim.helper.JSONHelper;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TokenHelper {
    private static Logger logger = null;
    public static final String BASE_HOST = "https://sales.dxbim.com:8443";
    private static final String APP_ID = "9204360f0a8a4bb8a5d523401f2872cb";
    private static final String SECURITY_KEY = "c3c48e5a92b74dbf862b77b348511978";
    public static final String TOKEN = "TOKEN";
    private static TokenHelper helper;

    private TokenHelper() {
    }

    @PostConstruct
    public void init() {
        helper = this;
        if (logger == null) {
            logger = LoggerFactory.getLogger(JSONHelper.class);
        }
    }

    public static JSONObject getTokenData() throws BusinessException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appId", APP_ID);
        params.put("securityKey", SECURITY_KEY);
        JSONObject json = null;
        try {
            String response = HttpTookit.postParameters((String)"https://sales.dxbim.com:8443/api/v3/auth/apptokens", params);
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        json = JSONHelper.castDataJson(json, JSONObject.class);
        TokenHelper.toLocalCache(json);
        return json;
    }

    private static void toLocalCache(JSONObject json) {
        CacheHelper.put(TOKEN, json.getString("token"));
    }

    public static JSONObject getFileStatus(String path) throws BusinessException {
        String url = "https://sales.dxbim.com:8443/api/v3/srv/fs/file/status";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
        params.put("path", path);
        JSONObject json = null;
        try {
            String response = HttpTookit.getAndHeader((String)url, params);
            json = JSONObject.parseObject((String)response);
            if (json.getIntValue("code") == 0 && json.get((Object)"data") == null) {
                TokenHelper.getTokenData();
                params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
                response = HttpTookit.getAndHeader((String)url, params);
                json = JSONObject.parseObject((String)response);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return JSONHelper.castDataJson(json, JSONObject.class);
    }

    public static JSONObject delFile(String path) throws BusinessException {
        String url = "https://sales.dxbim.com:8443/api/v3/srv/fs/file";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
        params.put("path", path);
        JSONObject json = null;
        try {
            String response = HttpDelTookit.deleteByJson(url, params);
            json = JSONObject.parseObject((String)response);
            if (json.getIntValue("code") == 0 && json.get((Object)"data") == null) {
                TokenHelper.getTokenData();
                params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
                response = HttpDelTookit.deleteByJson(url, params);
                json = JSONObject.parseObject((String)response);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return JSONHelper.castDataJson(json, JSONObject.class);
    }

    public static JSONObject getFileTree(String path) throws BusinessException {
        return TokenHelper.getFileTree(path, "tree");
    }

    public static JSONObject getFileTree(String path, String format) throws BusinessException {
        String url = "https://sales.dxbim.com:8443/api/v3/srv/fs/file/tree";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
        params.put("path", path);
        params.put("format", format);
        JSONObject json = null;
        try {
            String response = HttpTookit.getAndHeader((String)url, params);
            json = JSONObject.parseObject((String)response);
            if (json.getIntValue("code") == 0 && json.get((Object)"data") == null) {
                TokenHelper.getTokenData();
                params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
                response = HttpTookit.getAndHeader((String)url, params);
                json = JSONObject.parseObject((String)response);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return JSONHelper.castDataJson(json, JSONObject.class);
    }

    public static void main(String[] args) {
        String path = "opendx/9204360f0a8a4bb8a5d523401f2872cb/ef34af2b93e24b4ea6ea6f8cc63e6d17/ef34af2b93e24b4ea6ea6f8cc63e6d17.rvt";
        JSONObject json = TokenHelper.getFileTree(path, "flat");
        System.out.println(json);
    }
}

