/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fill.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.fill.bean.DayFillDetailEntity;
import com.ejianc.business.fill.bean.DayFillEntity;
import com.ejianc.business.fill.mapper.DayFillDetailMapper;
import com.ejianc.business.fill.mapper.DayFillMapper;
import com.ejianc.business.fill.service.IDayFillDetailService;
import com.ejianc.business.fill.service.IDayFillService;
import com.ejianc.business.fill.util.PageUtil;
import com.ejianc.business.fill.util.WarnFeignUtil;
import com.ejianc.business.fill.vo.DayFillDetailVO;
import com.ejianc.business.fill.vo.DayFillVO;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.BaseDetailVO;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.business.progress.utils.WarnDateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dayFillService")
public class DayFillServiceImpl
extends BaseServiceImpl<DayFillMapper, DayFillEntity>
implements IDayFillService {
    private static final String BILL_CODE = "ZJKJ_DAY_FILL";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private DayFillMapper dayFillMapper;
    @Autowired
    private DayFillDetailMapper dayFillDetailMapper;
    @Autowired
    private IDayFillDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private WarnFeignUtil feignUtil;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;
    private static final List<Long> diffTypes = new ArrayList<Long>(Arrays.asList(1607284873290158082L, 1607284911340883970L, 1607285065540276225L, 1607285101045059585L, 1607285151582228482L, 1607285189104472066L, 1607285573499850754L));

    @Override
    public CommonResponse<DayFillVO> saveOrUpdate(DayFillVO saveOrUpdateVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DayFillEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        queryWrapper.eq(DayFillEntity::getFillUserId, (Object)saveOrUpdateVO.getFillUserId());
        queryWrapper.notIn(DayFillEntity::getBillState, new Object[]{1, 3});
        queryWrapper.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
        queryWrapper2.eq(DayFillEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        queryWrapper2.eq(DayFillEntity::getFillUserId, (Object)saveOrUpdateVO.getFillUserId());
        queryWrapper2.in(DayFillEntity::getBillState, new Object[]{1, 3});
        queryWrapper2.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        queryWrapper2.orderByDesc(DayFillEntity::getFillDate);
        List list2 = this.list((Wrapper)queryWrapper2);
        if (CollectionUtils.isNotEmpty((Collection)list2) && saveOrUpdateVO.getFillDate().getTime() <= ((DayFillEntity)((Object)list2.get(0))).getFillDate().getTime()) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f80\u671f\u586b\u62a5\u65e5\u671f");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        DayFillEntity progressEntity = null;
        saveOrUpdateVO.setFinishFlag(Integer.valueOf(DateUtil.getBetweenDays(saveOrUpdateVO.getFillDate(), new Date()) + 1));
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
            saveOrUpdateVO.setUpdateUserId(this.sessionManager.getUserContext().getUserId());
            saveOrUpdateVO.setUpdateUserName(this.sessionManager.getUserContext().getUserName());
            saveOrUpdateVO.setUpdateDate(new Date());
            progressEntity = (DayFillEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DayFillEntity.class));
            this.dayFillMapper.updateById((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
                if (saveOrUpdateVO.getImportFlag().booleanValue()) {
                    this.detailService.deleteByProgressId(progressEntity.getId());
                }
                ArrayList<DayFillDetailEntity> saveList = new ArrayList<DayFillDetailEntity>();
                ArrayList<DayFillDetailEntity> updateList = new ArrayList<DayFillDetailEntity>();
                Iterator iterator = saveVOList.iterator();
                while (iterator.hasNext()) {
                    DayFillDetailEntity progressDetailEntity;
                    DayFillDetailVO progressDetailVo = (DayFillDetailVO)iterator.next();
                    progressDetailVo.setPredictStart(DateUtil.setHours(progressDetailVo.getPredictStart(), 8));
                    if (saveOrUpdateVO.getImportFlag().booleanValue() || "added".equals(progressDetailVo.get_state())) {
                        progressDetailEntity = DayFillDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        progressDetailEntity.setPlanStart(DateUtil.setHours(progressDetailEntity.getPlanStart(), 8));
                        progressDetailEntity.setPlanFinish(DateUtil.setHours(progressDetailEntity.getPlanFinish(), 17));
                        progressDetailEntity.setActualStart(DateUtil.setHours(progressDetailEntity.getActualStart(), 8));
                        progressDetailEntity.setActualFinish(DateUtil.setHours(progressDetailEntity.getActualFinish(), 17));
                        progressDetailEntity.setEstimateFinish(DateUtil.setHours(progressDetailEntity.getEstimateFinish(), 17));
                        progressDetailEntity.setPredictStart(DateUtil.setHours(progressDetailEntity.getPredictStart(), 8));
                        saveList.add(progressDetailEntity);
                        continue;
                    }
                    if (!"modified".equals(progressDetailVo.get_state())) continue;
                    progressDetailEntity = DayFillDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(progressEntity.getId());
                    progressDetailEntity.setPlanStart(DateUtil.setHours(progressDetailEntity.getPlanStart(), 8));
                    progressDetailEntity.setPlanFinish(DateUtil.setHours(progressDetailEntity.getPlanFinish(), 17));
                    progressDetailEntity.setActualStart(DateUtil.setHours(progressDetailEntity.getActualStart(), 8));
                    progressDetailEntity.setActualFinish(DateUtil.setHours(progressDetailEntity.getActualFinish(), 17));
                    progressDetailEntity.setEstimateFinish(DateUtil.setHours(progressDetailEntity.getEstimateFinish(), 17));
                    progressDetailEntity.setPredictStart(DateUtil.setHours(progressDetailEntity.getPredictStart(), 8));
                    updateList.add(progressDetailEntity);
                }
                if (saveList.size() > 0) {
                    this.detailService.saveBatch(saveList);
                }
                if (updateList.size() > 0) {
                    this.detailService.updateBatchById(updateList);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (DayFillDetailVO progressDetailVo : delDetailList) {
                    this.dayFillDetailMapper.deleteById((Serializable)((Object)progressDetailVo.getUid()));
                }
            }
        } else {
            Long masterPkId = IdWorker.getId();
            if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveOrUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            progressEntity = (DayFillEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DayFillEntity.class));
            progressEntity.setId(masterPkId);
            this.dayFillMapper.insert((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
                ArrayList<DayFillDetailEntity> saveList = new ArrayList<DayFillDetailEntity>();
                for (DayFillDetailVO progressDetailVo : saveVOList) {
                    DayFillDetailEntity progressDetailEntity = DayFillDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    progressDetailEntity.setPlanStart(DateUtil.setHours(progressDetailEntity.getPlanStart(), 8));
                    progressDetailEntity.setPlanFinish(DateUtil.setHours(progressDetailEntity.getPlanFinish(), 17));
                    progressDetailEntity.setActualStart(DateUtil.setHours(progressDetailEntity.getActualStart(), 8));
                    progressDetailEntity.setActualFinish(DateUtil.setHours(progressDetailEntity.getActualFinish(), 17));
                    progressDetailEntity.setEstimateFinish(DateUtil.setHours(progressDetailEntity.getEstimateFinish(), 17));
                    progressDetailEntity.setPredictStart(DateUtil.setHours(progressDetailEntity.getPredictStart(), 8));
                    saveList.add(progressDetailEntity);
                }
                this.detailService.saveBatch(saveList);
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        return CommonResponse.success((Object)this.queryDetail(progressEntity.getId()));
    }

    @Override
    public DayFillVO queryDetail(Long id) {
        DayFillEntity progressEntity = (DayFillEntity)((Object)((DayFillMapper)this.baseMapper).selectById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.detailService.list((Wrapper)queryWrapper);
        DayFillVO progressVo = (DayFillVO)BeanMapper.map((Object)((Object)progressEntity), DayFillVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<DayFillDetailVO> progressDetailVoList = new ArrayList<DayFillDetailVO>();
            for (DayFillDetailEntity progressDetailEntity : progressDetailList) {
                progressDetailVoList.add(DayFillDetailEntity.convertEntityToVo(progressDetailEntity));
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public Map getExecPlan(DayFillVO vo) {
        List list;
        if (vo.getFillDate().getTime() > new Date().getTime()) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65e5\u671f");
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ExecPlanEntity::getProjectId, (Object)vo.getProjectId());
        ExecPlanEntity execPlanEntity = (ExecPlanEntity)((Object)this.execPlanService.getOne((Wrapper)queryWrapper));
        if (execPlanEntity == null) {
            throw new BusinessException("\u8be5\u9879\u76ee\u6ca1\u6709\u505a\u8ba1\u5212");
        }
        LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
        queryWrapper1.eq(DayFillEntity::getProjectId, (Object)vo.getProjectId());
        queryWrapper1.eq(DayFillEntity::getFillUserId, (Object)vo.getFillUserId());
        queryWrapper1.notIn(DayFillEntity::getBillState, new Object[]{1, 3});
        if (vo.getId() != null) {
            queryWrapper1.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.list((Wrapper)queryWrapper1)))) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5b58\u5728\u672a\u751f\u6548\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
        queryWrapper2.eq(DayFillEntity::getProjectId, (Object)vo.getProjectId());
        queryWrapper2.eq(DayFillEntity::getFillUserId, (Object)vo.getFillUserId());
        queryWrapper2.in(DayFillEntity::getBillState, new Object[]{1, 3});
        queryWrapper2.orderByDesc(DayFillEntity::getFillDate);
        List list2 = this.list((Wrapper)queryWrapper2);
        if (CollectionUtils.isNotEmpty((Collection)list2) && vo.getFillDate().getTime() <= ((DayFillEntity)((Object)list2.get(0))).getFillDate().getTime()) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f80\u671f\u586b\u62a5\u65e5\u671f");
        }
        resMap.put("UID", execPlanEntity.getId());
        resMap.put("Calendars", execPlanEntity.getCalendars());
        resMap.put("CalendarUID", execPlanEntity.getCalendarUid());
        resMap.put("fillVersion", execPlanEntity.getFillVersion());
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)execPlanEntity.getId());
        ew.orderByAsc((Object)"tid");
        List execPlanDetailEntities = this.execPlanDetailService.list((Wrapper)ew);
        Date startDate = null;
        Date finishDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        JSONObject calender = DurationUtil.getCalender(execPlanEntity.getCalendars(), execPlanEntity.getCalendarUid());
        if (execPlanDetailEntities.size() <= 0) {
            resMap.put("Tasks", new ArrayList());
            resMap.put("StartDate", sdf.format(new Date()));
            resMap.put("FinishDate", sdf.format(new Date()));
        } else {
            List<Object> detailVOS = new ArrayList<ExecPlanDetailVO>();
            if (CollectionUtils.isNotEmpty((Collection)execPlanDetailEntities)) {
                List epds = BeanMapper.mapList((Iterable)execPlanDetailEntities, ExecPlanDetailEntity.class);
                ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
                for (ExecPlanDetailEntity detail : epds) {
                    detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
                }
                detailVOS = TreeHelper2.list2Tree(detailVOList);
            }
            ArrayList<String> leafList = new ArrayList<String>();
            this.getLeaf(leafList, detailVOS);
            ArrayList<DayFillDetailVO> tasks = new ArrayList();
            LinkedList<ExecPlanDetailEntity> result = DayFillServiceImpl.sort(execPlanDetailEntities);
            for (ExecPlanDetailEntity epd : execPlanDetailEntities) {
                DayFillDetailEntity dvoEntity = (DayFillDetailEntity)((Object)BeanMapper.map((Object)((Object)epd), DayFillDetailEntity.class));
                DayFillDetailVO dvo = DayFillDetailEntity.convertEntityToVo(dvoEntity);
                dvo.setStart(epd.getActualStart() != null ? epd.getActualStart() : epd.getPredictStart());
                dvo.setFinish(epd.getActualFinish() != null ? epd.getActualFinish() : (epd.getEstimateFinish() != null ? epd.getEstimateFinish() : epd.getPredictFinish()));
                dvo.setDuration(DurationUtil.calculateDuration(dvo.getStart(), dvo.getFinish(), calender));
                dvo.setPlanDuration(epd.getDuration());
                dvo.setPredictStart(epd.getPredictStart());
                dvo.setStartSourceType(Integer.valueOf(dvo.getActualStart() == null ? 0 : 1));
                if (leafList.contains(epd.getStructCode())) {
                    dvo.setLeafFlag(Boolean.valueOf(true));
                } else {
                    dvo.setLeafFlag(Boolean.valueOf(false));
                }
                dvo.setFixedDate(Integer.valueOf(0));
                if (dvo.getActualStart() == null && dvo.getConstraintType() == 4 && (CollectionUtils.isNotEmpty((Collection)dvo.getPredecessorLink()) || dvo.getLeafFlag().booleanValue() && WarnDateUtil.compareDate(dvo.getConstraintDate(), vo.getFillDate()) < 0)) {
                    dvo.setConstraintDate(DateUtil.setHours(vo.getFillDate(), 8));
                }
                dvo.setPlanPreLink(this.getPlanPreLink(result, dvo.getPredecessorLink()));
                dvo.setThisPlanNum(dvo.getNextPlanNum());
                dvo.setLastFinishNum(dvo.getFinishNum());
                tasks.add(dvo);
                if (startDate == null) {
                    startDate = epd.getStart();
                } else {
                    Date date = startDate = startDate.getTime() > epd.getStart().getTime() ? epd.getStart() : startDate;
                }
                if (finishDate == null) {
                    finishDate = epd.getFinish();
                    continue;
                }
                finishDate = finishDate.getTime() < epd.getFinish().getTime() ? epd.getFinish() : finishDate;
            }
            tasks = TreeHelper2.list2Tree(tasks);
            this.dealParentTask(calender, vo.getFillDate(), tasks);
            resMap.put("Tasks", tasks);
            resMap.put("StartDate", sdf.format(startDate));
            resMap.put("FinishDate", sdf.format(finishDate));
        }
        return resMap;
    }

    private static LinkedList<ExecPlanDetailEntity> sort(List<ExecPlanDetailEntity> sourceList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return new LinkedList<ExecPlanDetailEntity>();
        }
        List list = (List)Utils.deepCopy(sourceList);
        LinkedList<ExecPlanDetailEntity> result = new LinkedList<ExecPlanDetailEntity>();
        DayFillServiceImpl.toSort(list, result, -1L);
        return result;
    }

    private static LinkedList<ExecPlanDetailEntity> toSort(List<ExecPlanDetailEntity> list, LinkedList<ExecPlanDetailEntity> result, Long parentId) {
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        List temp = list.stream().filter(x -> x.getParentId().equals(parentId)).collect(Collectors.toList());
        if (temp.size() < 1) {
            return result;
        }
        list = list.stream().filter(x -> !x.getParentId().equals(parentId)).collect(Collectors.toList());
        temp = temp.stream().sorted(Comparator.comparing(ProgressDetailEntity::getTid)).collect(Collectors.toList());
        for (ExecPlanDetailEntity vo : temp) {
            result.add(vo);
            DayFillServiceImpl.toSort(list, result, vo.getId());
        }
        return result;
    }

    private String getPlanPreLink(LinkedList<ExecPlanDetailEntity> result, JSONArray predecessorLink) {
        ArrayList<String> strs = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)predecessorLink)) {
            return null;
        }
        for (Object o : predecessorLink) {
            JSONObject obj = (JSONObject)o;
            Integer index = -1;
            for (int i = 0; i < result.size(); ++i) {
                if (!result.get(i).getId().equals(obj.getLong("PredecessorUID"))) continue;
                index = i + 1;
            }
            if (index == -1) continue;
            StringBuffer str = new StringBuffer();
            str.append(index);
            if (obj.getInteger("Type") == 0) {
                str.append("FF");
            } else if (obj.getInteger("Type") == 1 && obj.getInteger("LinkLag") != 0) {
                str.append("FS");
            } else if (obj.getInteger("Type") == 2) {
                str.append("SF");
            } else if (obj.getInteger("Type") == 3) {
                str.append("SS");
            }
            if (obj.getInteger("LinkLag") > 0) {
                str.append("+" + obj.getInteger("LinkLag"));
            } else if (obj.getInteger("LinkLag") < 0) {
                str.append(obj.getInteger("LinkLag"));
            }
            strs.add(str.toString());
        }
        return strs.stream().collect(Collectors.joining(","));
    }

    @Override
    public Map getExecPlanMobile(DayFillVO vo) {
        List list;
        vo.setFillDate(new Date());
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ExecPlanEntity::getProjectId, (Object)vo.getProjectId());
        ExecPlanEntity execPlanEntity = (ExecPlanEntity)((Object)this.execPlanService.getOne((Wrapper)queryWrapper));
        if (execPlanEntity == null) {
            throw new BusinessException("\u8be5\u9879\u76ee\u6ca1\u6709\u505a\u8ba1\u5212");
        }
        LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
        queryWrapper1.eq(DayFillEntity::getProjectId, (Object)vo.getProjectId());
        queryWrapper1.notIn(DayFillEntity::getBillState, new Object[]{1, 3});
        if (vo.getId() != null) {
            queryWrapper1.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.list((Wrapper)queryWrapper1)))) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5b58\u5728\u672a\u751f\u6548\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
        queryWrapper2.eq(DayFillEntity::getProjectId, (Object)vo.getProjectId());
        if (!vo.getFillUserId().equals(303581417601122400L)) {
            queryWrapper2.eq(DayFillEntity::getFillUserId, (Object)vo.getFillUserId());
        }
        queryWrapper2.in(DayFillEntity::getBillState, new Object[]{1, 3});
        queryWrapper2.orderByDesc(DayFillEntity::getFillDate);
        List list2 = this.list((Wrapper)queryWrapper2);
        if (CollectionUtils.isNotEmpty((Collection)list2) && vo.getFillDate().getTime() <= ((DayFillEntity)((Object)list2.get(0))).getFillDate().getTime()) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f80\u671f\u586b\u62a5\u65e5\u671f");
        }
        resMap.put("UID", execPlanEntity.getId());
        resMap.put("Calendars", execPlanEntity.getCalendars());
        resMap.put("CalendarUID", execPlanEntity.getCalendarUid());
        resMap.put("fillVersion", execPlanEntity.getFillVersion());
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)execPlanEntity.getId());
        ew.orderByAsc((Object)"tid");
        List execPlanDetailEntities = this.execPlanDetailService.list((Wrapper)ew);
        Date startDate = null;
        Date finishDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        JSONObject calender = DurationUtil.getCalender(execPlanEntity.getCalendars(), execPlanEntity.getCalendarUid());
        if (execPlanDetailEntities.size() <= 0) {
            resMap.put("Tasks", new ArrayList());
            resMap.put("StartDate", sdf.format(new Date()));
            resMap.put("FinishDate", sdf.format(new Date()));
        } else {
            List<Object> detailVOS = new ArrayList<ExecPlanDetailVO>();
            if (CollectionUtils.isNotEmpty((Collection)execPlanDetailEntities)) {
                List epds = BeanMapper.mapList((Iterable)execPlanDetailEntities, ExecPlanDetailEntity.class);
                ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
                for (ExecPlanDetailEntity detail : epds) {
                    detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
                }
                detailVOS = TreeHelper2.list2Tree(detailVOList);
            }
            ArrayList<String> leafList = new ArrayList<String>();
            this.getLeaf(leafList, detailVOS);
            HashMap<String, String> pmap = new HashMap<String, String>();
            this.getParentName(pmap, detailVOS, null);
            ArrayList<DayFillDetailVO> tasks = new ArrayList();
            ArrayList<Object> detailList = new ArrayList<Object>();
            LinkedList<ExecPlanDetailEntity> result = DayFillServiceImpl.sort(execPlanDetailEntities);
            List<DefdocDetailVO> defDocList = this.feignUtil.getDefDocListById(662323828479377468L);
            for (ExecPlanDetailEntity epd : execPlanDetailEntities) {
                DayFillDetailEntity dvoEntity = (DayFillDetailEntity)((Object)BeanMapper.map((Object)((Object)epd), DayFillDetailEntity.class));
                DayFillDetailVO dvo = DayFillDetailEntity.convertEntityToVo(dvoEntity);
                dvo.setStart(epd.getActualStart() != null ? epd.getActualStart() : epd.getPredictStart());
                dvo.setFinish(epd.getActualFinish() != null ? epd.getActualFinish() : (epd.getEstimateFinish() != null ? epd.getEstimateFinish() : epd.getPredictFinish()));
                dvo.setDuration(DurationUtil.calculateDuration(dvo.getStart(), dvo.getFinish(), calender));
                dvo.setPlanDuration(epd.getDuration());
                dvo.setPredictStart(epd.getPredictStart());
                dvo.setStartSourceType(Integer.valueOf(dvo.getActualStart() == null ? 0 : 1));
                if (leafList.contains(epd.getStructCode())) {
                    dvo.setLeafFlag(Boolean.valueOf(true));
                } else {
                    dvo.setLeafFlag(Boolean.valueOf(false));
                }
                dvo.setFixedDate(Integer.valueOf(0));
                dvo.setParentName((String)pmap.get(dvo.getStructCode()));
                dvo.setDiffTypeName(this.feignUtil.getDefDocDetail(defDocList, dvo.getDiffType()).getName());
                if (dvo.getActualStart() == null && dvo.getConstraintType() == 4 && (CollectionUtils.isNotEmpty((Collection)dvo.getPredecessorLink()) || dvo.getLeafFlag().booleanValue() && WarnDateUtil.compareDate(dvo.getConstraintDate(), vo.getFillDate()) < 0)) {
                    dvo.setConstraintDate(DateUtil.setHours(vo.getFillDate(), 8));
                }
                dvo.setShowState(Boolean.valueOf(false));
                dvo.setPlanPreLink(this.getPlanPreLink(result, dvo.getPredecessorLink()));
                dvo.setThisPlanNum(dvo.getNextPlanNum());
                dvo.setLastFinishNum(dvo.getFinishNum());
                if (leafList.contains(epd.getStructCode()) && dvo.getActualFinish() == null && dvo.getStart().getTime() <= vo.getFillDate().getTime() && (dvo.getEmployeeId() != null && dvo.getEmployeeId().equals(vo.getFillUserId()) || vo.getFillUserId().equals(303581417601122400L))) {
                    if (dvo.getActualStart() != null) {
                        dvo.setFinishState(Integer.valueOf(1));
                    } else {
                        dvo.setFinishState(Integer.valueOf(0));
                    }
                    dvo.setShowState(Boolean.valueOf(true));
                    detailList.add(Utils.deepCopy((Object)dvo));
                }
                tasks.add((DayFillDetailVO)Utils.deepCopy((Object)dvo));
                if (startDate == null) {
                    startDate = epd.getStart();
                } else {
                    Date date = startDate = startDate.getTime() > epd.getStart().getTime() ? epd.getStart() : startDate;
                }
                if (finishDate == null) {
                    finishDate = epd.getFinish();
                    continue;
                }
                finishDate = finishDate.getTime() < epd.getFinish().getTime() ? epd.getFinish() : finishDate;
            }
            tasks = TreeHelper2.list2Tree(tasks);
            this.dealParentTask(calender, vo.getFillDate(), tasks);
            resMap.put("Tasks", tasks);
            resMap.put("progressDetailList", TreeHelper2.list2Tree(detailList));
            resMap.put("StartDate", sdf.format(startDate));
            resMap.put("FinishDate", sdf.format(finishDate));
        }
        return resMap;
    }

    @Override
    public JSONObject projectDiffTypeList(QueryParam param) {
        JSONObject page = new JSONObject();
        String text = param.getSearchText();
        int current = param.getPageIndex();
        int size = param.getPageSize();
        page.put("current", (Object)current);
        page.put("size", (Object)size);
        param.getFuzzyFields().add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        List fillList = super.queryList(param);
        if (CollectionUtils.isEmpty((Collection)fillList)) {
            page.put("records", new ArrayList());
            page.put("total", (Object)0);
            page.put("pages", (Object)0);
            return page;
        }
        List ids = fillList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("progress_id", new Parameter("in", ids));
        List detailList = this.detailService.queryList(detailParam);
        Map<Long, List<DayFillEntity>> fillMap = fillList.stream().collect(Collectors.groupingBy(DayFillEntity::getProjectId));
        Map<Long, List<DayFillDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(ProgressDetailEntity::getProgressId));
        List<Long> orgIds = fillList.stream().map(DayFillEntity::getOrgId).collect(Collectors.toList());
        Map<Long, OrgVO> corpMap = this.orgUtil.findListByIds(orgIds);
        JSONArray array = new JSONArray();
        for (Long projectId : fillMap.keySet()) {
            DayFillEntity fill = fillMap.get(projectId).stream().max(Comparator.comparing(BaseEntity::getCreateTime)).get();
            JSONObject obj = new JSONObject();
            obj.put("projectId", (Object)fill.getProjectId());
            obj.put("corpName", corpMap.containsKey(fill.getOrgId()) ? corpMap.get(fill.getOrgId()).getName() : null);
            obj.put("projectName", (Object)fill.getProjectName());
            this.calculateDiffTypes(fillMap.get(projectId), detailMap, obj);
            array.add((Object)obj);
        }
        int total = array.size();
        JSONArray records = PageUtil.listToPage(array, current, size);
        int pages = PageUtil.getPages(total, size);
        page.put("records", (Object)records);
        page.put("total", (Object)total);
        page.put("pages", (Object)pages);
        return page;
    }

    private void calculateDiffTypes(List<DayFillEntity> fillList, Map<Long, List<DayFillDetailEntity>> detailMap, JSONObject obj) {
        Integer num;
        int i;
        Integer sum = 0;
        for (i = 0; i < diffTypes.size(); ++i) {
            num = 0;
            Integer value = 0;
            Long diffType = diffTypes.get(i);
            for (DayFillEntity vo : fillList) {
                if (!detailMap.containsKey(vo.getId())) continue;
                List list = detailMap.get(vo.getId()).stream().filter(x -> x.getDiffType() != null && x.getDiffType().equals(diffType)).collect(Collectors.toList());
                num = num + list.size();
                BigDecimal diffValue = list.stream().map(DayFillDetailEntity::getDiffValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                value = value + diffValue.intValue();
            }
            sum = sum + num;
            obj.put("diffType0" + i, (Object)diffType);
            obj.put("num0" + i, (Object)num);
            obj.put("value0" + i, (Object)value);
        }
        obj.put("sum", (Object)sum);
        for (i = 0; i < diffTypes.size(); ++i) {
            num = obj.getIntValue("num0" + i);
            obj.put("rate0" + i, (Object)ComputeUtil.bigDecimalPercent((Integer)num, (Integer)sum, (int)2));
        }
    }

    @Override
    public DayFillVO resetExecPlan(Long id) {
        DayFillVO fill = this.queryDetail(id);
        List progressDetailList = TreeHelper2.tree2List(fill.getProgressDetailList());
        Map<String, DayFillDetailVO> detailMap = progressDetailList.stream().collect(Collectors.toMap(BaseDetailVO::getStructCode, x -> x));
        JSONObject calender = DurationUtil.getCalender(fill.getCalendars(), fill.getCalendarUid());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DayFillEntity::getProjectId, (Object)fill.getProjectId());
        wrapper.in(DayFillEntity::getBillState, new Object[]{1, 3});
        wrapper.orderByDesc(DayFillEntity::getFillDate);
        List list = super.list((Wrapper)wrapper);
        Date maxDate = CollectionUtils.isEmpty((Collection)list) || fill.getFillDate().getTime() > ((DayFillEntity)((Object)list.get(0))).getFillDate().getTime() ? fill.getFillDate() : ((DayFillEntity)((Object)list.get(0))).getFillDate();
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(ExecPlanEntity::getProjectId, (Object)fill.getProjectId());
        ExecPlanEntity exec = (ExecPlanEntity)((Object)this.execPlanService.getOne((Wrapper)ew));
        if (exec == null) {
            throw new BusinessException("\u8be5\u9879\u76ee\u6ca1\u6709\u505a\u8ba1\u5212");
        }
        fill.setImportFlag(Boolean.valueOf(true));
        fill.setFillVersion(exec.getFillVersion());
        QueryWrapper ew2 = new QueryWrapper();
        ew2.eq((Object)"progress_id", (Object)exec.getId());
        ew2.orderByAsc((Object)"tid");
        List detailList = this.execPlanDetailService.list((Wrapper)ew2);
        if (detailList.size() <= 0) {
            fill.setProgressDetailList(null);
            fill.setRemovedTasks(progressDetailList);
            return fill;
        }
        List<Object> detailVOList = new ArrayList<ExecPlanDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (ExecPlanDetailEntity detail : detailList) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            detailVOList = TreeHelper2.list2Tree(detailVOList);
        }
        ArrayList<String> leafList = new ArrayList<String>();
        this.getLeaf(leafList, detailVOList);
        ArrayList<DayFillDetailVO> tasks = new ArrayList();
        LinkedList<ExecPlanDetailEntity> result = DayFillServiceImpl.sort(detailList);
        for (ExecPlanDetailEntity detail : detailList) {
            if (!detailMap.containsKey(detail.getStructCode())) continue;
            DayFillDetailVO vo = DayFillDetailEntity.convertEntityToVo((DayFillDetailEntity)((Object)BeanMapper.map((Object)((Object)detail), DayFillDetailEntity.class)));
            vo.setStart(detail.getActualStart() != null ? detail.getActualStart() : detail.getPredictStart());
            vo.setFinish(detail.getActualFinish() != null ? detail.getActualFinish() : (detail.getEstimateFinish() != null ? detail.getEstimateFinish() : detail.getPredictFinish()));
            if (leafList.contains(detail.getStructCode())) {
                vo.setLeafFlag(Boolean.valueOf(true));
            } else {
                vo.setLeafFlag(Boolean.valueOf(false));
            }
            vo.setFixedDate(Integer.valueOf(0));
            vo.setPlanPreLink(this.getPlanPreLink(result, vo.getPredecessorLink()));
            vo.setShowState(Boolean.valueOf(true));
            DayFillDetailVO old = detailMap.get(vo.getStructCode());
            if (vo.getLeafFlag().booleanValue() && old.getActualStart() != null && fill.getFillUserId().equals(InvocationInfoProxy.getUserid())) {
                vo.setActualStart(old.getActualStart());
                vo.setActualFinish(old.getActualFinish());
                vo.setEstimateFinish(old.getEstimateFinish());
                vo.setStart(old.getActualStart() != null ? old.getActualStart() : detail.getPredictStart());
                vo.setFinish(old.getActualFinish() != null ? old.getActualFinish() : (old.getEstimateFinish() != null ? old.getEstimateFinish() : detail.getPredictFinish()));
                vo.setPercentComplete(old.getPercentComplete());
                vo.setFinishNum(old.getFinishNum());
                vo.setDiffValue(new BigDecimal(DateUtil.getBetweenDays(vo.getFinish(), vo.getPlanFinish())));
                vo.setDiffType(old.getDiffType());
                vo.setDiffResson(old.getDiffResson());
                vo.setResourceNum(old.getResourceNum());
                vo.setDiffNum(old.getDiffNum());
                if (vo.getActualStart() != null) {
                    vo.setPredecessorLink(null);
                }
            }
            vo.setDuration(DurationUtil.calculateDuration(vo.getStart(), vo.getFinish(), calender));
            if (vo.getLeafFlag().booleanValue() && DateUtil.compareDay(vo.getStart(), fill.getFillDate()) < 0 && vo.getActualStart() == null) {
                vo.setStart(DateUtil.setHours(fill.getFillDate(), 8));
                vo.setConstraintType(Integer.valueOf(4));
                vo.setConstraintDate(vo.getStart());
            }
            if (vo.getActualStart() == null && vo.getConstraintType() == 4 && (CollectionUtils.isNotEmpty((Collection)vo.getPredecessorLink()) || vo.getLeafFlag().booleanValue() && WarnDateUtil.compareDate(vo.getConstraintDate(), fill.getFillDate()) < 0)) {
                vo.setConstraintDate(DateUtil.setHours(fill.getFillDate(), 8));
            }
            vo.setShowState(old.getShowState());
            vo.setPlanDuration(detail.getDuration());
            vo.setStartSourceType(Integer.valueOf(vo.getActualStart() == null ? 0 : 1));
            vo.setThisPlanNum(old.getThisPlanNum());
            vo.setThisFinishNum(old.getThisFinishNum());
            vo.setThisPercentComplete(old.getThisPercentComplete());
            vo.setPercentComplete(old.getPercentComplete());
            vo.setLastFinishNum(vo.getFinishNum());
            tasks.add(vo);
        }
        tasks = TreeHelper2.list2Tree(tasks);
        this.dealParentTask(calender, maxDate, tasks);
        fill.setProgressDetailList(tasks);
        return fill;
    }

    private void dealParentTask(JSONObject calender, Date maxDate, List<DayFillDetailVO> tasks) {
        for (DayFillDetailVO task : tasks) {
            if (CollectionUtils.isEmpty((Collection)task.getChildren())) continue;
            this.dealParentTask(calender, maxDate, task.getChildren());
            List childList = (List)Utils.deepCopy((Object)task.getChildren());
            Date Finish = task.getFinish();
            task.setStart((Date)childList.stream().map(BaseDetailVO::getStart).filter(Objects::nonNull).min(Comparator.comparing(x -> x)).orElse(null));
            task.setFinish((Date)childList.stream().map(BaseDetailVO::getFinish).filter(Objects::nonNull).max(Comparator.comparing(x -> x)).orElse(null));
            task.setDuration(DurationUtil.calculateDuration(task.getStart(), task.getFinish(), calender));
            task.setActualStart(task.getStart());
            if (task.getChildren().stream().filter(x -> x.getActualStart() != null).count() == 0L) {
                task.setActualStart(null);
            }
            if (task.getActualFinish() != null) {
                task.setFixedDate(Integer.valueOf(1));
            }
            if (task.getChildren().stream().filter(x -> x.getPercentComplete() != null && x.getPercentComplete() > 0).count() == 0L) {
                task.setPercentComplete(Integer.valueOf(0));
            }
            if (task.getChildren().stream().filter(x -> x.getActualFinish() == null).count() == 0L) {
                task.setActualFinish(task.getFinish());
                task.setEstimateFinish(null);
            } else {
                task.setEstimateFinish(task.getFinish());
                task.setActualFinish(null);
            }
            task.setDiffValue(new BigDecimal(DateUtil.getBetweenDays(task.getFinish(), task.getPlanFinish())));
            BigDecimal percentComplete = this.calculatePercentComplete(maxDate, task);
            task.setPercentComplete(Integer.valueOf(percentComplete.intValue()));
            BigDecimal finishNum = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)new BigDecimal(task.getPercentComplete()), (BigDecimal)new BigDecimal("100")), (BigDecimal)task.getPlanNum());
            task.setFinishNum(finishNum);
            if (task.getActualStart() != null && task.getPercentComplete() != 0) continue;
            task.setActualFinish(null);
            task.setEstimateFinish(null);
            task.setFinishNum(null);
        }
    }

    private BigDecimal calculatePercentComplete(Date fillDate, DayFillDetailVO task) {
        BigDecimal percentComplete = ComputeUtil.bigDecimalPercent((Integer)DateUtil.getSubDay(fillDate, task.getActualStart()), (Integer)DateUtil.getSubDay(task.getFinish(), task.getActualStart()), (int)0);
        if (task.getActualStart() != null && task.getActualFinish() != null) {
            percentComplete = new BigDecimal("100");
        }
        if (task.getActualStart() == null && task.getActualFinish() == null && task.getEstimateFinish() == null) {
            percentComplete = BigDecimal.ZERO;
        }
        if (ComputeUtil.isGreaterThan((BigDecimal)percentComplete, (BigDecimal)new BigDecimal("100"))) {
            percentComplete = new BigDecimal("100");
        }
        if (ComputeUtil.isLessThan((BigDecimal)percentComplete, (BigDecimal)new BigDecimal("0"))) {
            percentComplete = new BigDecimal("0");
        }
        return percentComplete;
    }

    private void getParents(Map<Long, ExecPlanDetailEntity> res, List<ExecPlanDetailEntity> list, Long pid) {
        if (pid != -1L) {
            for (ExecPlanDetailEntity epd : list) {
                if (pid != epd.getId()) continue;
                res.put(epd.getId(), epd);
                if (epd.getParentId() == -1L) continue;
                this.getParents(res, list, epd.getParentId());
            }
        }
    }

    private void getLeaf(List<String> res, List<ExecPlanDetailVO> detailVOS) {
        for (ExecPlanDetailVO epd : detailVOS) {
            if (CollectionUtils.isNotEmpty((Collection)epd.getChildren())) {
                this.getLeaf(res, epd.getChildren());
                continue;
            }
            res.add(epd.getStructCode());
        }
    }

    private void getParentName(Map<String, String> pmap, List<ExecPlanDetailVO> detailVOS, String pname) {
        for (ExecPlanDetailVO epd : detailVOS) {
            String name = epd.getName();
            if (StringUtils.isNotBlank((CharSequence)pname)) {
                pmap.put(epd.getStructCode(), pname);
                name = pname + "/" + name;
            }
            if (!CollectionUtils.isNotEmpty((Collection)epd.getChildren())) continue;
            this.getParentName(pmap, epd.getChildren(), name);
        }
    }
}

