/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fill.bean.ProjectLightEntity;
import com.ejianc.business.fill.service.IProjectLightService;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.bean.TotalPlanEntity;
import com.ejianc.business.plan.bean.WeekPlanEntity;
import com.ejianc.business.plan.bean.YearPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.service.ITotalPlanDetailService;
import com.ejianc.business.plan.service.ITotalPlanService;
import com.ejianc.business.plan.service.IWeekPlanService;
import com.ejianc.business.plan.service.IYearPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="totalPlan")
public class TotalPlanBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;
    @Autowired
    private ITotalPlanDetailService detailService;
    @Autowired
    private IYearPlanService yearPlanService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IWeekPlanService weekPlanService;
    @Autowired
    private IProjectLightService projectLightService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fd9\u662f\u63d0\u4ea4\u524d\u56de\u8c03");
        List detailList = this.detailService.list((Wrapper)new QueryWrapper().eq((Object)"progress_id", (Object)billId));
        this.commonHelper.validateEmployeeEntity(detailList);
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(TotalPlanEntity::getCommitTime, (Object)new Date());
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.totalPlanService.update((Wrapper)lambd);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fd9\u662f\u63d0\u4ea4\u5b8c\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        List detailList = this.detailService.list((Wrapper)new QueryWrapper().eq((Object)"progress_id", (Object)billId));
        this.commonHelper.validateEmployeeEntity(detailList);
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode() == state || BillStateEnum.UNAPPROVED.getBillStateCode() == state) {
            LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
            lambd.set(TotalPlanEntity::getCommitTime, (Object)new Date());
            lambd.eq(BaseEntity::getId, (Object)billId);
            this.totalPlanService.update((Wrapper)lambd);
        }
        TotalPlanEntity totalPlanEntity = (TotalPlanEntity)((Object)this.totalPlanService.selectById(billId));
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(TotalPlanEntity::getApprovedTime, (Object)new Date());
        if (totalPlanEntity.getStartDate() != null) {
            Integer subDay = DateUtil.getBetweenDays(new Date(), totalPlanEntity.getStartDate());
            Integer finishFlag = subDay - 9;
            lambd.set(TotalPlanEntity::getFinishFlag, (Object)finishFlag);
        }
        if (state == 1) {
            lambd.set(TotalPlanEntity::getCommitTime, (Object)new Date());
        }
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.totalPlanService.update((Wrapper)lambd);
        this.execPlanService.pushExecPlan(billId, PlanConstant.TOTAL_PLAN);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        TotalPlanEntity totalPlanEntity = (TotalPlanEntity)((Object)this.totalPlanService.selectById(billId));
        if (totalPlanEntity.getChangeStatus() != PlanConstant.CHANGE_NO) {
            return CommonResponse.error((String)"\u8ba1\u5212\u5b58\u5728\u53d8\u66f4\u5355\uff0c\u6682\u4e0d\u652f\u6301\u56de\u9000!");
        }
        if (this.checkBill(totalPlanEntity.getProjectId()).booleanValue()) {
            return CommonResponse.error((String)"\u5355\u636e\u88ab\u4e0b\u6e38\u5f15\u7528\uff0c\u6682\u4e0d\u652f\u6301\u56de\u9000!");
        }
        this.execPlanService.validateProject(totalPlanEntity.getProjectId(), totalPlanEntity.getId());
        ExecPlanEntity data = (ExecPlanEntity)((Object)this.execPlanService.getOne((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)totalPlanEntity.getProjectId())));
        this.projectLightService.remove((Wrapper)new LambdaQueryWrapper().eq(ProjectLightEntity::getExecPlanId, (Object)data.getId()));
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(TotalPlanEntity::getCommitTime, null);
        lambd.set(TotalPlanEntity::getApprovedTime, null);
        lambd.set(TotalPlanEntity::getFinishFlag, null);
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.totalPlanService.update((Wrapper)lambd);
        this.execPlanService.pushExecPlanRollBack(billId, PlanConstant.TOTAL_PLAN);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private Boolean checkBill(Long project) {
        LambdaQueryWrapper ylambd = new LambdaQueryWrapper();
        ylambd.eq(YearPlanEntity::getProjectId, (Object)project);
        List list1 = this.yearPlanService.list((Wrapper)ylambd);
        if (CollectionUtils.isNotEmpty((Collection)list1)) {
            return true;
        }
        LambdaQueryWrapper mlambd = new LambdaQueryWrapper();
        mlambd.eq(MonthPlanEntity::getProjectId, (Object)project);
        List list2 = this.monthPlanService.list((Wrapper)mlambd);
        if (CollectionUtils.isNotEmpty((Collection)list2)) {
            return true;
        }
        LambdaQueryWrapper wlambd = new LambdaQueryWrapper();
        wlambd.eq(WeekPlanEntity::getProjectId, (Object)project);
        List list3 = this.weekPlanService.list((Wrapper)wlambd);
        if (CollectionUtils.isNotEmpty((Collection)list3)) {
            return true;
        }
        return false;
    }
}

