/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.progress.enums.HandleStatusEnum;
import com.ejianc.business.progress.service.IRiskCorrectionService;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.business.progress.vo.RiskCorrectionHistoryVO;
import com.ejianc.business.progress.vo.RiskCorrectionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"riskCorrection"})
public class RiskCorrectionController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IOrgApi orgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRiskCorrectionService service;
    @Autowired
    private IExecPlanService eservice;
    @Autowired
    private IExecPlanDetailService detailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RiskCorrectionVO> saveOrUpdate(@RequestBody RiskCorrectionVO saveorUpdateVO) {
        CommonResponse<RiskCorrectionVO> response = this.service.saveOrUpdate(saveorUpdateVO);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RiskCorrectionVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RiskCorrectionVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RiskCorrectionVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectControlLevel");
        fuzzyFields.add("yearBname");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List riskCorrectionVOS = BeanMapper.mapList((Iterable)page.getRecords(), RiskCorrectionVO.class);
        riskCorrectionVOS.forEach(vo -> {
            if (!Objects.equals(vo.getStartTime(), null)) {
                if (vo.getHandleStatus().equals(HandleStatusEnum.\u5df2\u5b8c\u6210.getCode())) {
                    vo.setTake(Integer.valueOf(DateUtil.daysBetween((Date)vo.getStartTime(), (Date)vo.getFinishTime())));
                } else {
                    vo.setTake(Integer.valueOf(DateUtil.daysBetween((Date)vo.getStartTime(), (Date)new Date())));
                }
            }
        });
        pageData.setRecords(riskCorrectionVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListRisk"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RiskCorrectionVO>> queryListRisk(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planYear");
        fuzzyFields.add("yearBname");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<Integer> billState = new ArrayList<Integer>();
        billState.add(1);
        billState.add(3);
        param.getParams().put("billState", new Parameter("in", billState));
        param.getParams().put("handleStatus", new Parameter("ne", (Object)"3"));
        param.getOrderMap().put("correctionDate", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List riskCorrectionVOS = BeanMapper.mapList((Iterable)page.getRecords(), RiskCorrectionVO.class);
        ArrayList<RiskCorrectionVO> records = new ArrayList<RiskCorrectionVO>();
        ArrayList<Long> bidList = new ArrayList<Long>();
        for (RiskCorrectionVO vo : riskCorrectionVOS) {
            if (bidList.contains(vo.getYearBid())) continue;
            bidList.add(vo.getYearBid());
            if (vo.getMinTime() != null) {
                vo.setSurplusDay(Integer.valueOf(DateUtil.daysBetween((Date)vo.getMinTime(), (Date)new Date())));
            }
            records.add(vo);
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryRiskList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryRiskList(@RequestBody QueryParam param) {
        return this.service.queryRiskList(param);
    }

    @RequestMapping(value={"/drawTask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> drawTask(@RequestBody RiskCorrectionHistoryVO historyVO) {
        return this.service.drawTask(historyVO);
    }

    @RequestMapping(value={"/returnTask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> returnTask(@RequestBody RiskCorrectionHistoryVO historyVO) {
        return this.service.returnTask(historyVO);
    }

    @RequestMapping(value={"/acceptTask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> acceptTask(@RequestBody List<RiskCorrectionHistoryVO> historyVOs) {
        return this.service.acceptTask(historyVOs);
    }

    @RequestMapping(value={"/progressTask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> progressTask(@RequestBody RiskCorrectionVO vo) {
        return this.service.progressTask(vo);
    }

    @RequestMapping(value={"/queryDrawRisk"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryDrawRisk(@RequestBody QueryParam param) {
        return this.service.queryDrawRisk(param);
    }

    @RequestMapping(value={"/dataCount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> dataCount(Boolean dataCountFlag) {
        return this.service.dataCount(dataCountFlag);
    }

    @RequestMapping(value={"/queryRiskReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryRiskReport(@RequestBody QueryParam param) {
        return this.service.queryRiskReport(param);
    }

    @GetMapping(value={"/handleTopData"})
    @ResponseBody
    public CommonResponse<Boolean> handleTopData() {
        this.service.handleTopData();
        return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/referExecPlanDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanVO> referExecPlanDetail(@RequestParam(value="id") Long id, @RequestParam(value="finishState", required=false) Integer finishState, @RequestParam(value="lightType", required=false) String lightType) {
        ExecPlanEntity entity = (ExecPlanEntity)((Object)this.eservice.selectById(id));
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)id);
        ew.orderByAsc((Object)"tid");
        if (finishState != null) {
            ew.in((Object)"finish_state", new Object[]{0, 2});
            ew.isNotNull((Object)"node_level");
        }
        if (StringUtils.isNotEmpty((CharSequence)lightType)) {
            ew.in((Object)"light_type", Arrays.asList(lightType.split(",")));
        }
        List detailList = this.detailService.list((Wrapper)ew);
        ExecPlanVO vo = (ExecPlanVO)BeanMapper.map((Object)((Object)entity), ExecPlanVO.class);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
            for (ExecPlanDetailEntity detail : detailList) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

