/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.progress.bean.NodeArchivesEntity;
import com.ejianc.business.progress.mapper.NodeArchivesMapper;
import com.ejianc.business.progress.service.INodeArchivesService;
import com.ejianc.business.progress.utils.InnerCodeTool;
import com.ejianc.business.progress.vo.NodeArchivesVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="nodeArchivesService")
public class NodeArchivesServiceImpl
extends BaseServiceImpl<NodeArchivesMapper, NodeArchivesEntity>
implements INodeArchivesService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<NodeArchivesVO> saveOrUpdate(NodeArchivesVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        NodeArchivesEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            NodeArchivesEntity oldEntity = (NodeArchivesEntity)((Object)((NodeArchivesMapper)this.baseMapper).selectById(saveorUpdateVO.getId()));
            entity = (NodeArchivesEntity)((Object)BeanMapper.map((Object)((Object)oldEntity), NodeArchivesEntity.class));
            entity.setCode(saveorUpdateVO.getCode());
            entity.setName(saveorUpdateVO.getName());
            entity.setParentId(saveorUpdateVO.getParentId());
            QueryParam param = new QueryParam();
            param.getParams().put("inner_code", new Parameter("like", (Object)oldEntity.getInnerCode()));
            param.getParams().put("dr", new Parameter("eq", (Object)0));
            List oldEntities = super.queryList(param);
            if ((oldEntity.getParentId() == null || oldEntity.getParentId() <= 0L) && entity.getParentId() != null && entity.getParentId() > 0L) {
                NodeArchivesEntity parentEntity = (NodeArchivesEntity)((Object)((NodeArchivesMapper)this.baseMapper).selectById(entity.getParentId()));
                for (NodeArchivesEntity nae : oldEntities) {
                    if (nae.getId().equals(entity.getId())) {
                        nae.setParentId(entity.getParentId());
                        nae.setName(entity.getName());
                        nae.setCode(entity.getCode());
                    }
                    nae.setInnerCode(parentEntity.getInnerCode() + "," + nae.getInnerCode());
                }
                super.saveOrUpdateBatch((Collection)oldEntities);
                return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
            }
            if ((entity.getParentId() == null || entity.getParentId() <= 0L) && oldEntity.getParentId() != null && oldEntity.getParentId() > 0L) {
                for (NodeArchivesEntity nae : oldEntities) {
                    if (nae.getId().equals(entity.getId())) {
                        nae.setParentId(entity.getParentId());
                        nae.setName(entity.getName());
                        nae.setCode(entity.getCode());
                    }
                    String innerCode = nae.getInnerCode().replaceAll(oldEntity.getInnerCode(), oldEntity.getId().toString());
                    nae.setInnerCode(innerCode);
                }
                super.saveOrUpdateBatch((Collection)oldEntities);
                return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
            }
            if (entity.getParentId() != null && entity.getParentId() > 0L && oldEntity.getParentId() != null && oldEntity.getParentId() > 0L && !entity.getParentId().equals(oldEntity.getParentId())) {
                NodeArchivesEntity parentEntity = (NodeArchivesEntity)((Object)((NodeArchivesMapper)this.baseMapper).selectById(entity.getParentId()));
                for (NodeArchivesEntity nae : oldEntities) {
                    if (nae.getId().equals(entity.getId())) {
                        nae.setParentId(entity.getParentId());
                        nae.setName(entity.getName());
                        nae.setCode(entity.getCode());
                    }
                    String innerCode = nae.getInnerCode().replaceAll(oldEntity.getInnerCode(), parentEntity.getInnerCode() + "," + oldEntity.getId());
                    nae.setInnerCode(innerCode);
                }
                super.saveOrUpdateBatch((Collection)oldEntities);
                return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
            }
            super.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        entity = (NodeArchivesEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, NodeArchivesEntity.class));
        entity.setId(IdWorker.getId());
        if (StringUtils.isBlank((String)entity.getCode())) {
            entity.setCode(this.creatCode(entity.getParentId(), tenantId));
        } else {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(NodeArchivesEntity::getCode, (Object)entity.getCode());
            lambda.eq(BaseEntity::getDr, (Object)0);
            List entities = super.list((Wrapper)lambda);
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            NodeArchivesEntity uniqueBean = (NodeArchivesEntity)((Object)((NodeArchivesMapper)this.baseMapper).selectById(entity.getParentId()));
            entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @Override
    public String getPcode(Long id) {
        return ((NodeArchivesMapper)this.baseMapper).getPcode(id);
    }

    @Override
    public List<Long> getChildIds(Long id) {
        NodeArchivesEntity entity = (NodeArchivesEntity)((Object)((NodeArchivesMapper)this.baseMapper).selectById(id));
        QueryParam param = new QueryParam();
        param.getParams().put("inner_code", new Parameter("like", (Object)entity.getInnerCode()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List oldEntities = super.queryList(param);
        return oldEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
    }

    @Override
    public List<Map<String, Object>> treeRef(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (id != null && id > 0L) {
            NodeArchivesEntity entity = (NodeArchivesEntity)((Object)super.selectById((Serializable)id));
            param.getParams().put("innerCode", new Parameter("not_like", (Object)entity.getInnerCode()));
        }
        param.getOrderMap().put("id", "asc");
        List list = super.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
        return ResultAsTree.createTreeData((List)resultMapList);
    }

    @Override
    public List<NodeArchivesEntity> queryListByPid(Long id) {
        NodeArchivesEntity entity = (NodeArchivesEntity)((Object)((NodeArchivesMapper)this.baseMapper).selectById(id));
        QueryParam param = new QueryParam();
        param.getParams().put("inner_code", new Parameter("like", (Object)entity.getInnerCode()));
        param.getParams().put("id", new Parameter("ne", (Object)id));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        return super.queryList(param);
    }

    private String creatCode(Long pid, Long tenantid) {
        String pcode = "";
        if (pid != null && pid > 0L) {
            pcode = this.getPcode(pid);
        }
        String getMaxCode = ((NodeArchivesMapper)this.baseMapper).getMaxCode(tenantid, pcode, 3);
        String nextValue = InnerCodeTool.getNextValue(getMaxCode, 3);
        return pcode + nextValue;
    }
}

