/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class WeatherUtil {
    public static Map<String, Object> getTodayWeather2(String Cityid) throws IOException, NullPointerException {
        URL url = new URL("http://www.weather.com.cn/data/cityinfo/" + Cityid + ".html");
        URLConnection connectionData = url.openConnection();
        connectionData.setConnectTimeout(1000);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(connectionData.getInputStream(), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String datas = sb.toString();
            JSONObject jsonData = JSONObject.parseObject((String)datas);
            JSONObject info = jsonData.getJSONObject("weatherinfo");
            map.put("city", info.getString("city").toString());
            map.put("temp1", info.getString("temp1").toString());
            map.put("temp2", info.getString("temp2").toString());
            map.put("weather", info.getString("weather").toString());
            map.put("ptime", info.getString("ptime").toString());
        }
        catch (SocketTimeoutException e) {
            System.out.println("\u8fde\u63a5\u8d85\u65f6");
        }
        catch (FileNotFoundException e) {
            System.out.println("\u52a0\u8f7d\u6587\u4ef6\u51fa\u9519");
        }
        return map;
    }

    public String weather() {
        String ws_url = "http://www.weather.com.cn/data/city3jdata/china.html";
        String str = "";
        try {
            URL url = new URL(ws_url);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
            StringBuffer sb = new StringBuffer();
            String s = "";
            while ((s = br.readLine()) != null) {
                sb.append(s + "\r\n");
            }
            br.close();
            str = new String(sb.toString().getBytes());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    public String secondCity(String provinceId) {
        String ws_url = "http://gz.weather.com.cn/data/city3jdata/provshi/" + provinceId + ".html";
        String str = "";
        try {
            URL url = new URL(ws_url);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
            StringBuffer sb = new StringBuffer();
            String s = "";
            while ((s = br.readLine()) != null) {
                sb.append(s + "\r\n");
            }
            br.close();
            str = new String(sb.toString().getBytes());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    public String thirdCity(String id) {
        String ws_url = "http://gz.weather.com.cn/data/city3jdata/station/" + id + ".html";
        String str = "";
        try {
            URL url = new URL(ws_url);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
            StringBuffer sb = new StringBuffer();
            String s = "";
            while ((s = br.readLine()) != null) {
                sb.append(s + "\r\n");
            }
            br.close();
            str = new String(sb.toString().getBytes());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    public static JSONObject getWeather(HttpServletRequest request, String p, String c) throws Exception {
        String qqWeatherUrl = "https://wis.qq.com/weather/common?source=pc&weather_type=forecast_24h&province=";
        String url = qqWeatherUrl + URLEncoder.encode(p, "UTF-8");
        url = StringUtils.isEmpty((CharSequence)c) ? url + "&city=" + URLEncoder.encode(p, "UTF-8") : url + "&city=" + URLEncoder.encode(c, "UTF-8");
        String weather = null;
        try {
            weather = ReferHttpClientUtils.get((String)url, (HttpServletRequest)request);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return JSONObject.parseObject((String)weather);
    }

    public static void main(String[] args) {
        JSONObject jsonData;
        WeatherUtil w = new WeatherUtil();
        JSONObject map = jsonData = JSONObject.parseObject((String)w.weather());
        for (String code : map.keySet()) {
            System.out.println(code + ":" + (String)map.get(code));
        }
    }
}

