package com.ejianc.business.bim.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bim.bean.BimDetailEntity;
import com.ejianc.business.bim.bean.BimEntity;
import com.ejianc.business.bim.helper.CacheHelper;
import com.ejianc.business.bim.helper.TokenHelper;
import com.ejianc.business.bim.service.IBimDetailService;
import com.ejianc.business.bim.service.IBimService;
import com.ejianc.business.bim.vo.BimQureyVO;
import com.ejianc.business.bim.vo.BimVO;
import com.ejianc.business.bim.vo.ItemVO;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * BIM模型
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("bim")
public class BimController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZJKJ_BIM_CODE";//此处需要根据实际修改

    @Autowired
    private IBimService service;

    @Autowired
    private IBimDetailService detailService;

    @Autowired
    private IExecPlanService execService;

    @Autowired
    private IExecPlanDetailService execDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BimVO> saveOrUpdate(@RequestBody BimVO saveOrUpdateVO) {
        BimVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BimVO> queryDetail(Long id) {
        BimVO vo = service.syncDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryByProjectId 根据项目查询详情
     * @param projectId
     */
    @RequestMapping(value = "/queryByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BimVO> queryByProjectId(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        BimEntity entity = service.queryList(queryParam).stream().findAny().orElse(null);
        if(entity == null){
            return CommonResponse.error("未查询到该项目下BIM模型！");
        }
        entity = service.selectById(entity.getId());
        return CommonResponse.success("查询详情数据成功！", BeanMapper.map(entity, BimVO.class));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BimVO> vos) {
        Long orgId = InvocationInfoProxy.getOrgId();
        List<Long> ids = vos.stream().map(BimVO::getId).collect(Collectors.toList());
        Collection<BimEntity> list = service.listByIds(ids);
        for(BimEntity entity : list){
            if(!orgId.equals(entity.getOrgId())){
                return CommonResponse.error("没有删除权限！");
            }
        }
        // 同步删除大象云模型列表
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bimId", new Parameter(QueryParam.IN, ids));
        List<BimDetailEntity> detaiList = detailService.queryList(queryParam);
        service.removeByIds(ids,true);
        List<String> delPaths = detaiList.stream().map(BimDetailEntity::getPath).collect(Collectors.toList());
        for(String path : delPaths){
            TokenHelper.delFile(path);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BimVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
//        fuzzyFields.add("createUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<BimEntity> page = service.queryPage(param,false);
        IPage<BimVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BimVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BimEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Bim-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBimData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BimVO>> refBimData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BimEntity> page = service.queryPage(param,false);
        IPage<BimVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BimVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 获取大象云token
     * @Return void
     */
    @RequestMapping(value = "/getToken", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getToken() {
        Object token = CacheHelper.get(TokenHelper.TOKEN);
        if(token == null){
            TokenHelper.getTokenData();
            token = CacheHelper.get(TokenHelper.TOKEN);
            return CommonResponse.success("查询成功！", String.valueOf(token));
        }
        String url = TokenHelper.BASE_HOST + "/api/v3/srv/fs/file/status";
        Map<String, String> params = new HashMap<>();
        params.put("token", String.valueOf(token));
        params.put("path", "opendx/9204360f0a8a4bb8a5d523401f2872cb/ef34af2b93e24b4ea6ea6f8cc63e6d17/ef34af2b93e24b4ea6ea6f8cc63e6d17.rvt");
        JSONObject json = null;
        try {
            String response = HttpTookit.getAndHeader(url, params);
            json = JSONObject.parseObject(response);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        if(json.containsKey("error") && json.getJSONObject("error").containsKey("code") &&
                json.getJSONObject("error").getInteger("code") == 1004){
            TokenHelper.getTokenData();
            token = CacheHelper.get(TokenHelper.TOKEN);
        }
        return CommonResponse.success("查询成功！", String.valueOf(token));
    }

    /**
     * @Description 获取大象云图元id对应关系
     * @Return void
     */
    @RequestMapping(value = "/getHiddenItems", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> getHiddenItems(@RequestBody BimQureyVO queryVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, queryVO.getProjectId()));
        // 查询bim模型关联主模型路径
        if(CollectionUtils.isEmpty(queryVO.getAsmPaths())){
            BimEntity entity = service.queryList(queryParam).stream().findAny().orElse(null);
            if(entity == null){
                return CommonResponse.error("未查询到该项目下BIM模型！");
            }
            entity = service.selectById(entity.getId());
            String path = entity.getDetailList().stream().filter(x->x.getModle() != null && x.getModle() == 1).findAny().map(x->x.getPath()).get();
            queryVO.setAsmPaths(new ArrayList<>(Arrays.asList(path)));
        }
        if(CollectionUtils.isEmpty(queryVO.getAsmPaths())){
            return CommonResponse.error("未查询到BIM下主模型路径！");
        }
        // 根据路径查询图元ID
        List<String> items = new ArrayList<>();
        List<ItemVO> parents = new ArrayList<>();
        // rvt文件
        if(queryVO.getAsmPaths().size() == 1){
            JSONObject json = TokenHelper.getFileTree(queryVO.getAsmPaths().get(0));
            ItemVO parent = this.getItems(json, items, null);
            parents.add(parent);
        }
        // asm文件
        if(queryVO.getAsmPaths().size() > 1){
            for(int i=0; i < queryVO.getAsmPaths().size(); i++){
                JSONObject json = TokenHelper.getFileTree(queryVO.getAsmPaths().get(i));
                ItemVO parent = this.getItems(json, items, i);
                parents.add(parent);
            }
        }
        // 图元ID与已关联执行计划任务进行匹配
        ExecPlanEntity exec = execService.queryList(queryParam).stream().findAny().orElse(null);
        if(exec == null){
            return CommonResponse.error("未查询到该项目下的执行计划！");
        }
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", exec.getId());
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> detailList = execDetailService.list(ew);
        // 获取颜色数组
        JSONObject colors = this.getColors();
        JSONArray hiddenItems = new JSONArray();// 隐藏图元
        JSONArray acturalItems = new JSONArray();// 实际图元
        JSONArray states = new JSONArray();// 上色图元
        JSONArray translucentBim = new JSONArray();// 透明图元
        for(ExecPlanDetailEntity detail : detailList){
            if(StringUtils.isNotEmpty(detail.getBimIds())){
                List<String> bimIds = new ArrayList<>(Arrays.asList(detail.getBimIds().split(",")));
                for(String bimId : bimIds){
                    if(items.contains(bimId)){
                        // 隐藏图元
                        JSONObject obj = new JSONObject();
                        obj.put("id", bimId);
                        obj.put("time", detail.getStart());
                        obj.put("duration", detail.getDuration());
                        obj.put("uid", detail.getId());
                        obj.put("name", detail.getName());
                        hiddenItems.add(obj);
                        // 实际图元
                        if(detail.getActualStart() != null){
                            JSONObject obj2 = new JSONObject();
                            obj2.put("id", bimId);
                            obj2.put("time", detail.getActualStart());
                            obj2.put("duration", detail.getDuration());
                            obj2.put("uid", detail.getId());
                            obj2.put("name", detail.getName());
                            acturalItems.add(obj2);
                        }
                        // 上色图元
                        JSONArray state = new JSONArray();
                        state.add(bimId);
                        if (new Integer(1).equals(detail.getFinishState())){
                            state.add(colors.getJSONArray("blue"));// 已经完成
                        } else if (new Integer(2).equals(detail.getFinishState()) &&
                                DateUtil.compareDate(detail.getActualStart(), detail.getPlanStart()) > 0) {
                            state.add(colors.getJSONArray("red"));// 进行中已逾期
                        } else if (new Integer(2).equals(detail.getFinishState()) &&
                                ComputeUtil.isGreaterThan(detail.getDiffValue(), BigDecimal.ZERO)) {
                            state.add(colors.getJSONArray("yellow"));// 进行中预计预期
                        } else if (new Integer(2).equals(detail.getFinishState()) &&
                                ComputeUtil.isLessOrEqual(detail.getDiffValue(), BigDecimal.ZERO)) {
                            state.add(colors.getJSONArray("green"));// 进行中
                        } else {
                            state.add(colors.getJSONArray("white"));// 未开始
                            // 透明图元
                            translucentBim.add(bimId);
                        }
                        states.add(state);
                    }
                }
            }
        }
        // 处理上色图元，如果关联的图元ID是模型树选择，且是父级，需所有子级赋值相同上色，且已关联图元上色重新覆盖
        JSONArray newStates = new JSONArray();
        Map<String, JSONArray> colorMap = states.stream().collect(Collectors.toMap(x->((JSONArray)x).getString(0), x->((JSONArray)x).getJSONArray(1)));
        this.getNewStates(newStates, parents, colorMap);
        newStates = newStates.stream().map(x->{
            JSONArray vo = (JSONArray)x;
            String uid = vo.getString(0);
            if(colorMap.containsKey(uid)){
                vo.remove(1);
                vo.add(colorMap.get(uid));
            }
            return vo;
        }).collect(Collectors.toCollection(JSONArray::new));

        hiddenItems = hiddenItems.stream().sorted(Comparator.comparing(x->((JSONObject)x).getDate("time"))).collect(Collectors.toCollection(JSONArray::new));
        acturalItems = acturalItems.stream().sorted(Comparator.comparing(x->((JSONObject)x).getDate("time"))).collect(Collectors.toCollection(JSONArray::new));
        JSONObject json = new JSONObject();
        json.put("hiddenItems", hiddenItems);// 隐藏图元
        json.put("acturalItems", acturalItems);// 实际图元
        json.put("states", newStates);// 上色图元
        json.put("translucentBim", translucentBim);// 透明图元
        return CommonResponse.success("查询成功！", json);
    }

    /**
     * 子级按照父级重新上色
     * @param newStates
     * @param parents
     * @param colorMap
     */
    private static void getNewStates(JSONArray newStates, List<ItemVO> parents, Map<String, JSONArray> colorMap){
        for(ItemVO parent : parents){
            String parentId = parent.getUid();
            List<ItemVO> children = parent.getChildren();
            if(colorMap.containsKey(parentId)){
                for(ItemVO item : children){
                    colorMap.put(item.getUid(), colorMap.get(parentId));
                }
                JSONArray vo = new JSONArray();
                vo.add(parentId);
                vo.add(colorMap.get(parentId));
                newStates.add(vo);
            }
            getNewStates(newStates, children, colorMap);
        }
    }

    /**
     * 递归查询子节点
     * @param root  父级主键
     * @param parent   父级
     * @return 根节点信息
     */
    private static List<ItemVO> getChildrens(String root, ItemVO parent) {
        List<ItemVO> children = new ArrayList<>();
        if(root.equals(parent.getUid())){
            children = parent.getChildren();
            List<ItemVO> childs = new ArrayList<>();
            for(ItemVO child : children){
                childs.addAll(getChildrens(child.getUid(), child));
            }
            children.addAll(childs);
        } else {
            for(ItemVO child : parent.getChildren()){
                children.addAll(getChildrens(root, child));
            }
        }
        parent.setChildren(new ArrayList<>());
        return children;
    }

    // 颜色数组
    private static JSONObject getColors() {
        JSONObject colors = new JSONObject();
        JSONArray blue = new JSONArray();
        blue.add(safeDiv(69, 255));
        blue.add(safeDiv(125, 255));
        blue.add(safeDiv(230, 255));
        colors.put("blue", blue);
        JSONArray red = new JSONArray();
        red.add(safeDiv(237, 255));
        red.add(safeDiv(114, 255));
        red.add(safeDiv(110, 255));
        colors.put("red", red);
        JSONArray yellow = new JSONArray();
        yellow.add(safeDiv(245, 255));
        yellow.add(safeDiv(195, 255));
        yellow.add(safeDiv(86, 255));
        colors.put("yellow", yellow);
        JSONArray green = new JSONArray();
        green.add(safeDiv(83, 255));
        green.add(safeDiv(180, 255));
        green.add(safeDiv(102, 255));
        colors.put("green", green);
        JSONArray white = new JSONArray();
        white.add(safeDiv(242, 255));
        white.add(safeDiv(242, 255));
        white.add(safeDiv(242, 255));
        colors.put("white", white);
        return colors;
    }

    private static BigDecimal safeDiv(Integer num1, Integer num2) {
        return safeDiv(new BigDecimal(num1.toString()), new BigDecimal(num2.toString()));
    }

    private static BigDecimal safeDiv(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null || decimal2 == null || decimal2.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal(0);
        } else {
            return decimal1.divide(decimal2, 18, BigDecimal.ROUND_HALF_UP);
        }
    }

    private final static Base64.Encoder encoder = Base64.getEncoder();

    // 解析图元id转base64编码，asm文件需要序号+guid
    private static ItemVO getItems(JSONObject json, List<String> items, Integer index) {
        String Guid = null;
        if(StringUtils.isNotEmpty(json.getString("Guid"))){
            if(index != null){
                Guid = encoder.encodeToString((index + "." + json.getString("Guid")).getBytes());
            } else {
                Guid = encoder.encodeToString(json.getString("Guid").getBytes());
            }
            items.add(Guid);
        }
        List<ItemVO> children = new ArrayList<>();
        if(json.containsKey("Children")){
            for(Object o : json.getJSONArray("Children")){
                ItemVO child = getItems(JSONObject.parseObject(o.toString()), items, index);
                child.setParentId(Guid);
                children.add(child);
            }
        }
        ItemVO vo = new ItemVO();
        vo.setUid(Guid);
        vo.setChildren(children);
        return vo;
    }

    public static void main(String[] args) {
//        String str = "a6709281-c271-449c-8900-61a83693585d";
//        JSONObject json = new JSONObject();
//        json.put("Guid", str);
//        Base64.Encoder encoder = Base64.getEncoder();
//        try {
//            byte[] textByte = str.getBytes("UTF-8");
//            System.out.println(encoder.encodeToString(textByte));
//        } catch (UnsupportedEncodingException e) {
//            e.printStackTrace();
//        }
//        System.out.println(encoder.encodeToString(json.getString("Guid").getBytes()));
//        String path = "opendx/9204360f0a8a4bb8a5d523401f2872cb/ef34af2b93e24b4ea6ea6f8cc63e6d17/ef34af2b93e24b4ea6ea6f8cc63e6d17.rvt";
//        JSONObject json = TokenHelper.getFileTree(path);
//        List<String> items = new ArrayList<>();
//        ItemVO parent = BimController.getItems(json, items, null);
//        System.out.println(JSONObject.toJSONString(items));
//        System.out.println(JSONObject.toJSONString(parent));


        List<String> paths = new ArrayList<>();
        paths.add("opendx/9204360f0a8a4bb8a5d523401f2872cb/7c6b1f21b7d349ef958301438497a4a1/7c6b1f21b7d349ef958301438497a4a1.rvt");
        paths.add("opendx/9204360f0a8a4bb8a5d523401f2872cb/b4df9578f4a949f89c1dfe21fcb3a7ae/b4df9578f4a949f89c1dfe21fcb3a7ae.rvt");
        paths.add("opendx/9204360f0a8a4bb8a5d523401f2872cb/5c872b5ec4de4f86875e7fb4aca79824/5c872b5ec4de4f86875e7fb4aca79824.rvt");
        List<String> items = new ArrayList<>();
        List<ItemVO> parents = new ArrayList<>();
        for(int i=0; i < paths.size(); i++){
            JSONObject json = TokenHelper.getFileTree(paths.get(i));
            ItemVO parent = BimController.getItems(json, items, i);
//            List<ItemVO> children = getChildrens("MS5mYjlkMmQ3Ni1lOTcxLTRmNjYtODhhMy0xMDAwMDAwMDAwMDA=", parent);
//            System.out.println(JSONObject.toJSONString(children));
            parents.add(parent);
        }
        // 获取颜色数组
        JSONObject colors = BimController.getColors();
        JSONArray states = new JSONArray();// 上色图元
        JSONArray state = new JSONArray();
        state.add("MS5mYjlkMmQ3Ni1lOTcxLTRmNjYtODhhMy0xMDAwMDAwMDAwMDA=");
        state.add(colors.getJSONArray("blue"));// 已经完成
        states.add(state);

        // 处理上色图元，如果关联的图元ID是模型树选择，且是父级，需所有子级赋值相同上色，且已关联图元上色重新覆盖
        JSONArray newStates = new JSONArray();
        Map<String, JSONArray> colorMap = states.stream().collect(Collectors.toMap(x->((JSONArray)x).getString(0), x->((JSONArray)x).getJSONArray(1)));
        BimController.getNewStates(newStates, parents, colorMap);
        newStates = newStates.stream().map(x->{
            JSONArray vo = (JSONArray)x;
            String uid = vo.getString(0);
            if(colorMap.containsKey(uid)){
                vo.remove(1);
                vo.add(colorMap.get(uid));
            }
            return vo;
        }).collect(Collectors.toCollection(JSONArray::new));
        System.out.println(JSONObject.toJSONString(newStates));
    }
}
