package com.ejianc.business.fill.service.impl;

import com.alibaba.fastjson.JSONObject;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

import com.ejianc.business.fill.bean.ProjectTrendEntity;
import com.ejianc.business.fill.emum.LightRuleLevelEnum;
import com.ejianc.business.fill.mapper.ProjectTrendMapper;
import com.ejianc.business.fill.service.IProjectLightService;
import com.ejianc.business.fill.service.IProjectTrendService;
import com.ejianc.business.fill.service.IWarnService;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.progress.bean.LightRuleEntity;
import com.ejianc.business.progress.bean.LightRuleLevelEntity;
import com.ejianc.business.progress.enums.LevelEnum;
import com.ejianc.business.progress.enums.LightTypeEnum;
import com.ejianc.business.progress.utils.ComputeUtil;
import com.ejianc.business.progress.utils.DateUtil2;

import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目趋势
 *
 * @author generator
 */
@Service("projectTrendService")
public class ProjectTrendServiceImpl extends BaseServiceImpl<ProjectTrendMapper, ProjectTrendEntity> implements IProjectTrendService {
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;
    @Autowired
    private IProjectLightService projectLightService;
    @Autowired
    private IWarnService warnService;

    /**
     * 新增项目趋势
     *
     * @param execList
     * @return
     */
    @Override
    public Boolean projectTrendTrend(List<ExecPlanEntity> execList,Map<Long, LightRuleEntity> projectLightRuleMap) {

        List<Long> ids = new ArrayList<>();
        for (ExecPlanEntity execPlan : execList){
            ids.add(execPlan.getProjectId());
        }

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String today = df.format(new Date());

        List<ProjectTrendEntity> list = ids.size() > 0 ? baseMapper.proNearToday(ids, today) : new ArrayList<>();// 不包含今天
        List<ProjectTrendEntity> todayList = ids.size() > 0 ? baseMapper.proTodayToday(ids, today) : new ArrayList<>();// 只有今天
        Map<Long, ProjectTrendEntity> nearMap = new HashMap<>();// 最近的，不包含今天
        for (ProjectTrendEntity entity : list) {
            nearMap.put(entity.getProjectId(), entity);
        }
        Map<Long, ProjectTrendEntity> todayMap = new HashMap<>();// 只包含今天
        if (todayList != null && todayList.size() > 0) {
            for (ProjectTrendEntity entity : todayList) {
                todayMap.put(entity.getProjectId(), entity);
            }
        }
        List<ProjectTrendEntity> saveOrUpdate = new ArrayList<>();
        List<Long> delIds = new ArrayList<>();// 需要删除的
        for (ExecPlanEntity execPlanEntity : execList) {

            Long projectId = execPlanEntity.getProjectId();

            // 获取亮灯规则
            LightRuleLevelEntity lightRuleLevel = warnService.getLightRuleLevel(projectLightRuleMap,projectId, LightRuleLevelEnum.项目完成时间.getCode());
            //取执行计划中的总计划明细
            List<ExecPlanDetailEntity> detailList = execPlanEntity.getAllList().stream().filter(e -> PlanConstant.TOTAL_PLAN == e.getPlanState()).collect(Collectors.toList());

            if (CollectionUtils.isEmpty(detailList)){
                continue;
            }

            // 最大偏差值
            BigDecimal maxDiffValue = detailList.stream().map(ExecPlanDetailEntity::getDiffValue).max(BigDecimal::compareTo).get();
            // 最大预测完成日期
            Date maxPredictFinish = detailList.stream().max(Comparator.comparing(ExecPlanDetailEntity::getPredictFinish)).get().getPredictFinish();
            // 最大节点剩余工期
            BigDecimal residueValue = new BigDecimal(DateUtil.getBetweenDays(maxPredictFinish, new Date()));
            // 偏差日期/节点剩余工期
            BigDecimal finalValue = ComputeUtil.safeDiv(maxDiffValue, residueValue);
            //获取亮灯状态
            Integer lightType = null;
            if (null != lightRuleLevel){
                lightType = warnService.getLightType(lightRuleLevel, maxDiffValue, finalValue, false,null);
            }

            // 先看今天有没有数据
            if (todayMap.containsKey(projectId)) {// 如果今天有数据
                ProjectTrendEntity todayEntity = todayMap.get(projectId);
                // 查看之前的数据和今天数据的关系
                if (nearMap.containsKey(projectId)) {// 再之前也有数据
                    //判断现在的数据和之前数据是否相同
                    ProjectTrendEntity nearEntity = nearMap.get(projectId);
                    if (nearEntity.getDiffValue().compareTo(maxDiffValue) == 0 && nearEntity.getCorpLightType() == lightType) { // 相同，则删除
                        delIds.add(todayEntity.getId());
                    } else {// 不同，则更新
                        todayEntity.setDiffValue(maxDiffValue);
                        todayEntity.setCorpLightType(lightType);
                        saveOrUpdate.add(todayEntity);
                    }
                } else { // 再之前没数据了
                    // 更新
                    todayEntity.setDiffValue(maxDiffValue);
                    todayEntity.setCorpLightType(lightType);
                    saveOrUpdate.add(todayEntity);
                }
            } else {// 今天没有数据
                if (nearMap.containsKey(projectId)) {// 之前已经存在数据
                    ProjectTrendEntity nearEntity = nearMap.get(projectId);
                    if (nearEntity.getDiffValue().compareTo(maxDiffValue) != 0 || nearEntity.getCorpLightType() != lightType) { // 不同，则新增
                        ProjectTrendEntity entity = new ProjectTrendEntity();
                        entity.setProjectId(projectId);
                        entity.setUpdateDate(today);
                        entity.setDiffValue(maxDiffValue);
                        entity.setCorpLightType(lightType);
                        saveOrUpdate.add(entity);
                    }
                } else { // 之前也不存在
                    // 新增
                    ProjectTrendEntity entity = new ProjectTrendEntity();
                    entity.setProjectId(projectId);
                    entity.setUpdateDate(today);
                    entity.setDiffValue(maxDiffValue);
                    entity.setCorpLightType(lightType);
                    saveOrUpdate.add(entity);
                }
            }
        }
        if (saveOrUpdate.size() > 0) {
            super.saveOrUpdateBatch(saveOrUpdate, saveOrUpdate.size(), false);
        }
        if (delIds.size() > 0) {
            super.removeByIds(delIds, false);
        }
        return true;
    }

    @Override
    public JSONObject proMonthDelnyTrend(Long projectId) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        String thisMonth = df.format(new Date());

        List<String> keyList = new ArrayList<>();
        List<BigDecimal> valueList = new ArrayList<>();

        List<ProjectTrendEntity> entityList = baseMapper.monthTrend(projectId, thisMonth);

        for (ProjectTrendEntity dte : entityList) {
            keyList.add(dte.getUpdateDate());
            valueList.add(dte.getDiffValue());
        }

        keyList.add(thisMonth);
        valueList.add(getTodayDiffValue(projectId));

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", keyList);
        jsonObject.put("value", valueList);
        return jsonObject;
    }

    @Override
    public JSONObject proWeekDelnyTrend(Long projectId) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String today = df.format(new Date());

        LambdaQueryWrapper<ProjectTrendEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ProjectTrendEntity::getDr, 0);
        lambda.eq(ProjectTrendEntity::getProjectId, projectId);
        lambda.orderByAsc(ProjectTrendEntity::getUpdateDate);
        List<ProjectTrendEntity> entityList = super.list(lambda);

        JSONObject jsonObject = new JSONObject();
        List<String> keyList = new ArrayList<>();
        List<BigDecimal> valueList = new ArrayList<>();
        if (entityList == null || entityList.size() <= 0) {
            keyList.add(today);
            valueList.add(getTodayDiffValue(projectId));
            jsonObject.put("key", keyList);
            jsonObject.put("value", valueList);
            return jsonObject;
        }
        // 先补充完整
        String startDate = entityList.get(0).getUpdateDate();
        BigDecimal diffValue = entityList.get(0).getDiffValue();
        Map<String, BigDecimal> entityMap = new LinkedHashMap<>();
        Map<String, BigDecimal> fullMap = new LinkedHashMap<>();
        for (ProjectTrendEntity pte : entityList) {
            entityMap.put(pte.getUpdateDate(), pte.getDiffValue());
        }
        while (DateUtil2.compareTime(startDate, today) <= 0) {
            if (entityMap.containsKey(startDate)) {
                diffValue = entityMap.get(startDate);
            }
            fullMap.put(startDate, diffValue);
            startDate = DateUtil2.dateAdd(df, startDate, 1);
        }
        // 近三个月
        // todo 要显示全部
        String start = DateUtil2.getWeekOfMonthStartDate(df, 24);

        Map<String, BigDecimal> weekMap = new LinkedHashMap<>();
        Map<String, BigDecimal> resMap = new LinkedHashMap<>();
        for (int i = 1; DateUtil2.compareTime(start, today) <= 0; i++) {
            if (fullMap.containsKey(start)) {
                BigDecimal bvalue = fullMap.get(start);
                weekMap.put(start, bvalue);
            }
            start = DateUtil2.dateAdd(df, start, 1);
            if (DateUtil2.compareTime(start, today) == 0) {
                resMap.put(today, getTodayDiffValue(projectId));
            } else {
                if (i == 7) {
                    i = 0;
                    if (weekMap.size() > 0) {
                        resMap = maxWeekMap(weekMap, resMap);
                        weekMap = new LinkedHashMap<>();
                    }
                }
            }
        }


        for (String date : resMap.keySet()) {
            BigDecimal b = resMap.get(date);
            keyList.add(date);
            valueList.add(b);
        }

        jsonObject.put("key", keyList);
        jsonObject.put("value", valueList);
        return jsonObject;
    }

    private Map<String, BigDecimal> maxWeekMap(Map<String, BigDecimal> weekMap, Map<String, BigDecimal> resMap) {
        String d = weekMap.keySet().iterator().next();
        BigDecimal a = weekMap.get(d);
        for (String date : weekMap.keySet()) {
            BigDecimal b = weekMap.get(date);
            if (b.compareTo(a) > 0) {
                a = b;
                d = date;
            }
        }
        resMap.put(d, a);
        return resMap;
    }

    /**
     * 获取今天的偏差值
     *
     * @param projectId
     * @return
     */
    private BigDecimal getTodayDiffValue(Long projectId) {

        LambdaQueryWrapper<ExecPlanEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ExecPlanEntity::getProjectId,projectId);
        ExecPlanEntity entity = execPlanService.getOne(queryWrapper);
        if(entity == null){
            return BigDecimal.ZERO;
        }

        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", entity.getId());
        ew.eq("plan_state", PlanConstant.TOTAL_PLAN);
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> detailList = execPlanDetailService.list(ew);

        // 最大偏差值
        detailList.forEach(e -> e.setDiffValue(new BigDecimal(DateUtil.getBetweenDays(e.getPredictFinish(), e.getPlanFinish()))));
        BigDecimal maxDiffValue = detailList.stream().map(ExecPlanDetailEntity::getDiffValue).max(BigDecimal::compareTo).get();

        return maxDiffValue;

    }


    
}
