package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.*;
import java.util.stream.Collectors;

@Service("weekPlanChange")
public class WeekPlanChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IWeekPlanService service;
	@Autowired
	private IWeekPlanDetailService detailService;
	@Autowired
	private IWeekPlanChangeService changeService;
	@Autowired
	private IWeekPlanChangeDetailService detailChangeService;
	@Autowired
	private IWeekPlanHistoryService historyService;
	@Autowired
	private IWeekPlanHistoryDetailService detailHistoryService;
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IExecPlanService execPlanService;
	@Autowired
	private CommonHelper commonHelper;

	public static final String WEEK_PLAN_BILL_TYPE = "EJCBT202206000013";
	public static final String WEEK_PLAN_CHANGE_BILL_TYPE = "EJCBT202206000023";
	public static final String WEEK_PLAN_SOURCE_TYPE = "zjkjWeekPlan";
	public static final String WEEK_PLAN_CHANGE_SOURCE_TYPE = "zjkjWeekPlanChange";
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		//校验关联负责人
		List<WeekPlanChangeDetailEntity> detailList = detailChangeService.list(new QueryWrapper<WeekPlanChangeDetailEntity>().eq("progress_id", billId));
		commonHelper.validateEmployeeEntity(detailList);

		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//校验关联负责人
		List<WeekPlanChangeDetailEntity> detailList1 = detailChangeService.list(new QueryWrapper<WeekPlanChangeDetailEntity>().eq("progress_id", billId));
		commonHelper.validateEmployeeEntity(detailList1);


		logger.info("--------------变更审批通过，处理业务");
		WeekPlanChangeEntity changeEntity = changeService.selectById(billId);
		QueryWrapper<WeekPlanChangeDetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("progress_id", billId);
		queryWrapper.orderByAsc("tid");
		List<WeekPlanChangeDetailEntity> detailChangeList = detailChangeService.list(queryWrapper);
		logger.info("--------------同步原始计划到记录表");
		WeekPlanEntity entity = service.selectById(changeEntity.getWeekId());
		QueryWrapper<WeekPlanDetailEntity> queryWrapper1 = new QueryWrapper<>();
		queryWrapper1.eq("progress_id", entity.getId());
		queryWrapper1.orderByAsc("tid");
		List<WeekPlanDetailEntity> detailList = detailService.list(queryWrapper1);
		Map<Long, WeekPlanDetailEntity> detailMap = detailList.stream().collect(Collectors.toMap(WeekPlanDetailEntity::getId, x->x));
		//List<Long> detailIds = detailList.stream().map(WeekPlanDetailEntity::getId).collect(Collectors.toList());
		List<Long> detailIds = new ArrayList<>();
		for (WeekPlanDetailEntity pde : detailList) {
			detailIds.add(pde.getId());
		}
		WeekPlanHistoryEntity historyEntity = BeanMapper.map(entity, WeekPlanHistoryEntity.class);
		Long historyId = IdWorker.getId();
		historyEntity.setWeekId(historyEntity.getId());
		historyEntity.setId(historyId);
		historyService.save(historyEntity);
		List<WeekPlanHistoryDetailEntity> historyDetailEntity = BeanMapper.mapList(detailList, WeekPlanHistoryDetailEntity.class);
		Map<Long, Long> pmap = new HashMap<>();
		for (WeekPlanHistoryDetailEntity pdh : historyDetailEntity) {
			Long historyDetailId = IdWorker.getId();
			pdh.setWeekId(entity.getId());
			pdh.setWeekBid(pdh.getId());
			pdh.setProgressId(historyId);
			pdh.setId(historyDetailId);
			pmap.put(pdh.getWeekBid(), pdh.getId());
		}
		for (WeekPlanHistoryDetailEntity pdh : historyDetailEntity) {
			pdh.setParentId(pmap.containsKey(pdh.getParentId()) ? pmap.get(pdh.getParentId()) : -1L);
			TreeUtils.resetProjectClomn(pdh, pmap);
		}
		detailHistoryService.saveBatch(historyDetailEntity);
		logger.info("--------------同步变更到原计划表");
		entity.setChangeStatus(PlanConstant.CHANGE_OVER);
		entity.setChangeVersion(changeEntity.getChangeVersion());
		entity.setChangeApprovedTime(new Date());
		entity.setChangeReason(changeEntity.getChangeReason());
		entity.setChangeDescription(changeEntity.getChangeDescription());
		service.updateById(entity);
		Map<Long, Long> idmap = new HashMap<>();
		List<WeekPlanDetailEntity> newDetail = new ArrayList<>();
		for (WeekPlanChangeDetailEntity pdc : detailChangeList) {
			Long detailId = IdWorker.getId();
			if (pdc.getWeekBid() != null && pdc.getWeekBid() > 0) {
				idmap.put(pdc.getId(), pdc.getWeekBid());
				pdc.setId(pdc.getWeekBid());
				detailIds.remove(pdc.getWeekBid());
			} else {
				idmap.put(pdc.getId(), detailId);
				pdc.setId(detailId);
			}
			pdc.setProgressId(entity.getId());
			// version替换，否则更新不了
			if(detailMap.containsKey(pdc.getId())){
				pdc.setVersion(detailMap.get(pdc.getId()).getVersion());
			}
			newDetail.add(BeanMapper.map(pdc, WeekPlanDetailEntity.class));
		}
		if (detailIds != null && detailIds.size() > 0) {
			detailService.deleteDetailByIds(detailIds);
		}
		for (WeekPlanDetailEntity pde : newDetail) {
			pde.setParentId(idmap.containsKey(pde.getParentId()) ? idmap.get(pde.getParentId()) : -1L);
			TreeUtils.resetProjectClomn(pde, idmap);
		}
		detailService.saveOrUpdateBatch(newDetail, newDetail.size(), false);
		logger.info("--------------变更审批通过时间");
		LambdaUpdateWrapper<WeekPlanChangeEntity> lambd = new LambdaUpdateWrapper<>();
		lambd.set(WeekPlanChangeEntity::getApprovedTime, new Date());
		lambd.eq(WeekPlanChangeEntity::getId, billId);
		changeService.update(lambd);
		logger.info("--------------处理变更附件");
		CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(billId), WEEK_PLAN_CHANGE_BILL_TYPE, WEEK_PLAN_CHANGE_SOURCE_TYPE,
				String.valueOf(entity.getId()), WEEK_PLAN_BILL_TYPE, WEEK_PLAN_SOURCE_TYPE);
		execPlanService.pushExecPlan(entity.getId(),PlanConstant.WEEK_PLAN);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
