package com.ejianc.business.plan.service.impl;

import com.aliyun.dingtalkedu_1_0.models.EndCourseRequest;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.progress.utils.DateUtil2;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service("yearPlan") 
public class YearPlanBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IYearPlanService yearPlanService;
	@Autowired
	private IExecPlanService execPlanService;
	@Autowired
	private IMonthPlanService monthPlanService;
	@Autowired
	private IWeekPlanService weekPlanService;
	@Autowired
	private CommonHelper commonHelper;
	@Autowired
	private IYearPlanDetailService detailService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		//校验关联负责人
		List<YearPlanDetailEntity> detailList = detailService.list(new QueryWrapper<YearPlanDetailEntity>().eq("progress_id", billId));
		commonHelper.validateEmployeeEntity(detailList);

		LambdaUpdateWrapper<YearPlanEntity> lambd = new LambdaUpdateWrapper<>();
		lambd.set(YearPlanEntity::getCommitTime, new Date());
		lambd.eq(YearPlanEntity::getId, billId);
		yearPlanService.update(lambd);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//校验关联负责人
		List<YearPlanDetailEntity> detailList = detailService.list(new QueryWrapper<YearPlanDetailEntity>().eq("progress_id", billId));
		commonHelper.validateEmployeeEntity(detailList);
		if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode() == state || BillStateEnum.UNAPPROVED.getBillStateCode() == state){
			LambdaUpdateWrapper<YearPlanEntity> lambd = new LambdaUpdateWrapper<>();
			lambd.set(YearPlanEntity::getCommitTime, new Date());
			lambd.eq(YearPlanEntity::getId, billId);
			yearPlanService.update(lambd);
		}

		YearPlanEntity planEntity = yearPlanService.selectById(billId);
		LambdaUpdateWrapper<YearPlanEntity> lambd = new LambdaUpdateWrapper<>();
		lambd.set(YearPlanEntity::getApprovedTime, new Date());
		if (planEntity.getStartDate() != null) {
			Integer subDay = DateUtil.getSubDay(new Date(), planEntity.getPlanBeginDate());
//			Integer finishFlag = subDay - 9;
			lambd.set(YearPlanEntity::getFinishFlag, subDay);
		}
		if (state == 1) {
			lambd.set(YearPlanEntity::getCommitTime, new Date());
		}
		lambd.eq(YearPlanEntity::getId, billId);
		yearPlanService.update(lambd);
		logger.info("年计划开始推送执行计划 bill-{}",billId);
		execPlanService.pushExecPlan(billId, PlanConstant.YEAR_PLAN);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		// todo 校验，是否有下游单据
		YearPlanEntity planEntity = yearPlanService.selectById(billId);
		if (planEntity.getChangeStatus() != PlanConstant.CHANGE_NO) {
			return CommonResponse.error("计划存在变更单，暂不支持回退功能!");
		}

		execPlanService.validateProject(planEntity.getProjectId(),planEntity.getId());

		//根据年计划获取此年的第一天和最后一天
		//获取某年的第一天
		Calendar c1 = Calendar.getInstance();
		c1.clear();
		c1.set(Calendar.YEAR,planEntity.getPlanYear());
		Date yearFirstDate = c1.getTime();

		//获取某年的最后一天
		Calendar c2 = Calendar.getInstance();
		c2.clear();
		c2.set(Calendar.YEAR,planEntity.getPlanYear());
		c2.roll(Calendar.DAY_OF_YEAR,-1);
		Date yearLastDate = c2.getTime();

		LambdaQueryWrapper<MonthPlanEntity> monthUpdateWrapper = new LambdaQueryWrapper<>();
		monthUpdateWrapper.eq(MonthPlanEntity::getProjectId,planEntity.getProjectId());
		monthUpdateWrapper.between(MonthPlanEntity::getPlanMonth,yearFirstDate,yearLastDate);
		monthUpdateWrapper.eq(MonthPlanEntity::getDr,0);
		List<MonthPlanEntity> monthList = monthPlanService.list(monthUpdateWrapper);
		if (CollectionUtils.isNotEmpty(monthList)){
			return CommonResponse.error("此年计划存在月计划，暂不支持回退功能!");
		}

		LambdaQueryWrapper<WeekPlanEntity> weekUpdateWrapper = new LambdaQueryWrapper<>();
		weekUpdateWrapper.eq(WeekPlanEntity::getProjectId,planEntity.getProjectId());
		weekUpdateWrapper.between(WeekPlanEntity::getPlanMonth,yearFirstDate,yearLastDate);
		weekUpdateWrapper.eq(WeekPlanEntity::getDr,0);
		List<WeekPlanEntity> weekList = weekPlanService.list(weekUpdateWrapper);
		if (CollectionUtils.isNotEmpty(weekList)){
			return CommonResponse.error("此年计划存在周计划，暂不支持回退功能!");
		}

		LambdaUpdateWrapper<YearPlanEntity> lambd = new LambdaUpdateWrapper<>();
		lambd.set(YearPlanEntity::getCommitTime, null);
		lambd.set(YearPlanEntity::getApprovedTime, null);
		lambd.set(YearPlanEntity::getFinishFlag, null);
		lambd.eq(YearPlanEntity::getId, billId);
		yearPlanService.update(lambd);
		logger.info("年计划开始撤回推送执行计划 bill-{}",billId);
		execPlanService.pushExecPlanRollBack(billId, PlanConstant.YEAR_PLAN);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
