package com.ejianc.business.plan.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SeparatorUtil {

    private final static String SEPARATOR = "@@";

    public static List<String> substringAndPre(String str) {
        return substringAndPre(str, SEPARATOR);
    }

    public static List<String> substringAndPre(String str, String separator){
        if(StringUtils.isEmpty(str)){
            return new ArrayList<>();
        }
        List<String> strs = new ArrayList<>();
        int cont = StringUtils.countMatches(str, separator);
        String pre = str;
        strs.add(pre);
        for(int i = 0; i < cont; i++){
            pre = substringAndLast(pre, separator, i);
            strs.add(pre);
        }
        Collections.reverse(strs);
        return strs;
    }

    public static String substringAndLast(final String str, final String separator, final int i) {
        if (isEmpty(str) || isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        pos = str.lastIndexOf(separator, pos - i);
        return str.substring(0, pos + separator.length());
    }

    public static boolean isEmpty(final CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isChild(final String str, final String parent) {
        return SeparatorUtil.substringAndPre(str).contains(parent + SEPARATOR);
    }

    public static void main(String[] args) {
        String str = "1@@33@@34@@37@@38";
        System.out.println(JSONObject.toJSONString(substringAndPre(str)));
    }

}
