package com.ejianc.business.progress.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.progress.bean.NodeArchivesEntity;
import com.ejianc.business.progress.cons.PartCons;
import com.ejianc.business.progress.mapper.NodeArchivesMapper;
import com.ejianc.business.progress.service.INodeArchivesService;
import com.ejianc.business.progress.utils.InnerCodeTool;
import com.ejianc.business.progress.vo.NodeArchivesVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 节点档案分类实体
 * 
 * @author generator
 * 
 */
@Service("nodeArchivesService")
public class NodeArchivesServiceImpl extends BaseServiceImpl<NodeArchivesMapper, NodeArchivesEntity> implements INodeArchivesService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<NodeArchivesVO> saveOrUpdate(NodeArchivesVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        NodeArchivesEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            // 修改
            NodeArchivesEntity oldEntity = baseMapper.selectById(saveorUpdateVO.getId());
            entity = BeanMapper.map(oldEntity, NodeArchivesEntity.class);
            entity.setCode(saveorUpdateVO.getCode());
            entity.setName(saveorUpdateVO.getName());
            entity.setParentId(saveorUpdateVO.getParentId());
            QueryParam param = new QueryParam();
            param.getParams().put("inner_code", new Parameter(QueryParam.LIKE, oldEntity.getInnerCode()));
            param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
            List<NodeArchivesEntity> oldEntities = super.queryList(param);
            // 原本没有父级，现在有
            if ((oldEntity.getParentId() == null || oldEntity.getParentId() <= 0)
                    && (entity.getParentId() != null && entity.getParentId() > 0)) {
                NodeArchivesEntity parentEntity = baseMapper.selectById(entity.getParentId());
                for (NodeArchivesEntity nae : oldEntities) {
                    if (nae.getId().equals(entity.getId())) {
                        nae.setParentId(entity.getParentId());
                        nae.setName(entity.getName());
                        nae.setCode(entity.getCode());
                    }
                    nae.setInnerCode(parentEntity.getInnerCode() + "," + nae.getInnerCode());
                }
                super.saveOrUpdateBatch(oldEntities);
                return CommonResponse.success("修改成功！");
            }
            // 原本有父级，现在没有
            if ((entity.getParentId() == null || entity.getParentId() <= 0)
                    && (oldEntity.getParentId() != null && oldEntity.getParentId() > 0)) {
                for (NodeArchivesEntity nae : oldEntities) {
                    if (nae.getId().equals(entity.getId())) {
                        nae.setParentId(entity.getParentId());
                        nae.setName(entity.getName());
                        nae.setCode(entity.getCode());
                    }

                    String innerCode = nae.getInnerCode().replaceAll(oldEntity.getInnerCode(), oldEntity.getId().toString());
                    nae.setInnerCode(innerCode);
                }
                super.saveOrUpdateBatch(oldEntities);
                return CommonResponse.success("修改成功！");
            }
            //原本有父级，现在改变了
            if ((entity.getParentId() != null && entity.getParentId() > 0)
                    && (oldEntity.getParentId() != null && oldEntity.getParentId() > 0)
                    && !entity.getParentId().equals(oldEntity.getParentId())) {
                NodeArchivesEntity parentEntity = baseMapper.selectById(entity.getParentId());
                for (NodeArchivesEntity nae : oldEntities) {
                    if (nae.getId().equals(entity.getId())) {
                        nae.setParentId(entity.getParentId());
                        nae.setName(entity.getName());
                        nae.setCode(entity.getCode());
                    }
                    String innerCode = nae.getInnerCode().replaceAll(oldEntity.getInnerCode(), parentEntity.getInnerCode() + "," + oldEntity.getId());
                    nae.setInnerCode(innerCode);
                }
                super.saveOrUpdateBatch(oldEntities);
                return CommonResponse.success("修改成功！");
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        }else {
            // 新增
            entity = BeanMapper.map(saveorUpdateVO, NodeArchivesEntity.class);
            entity.setId(IdWorker.getId());

            if (StringUtils.isBlank(entity.getCode())) {
                entity.setCode(creatCode(entity.getParentId(), tenantId));
            } else {
                LambdaQueryWrapper<NodeArchivesEntity> lambda = Wrappers.<NodeArchivesEntity>lambdaQuery();
                lambda.eq(NodeArchivesEntity::getTenantId, tenantId);
                lambda.eq(NodeArchivesEntity::getCode, entity.getCode());
                lambda.eq(NodeArchivesEntity::getDr, 0);
                List<NodeArchivesEntity> entities = super.list(lambda);
                if (CollectionUtils.isNotEmpty(entities)) {
                    throw new BusinessException("存在相同编码，不允许保存!");
                }
            }

            if (entity.getParentId() != null && entity.getParentId() > 0) {
                NodeArchivesEntity uniqueBean = baseMapper.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }

            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");

        }
    }

    @Override
    public String getPcode(Long id) {
        return baseMapper.getPcode(id);
    }

    @Override
    public List<Long> getChildIds(Long id) {
        NodeArchivesEntity entity = baseMapper.selectById(id);
        QueryParam param = new QueryParam();
        param.getParams().put("inner_code", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<NodeArchivesEntity> oldEntities = super.queryList(param);
        return oldEntities.stream().map(NodeArchivesEntity::getId).collect(Collectors.toList());

    }

    @Override
    public List<Map<String, Object>> treeRef(Long id) {
        /** 租户隔离 */
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (id != null && id > 0) {
            NodeArchivesEntity entity = super.selectById(id);
            param.getParams().put("innerCode", new Parameter(QueryParam.NOT_LIKE, entity.getInnerCode()));
        }
        param.getOrderMap().put("id", "asc");
        List<NodeArchivesEntity> list = super.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        return ResultAsTree.createTreeData(resultMapList);
    }

    @Override
    public List<NodeArchivesEntity> queryListByPid(Long id) {
        NodeArchivesEntity entity = baseMapper.selectById(id);
        QueryParam param = new QueryParam();
        param.getParams().put("inner_code", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
        param.getParams().put("id", new Parameter(QueryParam.NE, id));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        return super.queryList(param);

    }


    /**
     * 生成编码
     *
     * @param pid
     * @param tenantid
     * @return
     */
    private String creatCode(Long pid, Long tenantid) {
        // 获取最大的code 暂不考虑并发问题、几率很小
        String pcode = "";
        if (pid != null && pid > 0) {
            pcode = getPcode(pid);
        }
        String getMaxCode = baseMapper.getMaxCode(tenantid, pcode, PartCons.CATEGORY_LENGTH);
        String nextValue = InnerCodeTool.getNextValue(getMaxCode, PartCons.CATEGORY_LENGTH);
        return pcode + nextValue;
    }


}
