/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.project.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEntity;
import com.ejianc.business.probuilddiary.project.service.IProjectLogService;
import com.ejianc.business.probuilddiary.project.vo.ProjectLogVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"projectLog"})
public class ProjectLogController
implements Serializable {
    private static final long serialVersionUID = -1763011100374980137L;
    private static final String RULE_CODE = "ZJKJ-BUILD-DIARY-PROJECT-LOG";
    private static final String BILL_CODE = "EJCBT202211000002";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final IBillCodeApi billCodeApi;
    private final IOrgApi iOrgApi;
    private final IProjectLogService service;

    public ProjectLogController(SessionManager sessionManager, IBillTypeApi billTypeApi, IBillCodeApi billCodeApi, IOrgApi iOrgApi, IProjectLogService service) {
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.billCodeApi = billCodeApi;
        this.iOrgApi = iOrgApi;
        this.service = service;
    }

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<ProjectLogVO> saveOrUpdate(@RequestBody ProjectLogVO saveOrUpdateVO) {
        ProjectLogEntity entity = (ProjectLogEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectLogEntity.class));
        if (null == entity.getId() || 0L == entity.getId()) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.checkPersonBillState(entity);
        entity.setBillName("\u9879\u76ee\u65e5\u5fd7");
        entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)this.service.selectById(entity.getId()), ProjectLogVO.class));
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<ProjectLogVO> queryDetail(@RequestParam(value="id", required=true) Long id) {
        ProjectLogEntity entity = (ProjectLogEntity)((Object)this.service.selectById(id));
        ProjectLogVO vo = (ProjectLogVO)BeanMapper.map((Object)((Object)entity), ProjectLogVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<ProjectLogVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectLogVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        List projectLogVOS = BeanMapper.mapList((Iterable)page.getRecords(), ProjectLogVO.class);
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("records", (Object)projectLogVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("memo");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        ArrayList projectLogVOS = new ArrayList();
        page.getRecords().forEach(e -> {
            ProjectLogVO projectLogVO = (ProjectLogVO)BeanMapper.map((Object)e, ProjectLogVO.class);
            projectLogVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)projectLogVO.getBillState()).getDescription());
            projectLogVOS.add(projectLogVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", projectLogVOS);
        ExcelExport.getInstance().export("project-log-export.xlsx", beans, response);
    }

    @PostMapping(value={"/hasProjectLog"})
    public CommonResponse<Boolean> hasProjectLog(@RequestBody JSONObject jsonObject) {
        if (!jsonObject.containsKey((Object)"projectId")) {
            throw new BusinessException("\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!jsonObject.containsKey((Object)"fillDate")) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.hasProjectLog(jsonObject.getLong("projectId"), jsonObject.getDate("fillDate"), jsonObject.getLong("billId")));
    }

    @PostMapping(value={"/countBillNum"})
    public CommonResponse<Map<String, Integer>> countBillNum(@RequestBody JSONObject jsonObject) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.service.countBillNum(jsonObject));
    }

    @PostMapping(value={"/warn"})
    public CommonResponse<String> warn(HttpServletRequest request) {
        this.logger.info("\u9879\u76ee\u65e5\u5fd7\u9884\u8b66--------start");
        this.service.warn(request);
        this.logger.info("\u9879\u76ee\u65e5\u5fd7\u9884\u8b66--------end");
        return CommonResponse.success();
    }
}

