package com.ejianc.business.fill.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.fill.bean.MonthFillDetailEntity;
/**
 * 月进度计划填报
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zjkjprogress_month_fill")
public class MonthFillEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="project_control_level")
    private Long projectControlLevel; // 项目管控级别(自定义档案)
    @TableField(value="fill_date")
    private Date fillDate; // 填报日期
    @TableField(value="fill_user_id")
    private Long fillUserId; // 填报人主键
    @TableField(value="fill_user_name")
    private String fillUserName; // 填报人名称
    @TableField(value="finish_flag")
    private Integer finishFlag; // 是否按时完成(≥0时按时完成，<0时延期多少天)
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="source_id")
    private Long sourceId; // 执行计划单据主键
    @TableField(value="calendar_uid")
    private String calendarUid; // 日历主键
    @TableField(value="calendars")
    private String calendars; // 日历
    @TableField(value="plan_month")
    private Date planMonth; // 计划月度
    @TableField(value="month_id")
    private Long monthId; // 月计划主键
    @TableField(value="corp_id")
    private Long corpId; // 区域公司
    @TableField(value="corp_code")
    private String corpCode; // 区域公司编码
    @TableField(value="corp_name")
    private String corpName; // 区域公司名称
    @TableField(value="project_manager_name")
    private String projectManagerName; // 项目经理名称
    @TableField(value="project_manager_id")
    private Long projectManagerId; // 项目经理主键
    @TableField(value="plan_code")
    private String planCode; // 计划编号
    
    @TableField(exist=false)
    @SubEntity(serviceName="monthFillDetailService",pidName = "progressId")
    private List<MonthFillDetailEntity> monthFillDetailList = new ArrayList<>(); // 月进度计划填报详情

    @TableField(value="sign_days")
    private Integer signDays; // 工期签证天数
    @TableField(value="wait_days")
    private Integer waitDays; // 待批工期签证
    @TableField(value="image_shows")
    private String imageShows; // 形象进度
    @TableField(value="reason")
    private String reason; // 原因分析
    @TableField(value="measure")
    private String measure; // 拟采取措施

    public Integer getSignDays() {
        return signDays;
    }

    public void setSignDays(Integer signDays) {
        this.signDays = signDays;
    }

    public Integer getWaitDays() {
        return waitDays;
    }

    public void setWaitDays(Integer waitDays) {
        this.waitDays = waitDays;
    }

    public String getImageShows() {
        return imageShows;
    }

    public void setImageShows(String imageShows) {
        this.imageShows = imageShows;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getMeasure() {
        return measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getProjectControlLevel() {
        return projectControlLevel;
    }

    public void setProjectControlLevel(Long projectControlLevel) {
        this.projectControlLevel = projectControlLevel;
    }

    public Date getFillDate() {
        return fillDate;
    }

    public void setFillDate(Date fillDate) {
        this.fillDate = fillDate;
    }

    public Long getFillUserId() {
        return fillUserId;
    }

    public void setFillUserId(Long fillUserId) {
        this.fillUserId = fillUserId;
    }

    public String getFillUserName() {
        return fillUserName;
    }

    public void setFillUserName(String fillUserName) {
        this.fillUserName = fillUserName;
    }

    public Integer getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getCalendarUid() {
        return calendarUid;
    }

    public void setCalendarUid(String calendarUid) {
        this.calendarUid = calendarUid;
    }

    public String getCalendars() {
        return calendars;
    }

    public void setCalendars(String calendars) {
        this.calendars = calendars;
    }

    public Date getPlanMonth() {
        return planMonth;
    }

    public void setPlanMonth(Date planMonth) {
        this.planMonth = planMonth;
    }

    public Long getMonthId() {
        return monthId;
    }

    public void setMonthId(Long monthId) {
        this.monthId = monthId;
    }

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public Long getProjectManagerId() {
        return projectManagerId;
    }

    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public List<MonthFillDetailEntity> getMonthFillDetailList() {
        return monthFillDetailList;
    }

    public void setMonthFillDetailList(List<MonthFillDetailEntity> monthFillDetailList) {
        this.monthFillDetailList = monthFillDetailList;
    }
}
