package com.ejianc.business.fill.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.fill.bean.MonthFillDetailEntity;
import com.ejianc.business.fill.service.IMonthFillDetailService;
import com.ejianc.business.fill.vo.MonthFillDetailVO;
import com.ejianc.business.fill.vo.MonthFillVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fill.mapper.MonthFillMapper;
import com.ejianc.business.fill.bean.MonthFillEntity;
import com.ejianc.business.fill.service.IMonthFillService;

import java.util.ArrayList;
import java.util.List;

/**
 * 月进度计划填报
 * 
 * @author generator
 * 
 */
@Service("monthFillService")
public class MonthFillServiceImpl extends BaseServiceImpl<MonthFillMapper, MonthFillEntity> implements IMonthFillService{

    @Autowired
    private IMonthFillDetailService detailService;

    @Override
    public MonthFillVO queryDetail(Long id) {
        MonthFillEntity entity = baseMapper.selectById(id);
        //查询子表
        QueryWrapper<MonthFillDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", id);
        ew.orderByAsc("tid");
        List<MonthFillDetailEntity> detailList = detailService.list(ew);
        MonthFillVO vo = BeanMapper.map(entity, MonthFillVO.class);
        if(CollectionUtils.isNotEmpty(detailList)) {
            List<MonthFillDetailVO> detailVOList = new ArrayList<>();
            for(MonthFillDetailEntity detail : detailList) {
                detailVOList.add(MonthFillDetailEntity.convertEntityToVo(detail));
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return vo;
    }
}
