package com.ejianc.business.progress.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * 推送设置实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_progress_push_set")
public class PushSetEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_inner_code")
    private String orgInnerCode; // 组织内码
    @TableField(value="industry_type_id")
    private Long industryTypeId; // 行业类型主键
    @TableField(value="industry_type_name")
    private String industryTypeName; // 行业类型名称
    @TableField(value="fill_type")
    private String fillType; // 推送周期 1-每天 2-每周 3-每月
    @TableField(value="fill_time")
    private String fillTime; // 推送日期
    @TableField(value="description")
    private String description; // 推送备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="project_control")
    private Long projectControl; // 项目管控级别
    @TableField(value="project_control_name")
    private String projectControlName; // 项目管控级别名称

    @TableField(exist=false)
    @SubEntity(serviceName="pushSetLevelService",pidName = "setId")
    private List<PushSetLevelEntity> levelList = new ArrayList<>(); // 推送设置层级实体
    

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 所属组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 组织内码
     */
    public String getOrgInnerCode() {
        return orgInnerCode;
    }

    /**
     * 组织内码
     */
    public void setOrgInnerCode(String orgInnerCode) {
        this.orgInnerCode = orgInnerCode;
    }
    /**
     * 行业类型主键
     */
    public Long getIndustryTypeId() {
        return industryTypeId;
    }

    /**
     * 行业类型主键
     */
    public void setIndustryTypeId(Long industryTypeId) {
        this.industryTypeId = industryTypeId;
    }
    /**
     * 行业类型名称
     */
    public String getIndustryTypeName() {
        return industryTypeName;
    }

    /**
     * 行业类型名称
     */
    public void setIndustryTypeName(String industryTypeName) {
        this.industryTypeName = industryTypeName;
    }
    /**
     * 推送周期 1-每天 2-每周 3-每月
     */
    public String getFillType() {
        return fillType;
    }

    /**
     * 推送周期 1-每天 2-每周 3-每月
     */
    public void setFillType(String fillType) {
        this.fillType = fillType;
    }
    /**
     * 推送日期
     */
    public String getFillTime() {
        return fillTime;
    }

    /**
     * 推送日期
     */
    public void setFillTime(String fillTime) {
        this.fillTime = fillTime;
    }
    /**
     * 推送备注
     */
    public String getDescription() {
        return description;
    }

    /**
     * 推送备注
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 创建人名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    
    /**
     * 推送设置层级实体
     */
    public List<PushSetLevelEntity> getLevelList() {
        return levelList;
    }

    /**
     * 推送设置层级实体
     */
    public void setLevelList(List<PushSetLevelEntity> levelList) {
        this.levelList = levelList;
    }

    public Long getProjectControl() {
        return projectControl;
    }

    public void setProjectControl(Long projectControl) {
        this.projectControl = projectControl;
    }

    public String getProjectControlName() {
        return projectControlName;
    }

    public void setProjectControlName(String projectControlName) {
        this.projectControlName = projectControlName;
    }
}
