package com.ejianc.business.progress.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.business.progress.bean.ProgressEntity;
import com.ejianc.business.progress.service.IProgressDetailService;
import com.ejianc.business.progress.service.IProgressService;
import com.ejianc.business.progress.utils.TreeHelper;
import com.ejianc.business.progress.vo.ProgressDetailVO;
import com.ejianc.business.progress.vo.ProgressVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("/progress/")
public class ProgressController implements Serializable {

	private static final long serialVersionUID = 1L;

	@Autowired
	private IProgressService progressService;
	@Autowired
	private IProgressDetailService progressDetailService;

	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<ProgressVO> saveOrUpdate(@RequestBody ProgressVO progressVO) {
		progressService.saveOrUpdate(progressVO);
		return CommonResponse.success();
	}

	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ProgressVO> queryDetail(@RequestParam Long id) {
		ProgressEntity progressEntity = progressService.selectById(id);
		
		//查询子表
		QueryWrapper<ProgressDetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("progress_id", id);
		queryWrapper.orderByAsc("tid");
		List<ProgressDetailEntity> progressDetailList = progressDetailService.list(queryWrapper);
		
		ProgressVO progressVo = BeanMapper.map(progressEntity, ProgressVO.class);
		if(progressDetailList != null && progressDetailList.size() > 0) {
			List<ProgressDetailVO> progressDetailVoList = new ArrayList<ProgressDetailVO>();
			for(ProgressDetailEntity progressDetailEntity:progressDetailList) {
				progressDetailVoList.add(ProgressDetailEntity.convertEntityToVo(progressDetailEntity));
			}
			progressVo.setProgressDetailList(TreeHelper.list2Tree(progressDetailVoList));
		}
		return CommonResponse.success(progressVo);
	}

	@RequestMapping(value = "/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam Long id) {
		progressService.removeById(id);
		
		progressDetailService.deleteDetailByProgressId(id);
		
		return CommonResponse.success();
	}

	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<ProgressEntity>> pageList(@RequestBody QueryParam queryParam) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
		IPage<ProgressEntity> pageData = progressService.queryPage(queryParam);
		return CommonResponse.success(pageData);
	}

}
