package com.ejianc.business.progress.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.progress.bean.LightRuleEntity;
import com.ejianc.business.progress.mapper.LightRuleMapper;
import com.ejianc.business.progress.service.ILightRuleService;
import com.ejianc.business.progress.vo.LightRuleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 亮灯规则模板实体
 * 
 * @author generator
 * 
 */
@Service("lightRuleService")
public class LightRuleServiceImpl extends BaseServiceImpl<LightRuleMapper, LightRuleEntity> implements ILightRuleService{

    private static final String RULE_CODE = "ZZKJ_LIGHT_RULE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public LightRuleVO saveOrUpdate(LightRuleVO saveorUpdateVO) {
        /** 保存前校验 */
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("org_id", new Parameter(QueryParam.EQ, saveorUpdateVO.getOrgId()));
        queryParam.getParams().put("industry_type_id", new Parameter(QueryParam.EQ, saveorUpdateVO.getIndustryTypeId()));
        if(saveorUpdateVO.getId() != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveorUpdateVO.getId()));
        }
        List<LightRuleEntity> dataList = super.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(dataList)){
            throw new BusinessException("该组织下该行业已经存在对应亮灯规则模板！");
        }
        /** 保存 */
        LightRuleEntity entity = BeanMapper.map(saveorUpdateVO, LightRuleEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RULE_CODE, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, LightRuleVO.class);
    }
}
