package com.ejianc.business.progress.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.*;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;


public class WeatherUtil {
    /**
     * 获取实时天气2<br>
     * 方 法 名： getTodayWeather <br>
     *
     * @param Cityid 城市编码
     */
    public static Map<String, Object> getTodayWeather2(String Cityid)
            throws IOException, NullPointerException {
        // 连接中央气象台的API
        URL url = new URL("http://www.weather.com.cn/data/cityinfo/" + Cityid + ".html");
        //URL url = new URL("http://www.weather.com.cn/weather/" + Cityid + ".shtml");
        URLConnection connectionData = url.openConnection();
        connectionData.setConnectTimeout(1000);
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(
                    connectionData.getInputStream(), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null)
                sb.append(line);
            String datas = sb.toString();
            //System.out.println(datas);
            JSONObject jsonData = JSONObject.parseObject(datas);
            JSONObject info = jsonData.getJSONObject("weatherinfo");
            map.put("city", info.getString("city").toString());// 城市
            map.put("temp1", info.getString("temp1").toString());// 最高温度
            map.put("temp2", info.getString("temp2").toString());// 最低温度
            map.put("weather", info.getString("weather").toString());//天气
            map.put("ptime", info.getString("ptime").toString());// 发布时间
        } catch (SocketTimeoutException e) {
            System.out.println("连接超时");
        } catch (FileNotFoundException e) {
            System.out.println("加载文件出错");
        }
        return map;
    }

    /**
     * 获取所有中国 省份及一级城市
     */
    public String weather() {
        // TODO Auto-generated method stub
        String ws_url = "http://www.weather.com.cn/data/city3jdata/china.html";
        String str = "";
        try {
            URL url = new URL(ws_url);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));//解决乱码问题
            StringBuffer sb = new StringBuffer();
            String s = "";
            while ((s = br.readLine()) != null) {
                sb.append(s + "\r\n"); //将内容读取到StringBuffer中
            }
            br.close();
            //System.out.println(sb.toString());
            str = new String(sb.toString().getBytes());
        } catch (MalformedURLException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return str;
    }

    /**
     * 根据传入参数获取二级城市
     */
    public String secondCity(String provinceId) {
        String ws_url = "http://gz.weather.com.cn/data/city3jdata/provshi/" + provinceId + ".html";
        String str = "";
        try {
            URL url = new URL(ws_url);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));//解决乱码问题
            StringBuffer sb = new StringBuffer();
            String s = "";
            while ((s = br.readLine()) != null) {
                sb.append(s + "\r\n"); //将内容读取到StringBuffer中
            }
            br.close();
            //System.out.println(sb.toString()); 屏幕
            str = new String(sb.toString().getBytes());
        } catch (MalformedURLException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return str;
    }

    /**
     * 根据传入参数获取三级城市
     * id:省id+市id
     */
    public String thirdCity(String id) {
        String ws_url = "http://gz.weather.com.cn/data/city3jdata/station/" + id + ".html";
        String str = "";
        try {
            URL url = new URL(ws_url);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));//解决乱码问题
            StringBuffer sb = new StringBuffer();
            String s = "";
            while ((s = br.readLine()) != null) {
                sb.append(s + "\r\n"); //将内容读取到StringBuffer中
            }
            br.close();
            //System.out.println(sb.toString()); 屏幕
            str = new String(sb.toString().getBytes());
        } catch (MalformedURLException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return str;
    }

    /**
     * 获取七天的天气
     *
     * @param request
     * @param p       省
     * @param c       市
     * @return
     * @throws Exception
     */
    public static JSONObject getWeather(HttpServletRequest request, String p, String c) throws Exception {
        String qqWeatherUrl = "https://wis.qq.com/weather/common?source=pc&weather_type=forecast_24h&province=";
        String url = qqWeatherUrl + URLEncoder.encode(p, "UTF-8");
        if (StringUtils.isEmpty(c)) {
            url = url + "&city=" + URLEncoder.encode(p, "UTF-8");
        } else {
            url = url + "&city=" + URLEncoder.encode(c, "UTF-8");
        }
        String weather = null;
        try {
            weather = ReferHttpClientUtils.get(url, request);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return JSONObject.parseObject(weather);
    }


    public static void main(String[] args) {
        WeatherUtil w = new WeatherUtil();
        JSONObject jsonData = JSONObject.parseObject(w.weather());
        Map<String, String> map = (Map) jsonData;
        for (String code : map.keySet()) {
            System.out.println(code + ":" + map.get(code));
        }
        //w.getTodayWeather2("101180101");
    }


}
