/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fill.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.fill.bean.DayFillEntity;
import com.ejianc.business.fill.bean.MonthFillEntity;
import com.ejianc.business.fill.bean.WeekFillEntity;
import com.ejianc.business.fill.service.IDayFillService;
import com.ejianc.business.fill.service.IMonthFillService;
import com.ejianc.business.fill.service.IPlanFillWarnService;
import com.ejianc.business.fill.service.IWeekFillService;
import com.ejianc.business.fill.vo.DayFillVO;
import com.ejianc.business.market.api.IZjkjProjectApi;
import com.ejianc.business.market.vo.ProjectVO;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.bean.TotalPlanEntity;
import com.ejianc.business.plan.bean.YearPlanEntity;
import com.ejianc.business.plan.mapper.ExecPlanMapper;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.service.ITotalPlanService;
import com.ejianc.business.plan.service.IYearPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.vo.YearPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planFillWarnService")
public class PlanFillWarnServiceImpl
extends BaseServiceImpl<ExecPlanMapper, ExecPlanEntity>
implements IPlanFillWarnService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String TOTAL_URL = "/ejc-zjkjprogress-frontend/#/totalPlan/card";
    private static final String YEAR_URL = "/ejc-zjkjprogress-frontend/#/yearPlan/card";
    private static final String MONTH_URL = "/ejc-zjkjprogress-frontend/#/monthPlan/card";
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWeekFillService weekFillService;
    @Autowired
    private IMonthFillService monthFillService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IDayFillService dayFillService;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IYearPlanService yearPlanService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IZjkjProjectApi projectApi;

    /*
     * WARNING - void declaration
     */
    @Override
    public CommonResponse<String> fillWarn(JSONArray jsonParam, Integer type, String url) {
        List fills;
        Map<Long, List<BaseEntity>> fillMaps;
        List fillList;
        Date date;
        List dateList;
        LambdaQueryWrapper lambda;
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String time = LocalDateTime.now().format(formatter);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.gt(ExecPlanEntity::getPlanEndDate, (Object)time);
        List execList = this.execPlanService.list((Wrapper)queryWrapper);
        if (execList.isEmpty()) {
            return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
        }
        List execIds = execList.stream().map(ExecPlanEntity::getProjectId).collect(Collectors.toList());
        ArrayList<DayFillVO> list = new ArrayList<DayFillVO>();
        if (type == 0) {
            DayFillVO dvo;
            lambda = Wrappers.lambdaQuery();
            lambda.in(DayFillEntity::getProjectId, execIds);
            List dayFillList = this.dayFillService.list((Wrapper)lambda);
            Map<Long, List<DayFillEntity>> dayFillMaps = dayFillList.stream().filter(item -> item.getProjectId() != null).collect(Collectors.groupingBy(DayFillEntity::getProjectId));
            for (ExecPlanEntity execPlanEntity : execList) {
                if (dayFillMaps.containsKey(execPlanEntity.getProjectId())) continue;
                dvo = (DayFillVO)BeanMapper.map((Object)((Object)execPlanEntity), DayFillVO.class);
                dvo.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(), execPlanEntity.getCreateTime())));
                list.add(dvo);
            }
            block1: for (Map.Entry entry : dayFillMaps.entrySet()) {
                List dayFills = (List)entry.getValue();
                dateList = dayFills.stream().map(BaseEntity::getCreateTime).collect(Collectors.toList());
                date = dateList.stream().max(Date::compareTo).orElse(new Date());
                for (BaseEntity fill : dayFills) {
                    if (fill.getCreateTime().getTime() != date.getTime()) continue;
                    dvo = (DayFillVO)BeanMapper.map((Object)fill, DayFillVO.class);
                    dvo.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(), fill.getCreateTime())));
                    list.add(dvo);
                    continue block1;
                }
            }
        } else if (type == 1) {
            DayFillVO wvo;
            lambda = Wrappers.lambdaQuery();
            lambda.in(WeekFillEntity::getProjectId, execIds);
            fillList = this.weekFillService.list((Wrapper)lambda);
            fillMaps = fillList.stream().filter(item -> item.getProjectId() != null).collect(Collectors.groupingBy(WeekFillEntity::getProjectId));
            for (ExecPlanEntity execPlanEntity : execList) {
                if (fillMaps.containsKey(execPlanEntity.getProjectId())) continue;
                wvo = (DayFillVO)BeanMapper.map((Object)((Object)execPlanEntity), DayFillVO.class);
                wvo.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(), execPlanEntity.getCreateTime())));
                list.add(wvo);
            }
            block4: for (Map.Entry entry : fillMaps.entrySet()) {
                fills = (List)entry.getValue();
                dateList = fills.stream().map(BaseEntity::getCreateTime).collect(Collectors.toList());
                date = dateList.stream().max(Date::compareTo).orElse(new Date());
                for (BaseEntity fill : fills) {
                    if (fill.getCreateTime().getTime() != date.getTime()) continue;
                    wvo = (DayFillVO)BeanMapper.map((Object)fill, DayFillVO.class);
                    wvo.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(), fill.getCreateTime())));
                    list.add(wvo);
                    continue block4;
                }
            }
        } else {
            DayFillVO mvo;
            lambda = Wrappers.lambdaQuery();
            lambda.in(MonthFillEntity::getProjectId, execIds);
            fillList = this.monthFillService.list((Wrapper)lambda);
            fillMaps = fillList.stream().filter(item -> item.getProjectId() != null).collect(Collectors.groupingBy(MonthFillEntity::getProjectId));
            for (ExecPlanEntity execPlanEntity : execList) {
                if (fillMaps.containsKey(execPlanEntity.getProjectId())) continue;
                mvo = (DayFillVO)BeanMapper.map((Object)((Object)execPlanEntity), DayFillVO.class);
                mvo.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(), execPlanEntity.getCreateTime())));
                list.add(mvo);
            }
            block7: for (Map.Entry entry : fillMaps.entrySet()) {
                fills = (List)entry.getValue();
                dateList = fills.stream().map(BaseEntity::getCreateTime).collect(Collectors.toList());
                date = dateList.stream().max(Date::compareTo).orElse(new Date());
                for (BaseEntity fill : fills) {
                    if (fill.getCreateTime().getTime() != date.getTime()) continue;
                    mvo = (DayFillVO)BeanMapper.map((Object)fill, DayFillVO.class);
                    mvo.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(), fill.getCreateTime())));
                    list.add(mvo);
                    continue block7;
                }
            }
        }
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            if (!ListUtil.isNotEmpty(list)) continue;
            for (DayFillVO cvo : list) {
                int i1;
                JSONObject orgSet = null;
                Object var19_29 = null;
                Long orgId = cvo.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!Boolean.TRUE.equals(set.getBoolean("default"))) continue;
                    JSONObject jSONObject = set;
                    break;
                }
                if (orgSet == null) {
                    void var19_31;
                    orgSet = var19_31;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel")) && cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) <= -1) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + cvo.getBillCode());
                vo.setPcTitle(type == 0 ? "\u65e5\u8fdb\u5ea6\u53cd\u9988" : (type == 1 ? "\u5468\u8fdb\u5ea6\u53cd\u9988" : "\u6708\u8fdb\u5ea6\u53cd\u9988"));
                vo.setPcUrl(url);
                vo.setOrgId(cvo.getOrgId());
                vo.setSendOrgId(cvo.getOrgId() + "");
                vo.setOrgName(orgVO.getName());
                vo.setSourceId(cvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", cvo.getProjectName()).replaceAll("#days#", String.valueOf(cvo.getDays().intValue())));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", cvo.getProjectName()).replaceAll("#days#", String.valueOf(cvo.getDays().intValue())));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", cvo.getProjectName()).replaceAll("#days#", String.valueOf(cvo.getDays().intValue())));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @Override
    public CommonResponse<String> totalPlanWarn(JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter("eq", (Object)2));
        param.getParams().put("valid_status", new Parameter("eq", (Object)0));
        CommonResponse resp = this.projectApi.queryProjects(param);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        List data = (List)resp.getData();
        List ids = data.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(TotalPlanEntity::getProjectId, ids);
        List list = this.totalPlanService.list((Wrapper)lambda);
        Map<Long, TotalPlanEntity> map = list.stream().collect(Collectors.toMap(TotalPlanEntity::getProjectId, a -> a, (k1, k2) -> k1));
        ArrayList<ProjectVO> projectVOS = new ArrayList<ProjectVO>();
        for (ProjectVO datum : data) {
            if (map.containsKey(datum.getId()) || datum.getActualStartDate() == null && datum.getStartDate() == null) continue;
            datum.setFix(new BigDecimal(DateUtil.getBetweenDays(new Date(), datum.getActualStartDate() != null ? datum.getActualStartDate() : datum.getStartDate())));
            projectVOS.add(datum);
        }
        SimpleDateFormat sff = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            if (!ListUtil.isNotEmpty(projectVOS)) continue;
            for (ProjectVO cvo : projectVOS) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = cvo.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!Boolean.TRUE.equals(set.getBoolean("default"))) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel")) && cvo.getFix().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && cvo.getFix().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || cvo.getFix().compareTo(set.getBigDecimal("parameterValue")) <= -1) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + cvo.getBillCode());
                vo.setPcTitle("\u603b\u8ba1\u5212");
                vo.setPcUrl(TOTAL_URL);
                vo.setOrgId(cvo.getOrgId());
                vo.setSendOrgId(cvo.getOrgId() + "");
                vo.setOrgName(orgVO.getName());
                vo.setSourceId(cvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", cvo.getProjectName()).replaceAll("#startDate#", cvo.getActualStartDate() != null ? sff.format(cvo.getActualStartDate()) : sff.format(cvo.getStartDate())));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", cvo.getProjectName()).replaceAll("#startDate#", cvo.getActualStartDate() != null ? sff.format(cvo.getActualStartDate()) : sff.format(cvo.getStartDate())));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", cvo.getProjectName()).replaceAll("#startDate#", cvo.getActualStartDate() != null ? sff.format(cvo.getActualStartDate()) : sff.format(cvo.getStartDate())));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @Override
    public CommonResponse<String> yearPlanWarn(JSONArray jsonParam, Integer type) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        ArrayList<YearPlanVO> resList = new ArrayList<YearPlanVO>();
        QueryParam param = new QueryParam();
        param.getParams().put("status", new Parameter("eq", (Object)2));
        param.getParams().put("valid_status", new Parameter("eq", (Object)0));
        CommonResponse resp = this.projectApi.queryProjects(param);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        List data = (List)resp.getData();
        List ids = data.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String time = LocalDateTime.now().format(formatter);
        lambda.in(TotalPlanEntity::getProjectId, ids);
        lambda.in(TotalPlanEntity::getBillState, new Object[]{1, 3});
        lambda.gt(TotalPlanEntity::getPlanEndDate, (Object)time);
        List list = this.totalPlanService.list((Wrapper)lambda);
        Map<Long, TotalPlanEntity> map = list.stream().collect(Collectors.toMap(TotalPlanEntity::getProjectId, a -> a, (k1, k2) -> k1));
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.in(YearPlanEntity::getProjectId, ids);
        List yearList = this.yearPlanService.list((Wrapper)query);
        List yearPlanVoS = BeanMapper.mapList((Iterable)yearList, YearPlanVO.class);
        Map<Long, List<YearPlanVO>> maps = yearPlanVoS.stream().collect(Collectors.groupingBy(YearPlanVO::getProjectId));
        block0: for (TotalPlanEntity entity : list) {
            if (type == 0) {
                if (maps.containsKey(entity.getProjectId())) continue;
                YearPlanVO yearPlanVO = (YearPlanVO)BeanMapper.map((Object)((Object)entity), YearPlanVO.class);
                yearPlanVO.setDays(new BigDecimal(DateUtil.getBetweenDays(new Date(), entity.getApprovedTime())));
                resList.add(yearPlanVO);
                continue;
            }
            if (!maps.containsKey(entity.getProjectId())) continue;
            List<YearPlanVO> years = maps.get(entity.getProjectId());
            List yearLists = years.stream().map(YearPlanVO::getPlanYear).collect(Collectors.toList());
            Integer maxYear = yearLists.stream().max(Integer::compareTo).orElse(0);
            for (YearPlanVO vo : years) {
                if (!vo.getPlanYear().equals(maxYear)) continue;
                resList.add(vo);
                continue block0;
            }
        }
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            if (!ListUtil.isNotEmpty(resList)) continue;
            for (YearPlanVO cvo : resList) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = cvo.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!Boolean.TRUE.equals(set.getBoolean("default"))) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel"))) {
                        if (type == 0) {
                            if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                high = true;
                                useSetHigh = set;
                            }
                        } else {
                            cal.setTime(map.get(cvo.getProjectId()).getPlanEndDate());
                            if (cvo.getPlanYear() <= cal.get(1)) {
                                high = true;
                                useSetHigh = set;
                            }
                        }
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel"))) {
                        if (type == 0) {
                            if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                meddle = true;
                                useSetMeddle = set;
                            }
                        } else {
                            cal.setTime(map.get(cvo.getProjectId()).getPlanEndDate());
                            if (cvo.getPlanYear() <= cal.get(1)) {
                                meddle = true;
                                useSetMeddle = set;
                            }
                        }
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel"))) continue;
                    if (type == 0) {
                        if (cvo.getDays().compareTo(set.getBigDecimal("parameterValue")) <= -1) continue;
                        low = true;
                        useSetLow = set;
                        continue;
                    }
                    cal.setTime(map.get(cvo.getProjectId()).getPlanEndDate());
                    if (cvo.getPlanYear() > cal.get(1)) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + cvo.getBillCode());
                vo.setPcTitle("\u5e74\u8ba1\u5212");
                vo.setPcUrl(YEAR_URL);
                vo.setOrgId(cvo.getOrgId());
                vo.setSendOrgId(cvo.getOrgId() + "");
                vo.setOrgName(orgVO.getName());
                vo.setSourceId(cvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", cvo.getProjectName()).replaceAll("#year#", type == 0 ? String.valueOf(cal.get(1)) : String.valueOf(cvo.getPlanYear() + 1)));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", cvo.getProjectName()).replaceAll("#year#", type == 0 ? String.valueOf(cal.get(1)) : String.valueOf(cvo.getPlanYear() + 1)));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", cvo.getProjectName()).replaceAll("#year#", type == 0 ? String.valueOf(cal.get(1)) : String.valueOf(cvo.getPlanYear() + 1)));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @Override
    public CommonResponse<String> monthPlanWarn(JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String time = LocalDateTime.now().format(formatter);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.gt(ExecPlanEntity::getPlanEndDate, (Object)time);
        List execList = super.list((Wrapper)queryWrapper);
        if (execList.isEmpty()) {
            return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
        }
        List ids = execList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(MonthPlanEntity::getSourceId, ids);
        List list = this.monthPlanService.list((Wrapper)lambda);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, 1);
        String yf = String.valueOf(cal.get(2) + 1);
        String xysj = format.format(cal.getTime()) + "-01";
        Date sDate = new Date();
        try {
            sDate = format.parse(xysj);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ArrayList<MonthPlanEntity> resultList = new ArrayList<MonthPlanEntity>();
        ArrayList<MonthPlanEntity> zzList = new ArrayList<MonthPlanEntity>();
        Map<Long, List<MonthPlanEntity>> maps = list.stream().collect(Collectors.groupingBy(MonthPlanEntity::getProjectId));
        for (ExecPlanEntity execPlanEntity : execList) {
            if (maps.containsKey(execPlanEntity.getProjectId())) continue;
            MonthPlanEntity monthPlanEntity = (MonthPlanEntity)((Object)BeanMapper.map((Object)((Object)execPlanEntity), MonthPlanEntity.class));
            zzList.add(monthPlanEntity);
        }
        block3: for (Map.Entry entry : maps.entrySet()) {
            List result = (List)entry.getValue();
            List dateList = result.stream().map(MonthPlanEntity::getPlanMonth).collect(Collectors.toList());
            Date maxDate = dateList.stream().max(Date::compareTo).orElse(new Date());
            for (MonthPlanEntity entity : result) {
                if (entity.getPlanMonth().getTime() != maxDate.getTime()) continue;
                resultList.add(entity);
                continue block3;
            }
        }
        for (MonthPlanEntity monthPlanEntity : resultList) {
            if (monthPlanEntity.getPlanMonth().getTime() == sDate.getTime()) continue;
            zzList.add(monthPlanEntity);
        }
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject jSONObject = jsonParam.getJSONObject(i);
            Long tenantId = jSONObject.getLong("tenantId");
            warnCode = jSONObject.getString("warnCode");
            JSONArray orgSettings = jSONObject.getJSONArray("settings");
            if (!ListUtil.isNotEmpty(zzList)) continue;
            for (MonthPlanEntity cvo : zzList) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = cvo.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!Boolean.TRUE.equals(set.getBoolean("default"))) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel"))) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel"))) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel"))) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + cvo.getBillCode());
                vo.setPcTitle("\u6708\u8ba1\u5212");
                vo.setPcUrl(MONTH_URL);
                vo.setOrgId(cvo.getOrgId());
                vo.setSendOrgId(cvo.getOrgId() + "");
                vo.setOrgName(orgVO.getName());
                vo.setSourceId(cvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", cvo.getProjectName()).replaceAll("#month#", yf));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", cvo.getProjectName()).replaceAll("#month#", yf));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", cvo.getProjectName()).replaceAll("#month#", yf));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

