/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.MonthPlanChangeEntity;
import com.ejianc.business.plan.bean.MonthPlanDetailChangeEntity;
import com.ejianc.business.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.mapper.MonthPlanChangeMapper;
import com.ejianc.business.plan.mapper.MonthPlanDetailChangeMapper;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanChangeService;
import com.ejianc.business.plan.service.IMonthPlanDetailChangeService;
import com.ejianc.business.plan.service.IMonthPlanDetailService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.vo.MonthPlanChangeVO;
import com.ejianc.business.plan.vo.MonthPlanDetailChangeVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="monthPlanChangeService")
public class MonthPlanChangeServiceImpl
extends BaseServiceImpl<MonthPlanChangeMapper, MonthPlanChangeEntity>
implements IMonthPlanChangeService {
    @Autowired
    private MonthPlanChangeMapper changeMapper;
    @Autowired
    private MonthPlanDetailChangeMapper detailChangeMapper;
    @Autowired
    private IMonthPlanDetailChangeService detailChangeService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;

    @Override
    public CommonResponse<MonthPlanChangeVO> saveOrUpdate(MonthPlanChangeVO saveOrUpdateVO) {
        this.execPlanService.validateProject(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getId());
        Long tenantId = InvocationInfoProxy.getTenantid();
        MonthPlanChangeEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
            progressEntity = (MonthPlanChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MonthPlanChangeEntity.class));
            this.changeMapper.updateById((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
                if (saveOrUpdateVO.getImportFlag().booleanValue()) {
                    this.detailChangeService.deleteDetailByProgressId(progressEntity.getId());
                }
                List<MonthPlanDetailChangeEntity> planEntityList = new ArrayList();
                Iterator iterator = saveVOList.iterator();
                while (iterator.hasNext()) {
                    MonthPlanDetailChangeEntity progressDetailEntity;
                    MonthPlanDetailChangeVO progressDetailVo = (MonthPlanDetailChangeVO)iterator.next();
                    if (saveOrUpdateVO.getImportFlag().booleanValue() || "added".equals(progressDetailVo.get_state())) {
                        progressDetailEntity = MonthPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        planEntityList.add(progressDetailEntity);
                        continue;
                    }
                    if (!"modified".equals(progressDetailVo.get_state())) continue;
                    progressDetailEntity = MonthPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(progressEntity.getId());
                    this.detailChangeMapper.updateById((Object)progressDetailEntity);
                }
                if (CollectionUtils.isNotEmpty(planEntityList)) {
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    this.detailChangeService.saveOrUpdateBatch(planEntityList);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (MonthPlanDetailChangeVO progressDetailVo : delDetailList) {
                    this.detailChangeMapper.deleteById((Serializable)((Object)progressDetailVo.getUid()));
                }
            }
        } else {
            MonthPlanEntity totalPlanEntity = (MonthPlanEntity)((Object)this.monthPlanService.selectById(saveOrUpdateVO.getMonthId()));
            if (totalPlanEntity.getChangeStatus() == PlanConstant.CHANGE_ING) {
                throw new BusinessException("\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            Long masterPkId = IdWorker.getId();
            progressEntity = (MonthPlanChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MonthPlanChangeEntity.class));
            progressEntity.setId(masterPkId);
            this.changeMapper.insert((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, true);
                List<MonthPlanDetailChangeEntity> planEntityList = new ArrayList();
                for (MonthPlanDetailChangeVO progressDetailVo : saveVOList) {
                    MonthPlanDetailChangeEntity progressDetailEntity = MonthPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    planEntityList.add(progressDetailEntity);
                }
                if (CollectionUtils.isNotEmpty(planEntityList)) {
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    this.detailChangeService.saveOrUpdateBatch(planEntityList);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(MonthPlanEntity::getChangeId, (Object)progressEntity.getId());
            updateWrapper.set(MonthPlanEntity::getChangeStatus, (Object)PlanConstant.CHANGE_ING);
            updateWrapper.set(MonthPlanEntity::getChangeCode, (Object)progressEntity.getBillCode());
            updateWrapper.eq(BaseEntity::getId, (Object)progressEntity.getMonthId());
            this.monthPlanService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((Object)this.queryDetail(progressEntity.getId()));
    }

    @Override
    public MonthPlanChangeVO queryDetail(Long id) {
        MonthPlanChangeEntity progressEntity = (MonthPlanChangeEntity)((Object)((MonthPlanChangeMapper)this.baseMapper).selectById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.detailChangeService.list((Wrapper)queryWrapper);
        List<String> useTasks = this.commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());
        MonthPlanChangeVO progressVo = (MonthPlanChangeVO)BeanMapper.map((Object)((Object)progressEntity), MonthPlanChangeVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<MonthPlanDetailChangeVO> progressDetailVoList = new ArrayList<MonthPlanDetailChangeVO>();
            for (MonthPlanDetailChangeEntity progressDetailEntity : progressDetailList) {
                MonthPlanDetailChangeVO changeVO = MonthPlanDetailChangeEntity.convertEntityToVo(progressDetailEntity);
                changeVO.setUseState(Boolean.valueOf(false));
                if (useTasks.contains(changeVO.getStructCode())) {
                    changeVO.setUseState(Boolean.valueOf(true));
                }
                progressDetailVoList.add(changeVO);
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public MonthPlanChangeVO queryDetailChange(Long id) {
        MonthPlanEntity progressEntity = (MonthPlanEntity)((Object)this.monthPlanService.selectById(id));
        MonthPlanChangeVO vo = (MonthPlanChangeVO)BeanMapper.map((Object)((Object)progressEntity), MonthPlanChangeVO.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.monthPlanDetailService.list((Wrapper)queryWrapper);
        List<String> useTasks = this.commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<MonthPlanDetailChangeVO> progressDetailVoList = new ArrayList<MonthPlanDetailChangeVO>();
            for (MonthPlanDetailEntity progressDetailEntity : progressDetailList) {
                MonthPlanDetailChangeEntity changeDetailEntity = (MonthPlanDetailChangeEntity)((Object)BeanMapper.map((Object)((Object)progressDetailEntity), MonthPlanDetailChangeEntity.class));
                changeDetailEntity.setMonthId(changeDetailEntity.getProgressId());
                changeDetailEntity.setMonthBid(changeDetailEntity.getId());
                changeDetailEntity.setProgressId(null);
                changeDetailEntity.setChangeType(PlanConstant.CHANGE_TYPE_NO);
                MonthPlanDetailChangeVO changeVO = MonthPlanDetailChangeEntity.convertEntityToVo(changeDetailEntity);
                changeVO.setUseState(Boolean.valueOf(false));
                if (useTasks.contains(changeVO.getStructCode())) {
                    changeVO.setUseState(Boolean.valueOf(true));
                }
                progressDetailVoList.add(changeVO);
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        vo.setMonthId(vo.getId());
        vo.setId(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setChangeReason(null);
        vo.setChangeDescription(null);
        vo.setChangeVersion(Integer.valueOf(vo.getChangeVersion() + 1));
        return vo;
    }

    @Override
    public void deleteMonthPlan(List<MonthPlanChangeVO> vos) {
        for (MonthPlanChangeVO vo : vos) {
            MonthPlanChangeEntity changeEntity = (MonthPlanChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            if (changeEntity.getChangeVersion() == 2) {
                updateWrapper.set(MonthPlanEntity::getChangeStatus, (Object)PlanConstant.CHANGE_NO);
            } else {
                updateWrapper.set(MonthPlanEntity::getChangeStatus, (Object)PlanConstant.CHANGE_OVER);
            }
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getMonthId());
            this.monthPlanService.update((Wrapper)updateWrapper);
            super.removeById((Serializable)vo, false);
            this.detailChangeService.deleteDetailByProgressId(vo.getId());
        }
    }

    @Override
    public List<MonthPlanChangeVO> queryChangeHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List changeEntities = ((MonthPlanChangeMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"month_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object)"approved_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List changeVos = BeanMapper.mapList((Iterable)changeEntities, MonthPlanChangeVO.class);
            for (MonthPlanChangeVO cvo : changeVos) {
                String historyBillCode = cvo.getBillCode() + "-" + (cvo.getChangeVersion() - 1);
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }

    @Override
    public List<Long> queryDelIds(Long projectId, List<Long> ids) {
        LambdaQueryWrapper ylambd = new LambdaQueryWrapper();
        ylambd.in(BaseEntity::getId, ids);
        List list = this.monthPlanDetailService.list((Wrapper)ylambd);
        return this.commonHelper.transferDelIds(list, projectId, PlanConstant.MONTH_PLAN);
    }
}

