package com.ejianc.busness.zjkjscene.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.busness.zjkjscene.mapper.ScheduleReportMapper;
import com.ejianc.busness.zjkjscene.bean.ScheduleReportEntity;
import com.ejianc.busness.zjkjscene.service.IScheduleReportService;

import java.util.List;


/**
 * 工期履约填报
 * 
 * @author generator
 * 
 */
@Service("scheduleReportService")
public class ScheduleReportServiceImpl extends BaseServiceImpl<ScheduleReportMapper, ScheduleReportEntity> implements IScheduleReportService{

    @Autowired
    private ScheduleReportMapper scheduleReportMapper;
    @Override
    public IPage<JSONObject> queryForReport(String searchText, String startDay, String endDay, Integer pageIndex, Integer pageSize) {
        Long total = scheduleReportMapper.queryForReportCount(searchText,(pageIndex-1)*pageSize,pageSize,startDay,endDay);
        IPage<JSONObject> pageData = new Page<>(pageIndex, pageSize, total);
        pageData.setRecords(scheduleReportMapper.queryForReportList(searchText,(pageIndex-1)*pageSize,pageSize,startDay,endDay));
        return pageData;
    }

    @Override
    public List<JSONObject> queryForReportAll(String searchText, String startDay, String endDay) {
        return scheduleReportMapper.queryForReportAll(searchText,startDay,endDay);
    }
}
