package com.ejianc.poc.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.poc.vo.ZtjAppVO;

public class MenuAsTree {
	
	public static List<ZtjAppVO> createTreeData(List<ZtjAppVO> list) {
		List<ZtjAppVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, ZtjAppVO> listMap = new HashMap<>();
		for(ZtjAppVO item:list) {
			listMap.put(item.getId().toString(), item);
		}
        
        for(int i =0; i<list.size(); i++) {
        	ZtjAppVO item = list.get(i);
        	String parentId = (item.getParentId() != null && item.getParentId() > 0) ? item.getParentId().toString():"";
        	ZtjAppVO parent = listMap.get(parentId);
        	if(parent != null) {
        		List<ZtjAppVO> child = parent.getChildren();
        		if(child != null) {
        			child.add(item);
        		}else{
        			List<ZtjAppVO> children = new ArrayList<ZtjAppVO>();
        			children.add(item);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(item.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

}
