/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.poc.bean.WorkAuthEntity;
import com.ejianc.poc.bean.WorkAuthSubEntity;
import com.ejianc.poc.service.IWorkAuthService;
import com.ejianc.poc.service.IWorkAuthSubService;
import com.ejianc.poc.service.IZtjAppService;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.WorkAuthVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"workAuth"})
public class WorkAuthController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ZtjApisService ztjApisService;
    @Autowired
    private IWorkAuthService service;
    @Autowired
    private IWorkAuthSubService subService;
    @Autowired
    private IZtjAppService appService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkAuthVO> saveOrUpdate(@RequestBody WorkAuthVO saveorUpdateVO) {
        WorkAuthEntity entity = (WorkAuthEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, WorkAuthEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        WorkAuthVO vo = (WorkAuthVO)BeanMapper.map((Object)((Object)entity), WorkAuthVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdateBatch(@RequestBody List<JSONObject> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            QueryParam param = new QueryParam();
            ArrayList<WorkAuthEntity> authEntities = new ArrayList<WorkAuthEntity>();
            Iterator<JSONObject> iterator = vos.iterator();
            while (iterator.hasNext()) {
                JSONObject vo;
                JSONObject object = vo = iterator.next();
                String corpProviderId = object.getString("corpProviderId");
                String corpPk = object.getString("corpPk");
                String targetType = object.getString("targetType");
                String providerId = object.getString("providerId");
                String targetId = object.getString("id");
                param.getParams().put("corpProviderId", new Parameter("eq", (Object)corpProviderId));
                param.getParams().put("corpPk", new Parameter("eq", (Object)corpPk));
                param.getParams().put("targetId", new Parameter("eq", (Object)targetId));
                param.getParams().put("providerId", new Parameter("eq", (Object)providerId));
                param.getParams().put("targetType", new Parameter("eq", (Object)targetType));
                List exist = this.service.queryList(param, false);
                if (ListUtil.isNotEmpty((List)exist)) {
                    return CommonResponse.error((String)("\u6388\u6743\u5bf9\u8c61\u3010" + vo.getString("name") + "\u3011\u5df2\u5b58\u5728\u6388\u6743\u5217\u8868\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6388\u6743\u3002"));
                }
                WorkAuthEntity entity = new WorkAuthEntity();
                entity.setCorpPk(corpPk);
                entity.setCorpProviderId(corpProviderId);
                JSONArray array = this.ztjApisService.getOrgPath(corpProviderId, corpPk);
                if (array.size() > 0) {
                    StringBuffer paths = new StringBuffer("");
                    if (array != null) {
                        for (int i = array.size() - 1; i > -1; --i) {
                            JSONObject p = array.getJSONObject(i);
                            if (p.get((Object)"virtual") != null && p.getBoolean("virtual").booleanValue()) continue;
                            paths.append(p.getString("name")).append(" ");
                        }
                    }
                    entity.setCorpName(paths.toString());
                }
                if (!"root_org_code".equals(corpProviderId)) {
                    JSONObject corp = this.ztjApisService.getOrgParent(corpProviderId, corpPk);
                    entity.setCorpParentPk(corp.getString("id"));
                    entity.setCorpParentProviderId(corp.getString("providerId"));
                }
                entity.setOrgId(object.getString("positionId"));
                entity.setProviderId(providerId);
                entity.setTargetType(Integer.valueOf(targetType));
                entity.setTargetId(targetId);
                authEntities.add(entity);
            }
            this.service.saveOrUpdateBatch(authEntities);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveOrUpdateSubBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdateSubBatch(@RequestBody List<JSONObject> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (JSONObject vo : vos) {
                if (vo.get((Object)"authSubId") == null && vo.getBoolean("auth").booleanValue()) {
                    WorkAuthSubEntity sub = new WorkAuthSubEntity();
                    sub.setPid(vo.getLong("pid"));
                    sub.setAuthId(vo.getLong("id"));
                    sub.setAuthName(vo.getString("name"));
                    this.subService.saveOrUpdate((Object)sub, false);
                    continue;
                }
                if (vo.get((Object)"authSubId") == null || vo.getBoolean("auth").booleanValue()) continue;
                this.subService.removeById(vo.getLong("authSubId"), false);
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkAuthVO> queryDetail(Long id) {
        WorkAuthEntity entity = (WorkAuthEntity)((Object)this.service.selectById(id));
        WorkAuthVO vo = (WorkAuthVO)BeanMapper.map((Object)((Object)entity), WorkAuthVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkAuthVO> vos) {
        for (int i = 0; i < vos.size(); ++i) {
            WorkAuthVO vo = vos.get(i);
            if (!vo.getTargetId().equals(InvocationInfoProxy.getUserid() + "")) continue;
            return CommonResponse.error((String)"\u6388\u6743\u5bf9\u8c61\u5305\u542b\u81ea\u5df1\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("in", vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        List subEntities = this.subService.queryList(param, false);
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        if (ListUtil.isNotEmpty((List)subEntities)) {
            this.subService.removeByIds(subEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkAuthVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), WorkAuthVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            records.forEach(auth -> {
                JSONObject user;
                JSONArray array = null;
                int ii = -1;
                if (auth.getTargetType() == 1) {
                    JSONObject position;
                    user = this.ztjApisService.getUser(auth.getProviderId(), auth.getTargetId());
                    if (user != null) {
                        auth.setTargetName(user.getString("name"));
                    }
                    if ((position = this.ztjApisService.getUserMainPosition(auth.getProviderId(), auth.getTargetId())) != null) {
                        if (!Objects.equals(auth.getOrgId(), position.getString("id"))) {
                            auth.setOrgId(position.getString("id"));
                            this.service.saveOrUpdate(BeanMapper.map((Object)auth, WorkAuthEntity.class));
                        }
                        array = this.ztjApisService.getOrgPath(auth.getProviderId(), position.getString("id"));
                    }
                } else {
                    ii = 0;
                    user = this.ztjApisService.getPosition(auth.getProviderId(), auth.getTargetId());
                    if (user != null) {
                        auth.setTargetName(user.getString("name"));
                    }
                    array = this.ztjApisService.getOrgPath(auth.getProviderId(), auth.getTargetId());
                }
                StringBuffer paths = new StringBuffer("");
                if (array != null) {
                    for (int i = array.size() - 1; i > ii; --i) {
                        JSONObject p = array.getJSONObject(i);
                        if (p.get((Object)"virtual") != null && p.getBoolean("virtual").booleanValue()) continue;
                        paths.append(p.getString("name")).append(" ");
                    }
                }
                auth.setOrgName(paths.toString());
            });
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAuthAppList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryAuthAppList(@RequestParam String pid) {
        QueryParam param = new QueryParam();
        List appEntities = this.appService.queryList(param, false);
        param.getParams().put("pid", new Parameter("eq", (Object)pid));
        List subEntities = this.subService.queryList(param, false);
        ArrayList res = new ArrayList();
        appEntities.forEach(app -> {
            JSONObject object = new JSONObject();
            object.put("id", (Object)app.getId());
            object.put("name", (Object)app.getName());
            object.put("pid", (Object)pid);
            if (ListUtil.isNotEmpty((List)subEntities)) {
                subEntities.forEach(s -> {
                    if (s.getAuthId().equals(app.getId())) {
                        object.put("auth", (Object)true);
                        object.put("authSubId", (Object)s.getId());
                    }
                });
                if (object.get((Object)"authSubId") == null) {
                    object.put("auth", (Object)false);
                    object.put("authSubId", null);
                }
            } else {
                object.put("auth", (Object)false);
                object.put("authSubId", null);
            }
            res.add(object);
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", res);
    }
}

