/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.poc.bean.LogParam;
import com.ejianc.poc.bean.PositionChangeEntity;
import com.ejianc.poc.bean.WorkAuthEntity;
import com.ejianc.poc.bean.WorkAuthSubEntity;
import com.ejianc.poc.service.ILogService;
import com.ejianc.poc.service.IPositionChangeService;
import com.ejianc.poc.service.IWorkAuthService;
import com.ejianc.poc.service.IWorkAuthSubService;
import com.ejianc.poc.service.IZtjAppService;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.OrgVO;
import com.ejianc.poc.vo.PositionChangeVO;
import com.ejianc.poc.vo.WorkAuthVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"workAuth"})
public class WorkAuthController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ZtjApisService ztjApisService;
    @Autowired
    private IWorkAuthService service;
    @Autowired
    private IWorkAuthSubService subService;
    @Autowired
    private IZtjAppService appService;
    @Autowired
    private IPositionChangeService positionChangeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ILogService logService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkAuthVO> saveOrUpdate(@RequestBody WorkAuthVO saveorUpdateVO) {
        WorkAuthEntity entity = (WorkAuthEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, WorkAuthEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        WorkAuthVO vo = (WorkAuthVO)BeanMapper.map((Object)((Object)entity), WorkAuthVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdateBatch(@RequestBody List<JSONObject> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            QueryParam param = new QueryParam();
            ArrayList<WorkAuthEntity> authEntities = new ArrayList<WorkAuthEntity>();
            JSONArray arrayLog = new JSONArray();
            for (JSONObject vo : vos) {
                JSONObject log = new JSONObject();
                String corpProviderId = vo.getString("corpProviderId");
                String corpPk = vo.getString("corpPk");
                String targetType = vo.getString("targetType");
                String providerId = vo.getString("providerId");
                String targetId = vo.getString("id");
                param.getParams().put("corpProviderId", new Parameter("eq", (Object)corpProviderId));
                param.getParams().put("corpPk", new Parameter("eq", (Object)corpPk));
                param.getParams().put("targetId", new Parameter("eq", (Object)targetId));
                param.getParams().put("providerId", new Parameter("eq", (Object)providerId));
                param.getParams().put("targetType", new Parameter("eq", (Object)targetType));
                List exist = this.service.queryList(param, false);
                if (ListUtil.isNotEmpty((List)exist)) {
                    return CommonResponse.error((String)("\u6388\u6743\u5bf9\u8c61\u3010" + vo.getString("name") + "\u3011\u5df2\u5b58\u5728\u6388\u6743\u5217\u8868\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6388\u6743\u3002"));
                }
                WorkAuthEntity entity = new WorkAuthEntity();
                entity.setCorpPk(corpPk);
                entity.setCorpProviderId(corpProviderId);
                JSONArray array = this.ztjApisService.getOrgPath(corpProviderId, corpPk);
                if (array.size() > 0) {
                    log.put("code", (Object)array.getJSONObject(0).getString("code"));
                    StringBuffer paths = new StringBuffer("");
                    if (array != null) {
                        for (int i = array.size() - 1; i > -1; --i) {
                            JSONObject p = array.getJSONObject(i);
                            if (p.get((Object)"virtual") != null && p.getBoolean("virtual").booleanValue()) continue;
                            paths.append(p.getString("name")).append(" ");
                        }
                    }
                    entity.setCorpName(paths.toString());
                }
                if (!"root_org_code".equals(corpProviderId)) {
                    JSONObject corp = this.ztjApisService.getOrgParent(corpProviderId, corpPk);
                    entity.setCorpParentPk(corp.getString("id"));
                    entity.setCorpParentProviderId(corp.getString("providerId"));
                }
                entity.setOrgId(vo.getString("positionId"));
                entity.setProviderId(providerId);
                entity.setTargetType(Integer.valueOf(targetType));
                entity.setTargetId(targetId);
                log.put("entity", (Object)entity);
                arrayLog.add((Object)log);
                authEntities.add(entity);
            }
            this.service.saveOrUpdateBatch(authEntities);
            arrayLog.forEach(en -> {
                JSONObject log = (JSONObject)en;
                LogParam logParam = new LogParam();
                logParam.setWhichNodeOrgCode(log.getString("code"));
                WorkAuthEntity entity = (WorkAuthEntity)((Object)((Object)log.get((Object)"entity")));
                logParam.setWhichNodeOrgId(entity.getCorpPk());
                logParam.setWhichNodeProviderId(entity.getCorpProviderId());
                logParam.setAuthObjectId(entity.getTargetId());
                logParam.setAuthObjectProviderId(entity.getProviderId());
                logParam.setAuthObjectType(entity.getTargetType() + "");
                logParam.setAuthOrgId(entity.getOrgId());
                logParam.setOptType(LogParam.OptTypeEnum.AUTH_OBJECT_ADD);
                this.logService.optLog(logParam);
            });
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveOrUpdateSubBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdateSubBatch(@RequestBody List<JSONObject> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (JSONObject vo : vos) {
                LogParam logParam = new LogParam();
                logParam.setWhichNodeOrgCode(vo.getString("corpProviderCode"));
                logParam.setWhichNodeOrgId(vo.getString("corpPk"));
                logParam.setWhichNodeProviderId(vo.getString("corpProviderId"));
                logParam.setAuthObjectId(vo.getString("targetId"));
                logParam.setAuthObjectProviderId(vo.getString("providerId"));
                logParam.setAuthObjectType(vo.getString("targetType"));
                logParam.setAuthOrgId(vo.getString("orgId"));
                if (vo.get((Object)"authSubId") == null && vo.getBoolean("auth").booleanValue()) {
                    WorkAuthSubEntity sub = new WorkAuthSubEntity();
                    sub.setPid(vo.getLong("pid"));
                    sub.setAuthId(vo.getLong("id"));
                    sub.setAuthName(vo.getString("name"));
                    this.subService.saveOrUpdate((Object)sub, false);
                    logParam.setOptType(LogParam.OptTypeEnum.APP_AUTH_ADD);
                    this.logService.optLog(logParam);
                    continue;
                }
                if (vo.get((Object)"authSubId") == null || vo.getBoolean("auth").booleanValue()) continue;
                this.subService.removeById(vo.getLong("authSubId"), false);
                logParam.setOptType(LogParam.OptTypeEnum.APP_AUTH_DEL);
                this.logService.optLog(logParam);
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkAuthVO> queryDetail(Long id) {
        WorkAuthEntity entity = (WorkAuthEntity)((Object)this.service.selectById(id));
        WorkAuthVO vo = (WorkAuthVO)BeanMapper.map((Object)((Object)entity), WorkAuthVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkAuthVO> vos) {
        for (int i = 0; i < vos.size(); ++i) {
            WorkAuthVO vo = vos.get(i);
            if (!vo.getTargetId().equals(InvocationInfoProxy.getUserid() + "")) continue;
            return CommonResponse.error((String)"\u6388\u6743\u5bf9\u8c61\u5305\u542b\u81ea\u5df1\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("in", vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        List subEntities = this.subService.queryList(param, false);
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        if (ListUtil.isNotEmpty((List)subEntities)) {
            this.subService.removeByIds(subEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        }
        JSONObject corp = this.ztjApisService.getSureOrg(vos.get(0).getCorpProviderId(), vos.get(0).getCorpPk());
        vos.forEach(entity -> {
            LogParam logParam = new LogParam();
            logParam.setWhichNodeOrgCode(corp.getString("code"));
            logParam.setWhichNodeOrgId(entity.getCorpPk());
            logParam.setWhichNodeProviderId(entity.getCorpProviderId());
            logParam.setAuthObjectId(entity.getTargetId());
            logParam.setAuthObjectProviderId(entity.getProviderId());
            logParam.setAuthObjectType(entity.getTargetType() + "");
            logParam.setAuthOrgId(entity.getOrgId());
            logParam.setOptType(LogParam.OptTypeEnum.AUTH_OBJECT_DEL);
            this.logService.optLog(logParam);
        });
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkAuthVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), WorkAuthVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            records.forEach(auth -> {
                JSONObject user;
                JSONArray array = null;
                int ii = -1;
                if (auth.getTargetType() == 1) {
                    JSONObject position;
                    user = this.ztjApisService.getUser(auth.getProviderId(), auth.getTargetId());
                    if (user != null) {
                        auth.setTargetName(user.getString("name"));
                    }
                    if ((position = this.ztjApisService.getUserMainPosition(auth.getProviderId(), auth.getTargetId())) != null) {
                        if (!Objects.equals(auth.getOrgId(), position.getString("id"))) {
                            auth.setOrgId(position.getString("id"));
                            this.service.saveOrUpdate(BeanMapper.map((Object)auth, WorkAuthEntity.class));
                        }
                        array = this.ztjApisService.getOrgPath(auth.getProviderId(), position.getString("id"));
                    }
                } else {
                    ii = 0;
                    user = this.ztjApisService.getPosition(auth.getProviderId(), auth.getTargetId());
                    if (user != null) {
                        auth.setTargetName(user.getString("name"));
                    }
                    array = this.ztjApisService.getOrgPath(auth.getProviderId(), auth.getTargetId());
                }
                StringBuffer paths = new StringBuffer("");
                if (array != null) {
                    for (int i = array.size() - 1; i > ii; --i) {
                        JSONObject p = array.getJSONObject(i);
                        if (p.get((Object)"virtual") != null && p.getBoolean("virtual").booleanValue()) continue;
                        paths.append(p.getString("name")).append(" ");
                    }
                }
                auth.setOrgName(paths.toString());
            });
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryStatisticsList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryStatisticsList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), WorkAuthVO.class);
        ArrayList recordList = new ArrayList();
        if (ListUtil.isNotEmpty((List)records)) {
            records.forEach(auth -> {
                JSONObject user;
                JSONArray array = null;
                int ii = -1;
                if (auth.getTargetType() == 1) {
                    JSONObject position;
                    user = this.ztjApisService.getUser(auth.getProviderId(), auth.getTargetId());
                    if (user != null) {
                        auth.setTargetName(user.getString("name"));
                    }
                    if ((position = this.ztjApisService.getUserMainPosition(auth.getProviderId(), auth.getTargetId())) != null) {
                        if (!Objects.equals(auth.getOrgId(), position.getString("id"))) {
                            auth.setOrgId(position.getString("id"));
                            this.service.saveOrUpdate(BeanMapper.map((Object)auth, WorkAuthEntity.class));
                        }
                        array = this.ztjApisService.getOrgPath(auth.getProviderId(), position.getString("id"));
                    }
                } else {
                    ii = 0;
                    user = this.ztjApisService.getPosition(auth.getProviderId(), auth.getTargetId());
                    if (user != null) {
                        auth.setTargetName(user.getString("name"));
                    }
                    array = this.ztjApisService.getOrgPath(auth.getProviderId(), auth.getTargetId());
                }
                StringBuffer paths = new StringBuffer("");
                if (array != null) {
                    for (int i = array.size() - 1; i > ii; --i) {
                        JSONObject p = array.getJSONObject(i);
                        if (p.get((Object)"virtual") != null && p.getBoolean("virtual").booleanValue()) continue;
                        paths.append(p.getString("name")).append(" ");
                    }
                }
                auth.setOrgName(paths.toString());
                QueryParam subParam = new QueryParam();
                subParam.getParams().put("pid", new Parameter("eq", (Object)auth.getId()));
                List subEntities = this.subService.queryList(subParam, false);
                JSONObject res = new JSONObject();
                res.put("targetName", (Object)auth.getTargetName());
                res.put("orgName", (Object)auth.getOrgName());
                res.put("corpName", (Object)auth.getCorpName());
                res.put("id", (Object)auth.getId());
                if (ListUtil.isNotEmpty((List)subEntities)) {
                    res.put("scope", (Object)subEntities.stream().map(WorkAuthSubEntity::getAuthName).collect(Collectors.joining(",")));
                } else {
                    res.put("scope", (Object)"");
                }
                recordList.add(res);
            });
        }
        pageData.setRecords(recordList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAuthAppList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryAuthAppList(@RequestParam String pid, @RequestParam String corpPk, @RequestParam String corpProviderId) {
        QueryParam param = new QueryParam();
        List appEntities = new ArrayList();
        if (InvocationInfoProxy.getUserid() == 372127L) {
            appEntities = this.appService.queryList(param, false);
        } else {
            String userProviderId = this.sessionManager.getUserContext().getProviderId();
            JSONArray positionArrJson = this.ztjApisService.getUserAllPosition(userProviderId, String.valueOf(InvocationInfoProxy.getUserid()));
            JSONObject positionJson = null;
            StringBuffer authIdBuff = new StringBuffer(InvocationInfoProxy.getUserid() + ",");
            for (int i = 0; i < positionArrJson.size(); ++i) {
                positionJson = positionArrJson.getJSONObject(i);
                authIdBuff.append(positionJson.getString("id")).append(",");
            }
            param.getParams().put("targetId", new Parameter("in", (Object)authIdBuff.substring(0, authIdBuff.length() - 1)));
            param.getParams().put("corpPk", new Parameter("eq", (Object)corpPk));
            param.getParams().put("corpProviderId", new Parameter("eq", (Object)corpProviderId));
            ArrayList authEntities = this.service.queryList(param, false);
            if (!"root_org_code".equals(corpProviderId)) {
                param.getParams().put("corpPk", new Parameter("eq", (Object)OrgVO.rootOrgId));
                param.getParams().put("corpProviderId", new Parameter("eq", (Object)"root_org_code"));
                List root = this.service.queryList(param, false);
                if (ListUtil.isEmpty((List)authEntities)) {
                    authEntities = new ArrayList();
                }
                if (ListUtil.isNotEmpty((List)root)) {
                    authEntities.addAll(root);
                }
            }
            if (ListUtil.isNotEmpty((List)authEntities)) {
                param = new QueryParam();
                param.getParams().put("pid", new Parameter("in", authEntities.stream().map(BaseEntity::getId).collect(Collectors.toList())));
                List subs = this.subService.queryList(param, false);
                if (ListUtil.isNotEmpty((List)subs)) {
                    param = new QueryParam();
                    param.getParams().put("id", new Parameter("in", subs.stream().map(WorkAuthSubEntity::getAuthId).collect(Collectors.toList())));
                    appEntities = this.appService.queryList(param, false);
                }
            }
        }
        param = new QueryParam();
        param.getParams().put("pid", new Parameter("eq", (Object)pid));
        List subEntities = this.subService.queryList(param, false);
        ArrayList res = new ArrayList();
        appEntities.forEach(app -> {
            JSONObject object = new JSONObject();
            object.put("id", (Object)app.getId());
            object.put("name", (Object)app.getName());
            object.put("pid", (Object)pid);
            if (ListUtil.isNotEmpty((List)subEntities)) {
                subEntities.forEach(s -> {
                    if (s.getAuthId().equals(app.getId())) {
                        object.put("auth", (Object)true);
                        object.put("authSubId", (Object)s.getId());
                    }
                });
                if (object.get((Object)"authSubId") == null) {
                    object.put("auth", (Object)false);
                    object.put("authSubId", null);
                }
            } else {
                object.put("auth", (Object)false);
                object.put("authSubId", null);
            }
            res.add(object);
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", res);
    }

    @RequestMapping(value={"/updateAuthPositionChange"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateAuthPositionChange() {
        QueryParam param = new QueryParam();
        param.getParams().put("targetType", new Parameter("eq", (Object)1));
        List entities = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)entities)) {
            entities.forEach(e -> {
                JSONObject position = this.ztjApisService.getUserMainPosition(e.getProviderId(), e.getTargetId());
                if (!Objects.equals(position.getString("id"), e.getOrgId())) {
                    PositionChangeEntity changeEntity = new PositionChangeEntity();
                    changeEntity.setCorpName(e.getCorpName());
                    changeEntity.setCorpPk(e.getCorpPk());
                    changeEntity.setCorpProviderId(e.getCorpProviderId());
                    changeEntity.setTargetId(e.getTargetId());
                    changeEntity.setNewPositionName(position.getString("name"));
                    JSONObject p = this.ztjApisService.getPosition(e.getProviderId(), e.getOrgId());
                    changeEntity.setOldPositionName(p.getString("name"));
                    this.positionChangeService.saveOrUpdate((Object)changeEntity, false);
                    e.setOrgId(position.getString("id"));
                    this.service.saveOrUpdate(e, false);
                }
            });
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/queryAuthPositionChangeList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PositionChangeVO>> queryAuthPositionChangeList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.positionChangeService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), PositionChangeVO.class);
        if (ListUtil.isNotEmpty((List)page.getRecords())) {
            List pageRecords = page.getRecords();
            int pageRecordsSize = pageRecords.size();
            for (int i = 0; i < pageRecordsSize; ++i) {
                PositionChangeEntity e = (PositionChangeEntity)((Object)pageRecords.get(i));
                PositionChangeVO change = (PositionChangeVO)records.get(i);
                JSONObject user = this.ztjApisService.getUser(e.getTargetProviderId(), e.getTargetId());
                change.setTargetName(user.getString("name"));
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

