/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.poc.bean.LogEntity;
import com.ejianc.poc.bean.LogParam;
import com.ejianc.poc.mapper.LogMapper;
import com.ejianc.poc.service.ILogService;
import com.ejianc.poc.service.impl.ZtjApisService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="logService")
public class LogServiceImpl
extends BaseServiceImpl<LogMapper, LogEntity>
implements ILogService {
    @Autowired
    private ZtjApisService ztjApisService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private LogMapper logMapper;

    @Override
    public void loginSuccessLog(String userId, String userName, String providerId) {
        LogEntity logEntity = this.gewLogEntity(userId, userName, providerId);
        logEntity.setMemo("\u767b\u5f55\u6210\u529f\uff01");
        this.saveOrUpdate((Object)logEntity, false);
    }

    @Override
    public void optLog(LogParam param) {
        UserContext context = this.sessionManager.getUserContext();
        String userId = String.valueOf(context.getUserId());
        String userName = context.getUserName();
        String providerId = context.getProviderId();
        LogEntity logEntity = this.gewLogEntity(userId, userName, providerId);
        logEntity.setLogOrgCode(param.getWhichNodeOrgCode());
        StringBuilder whichNode = new StringBuilder("\u5728");
        StringBuilder doWhat = new StringBuilder("");
        whichNode.append(this.ztjApisService.getOrgPath(param.getWhichNodeProviderId(), param.getWhichNodeOrgId(), true));
        String authObjectName = null;
        if ("1".equals(param.getAuthObjectType())) {
            JSONObject user = this.ztjApisService.getUser(param.getAuthObjectProviderId(), param.getAuthObjectId());
            authObjectName = this.ztjApisService.getOrgPath(param.getAuthObjectProviderId(), param.getAuthOrgId(), true);
            authObjectName = authObjectName + " ";
            authObjectName = authObjectName + user.getString("name");
        } else {
            authObjectName = this.ztjApisService.getOrgPath(param.getAuthObjectProviderId(), param.getAuthObjectId(), true);
        }
        switch (param.getOptType()) {
            case APP_AUTH_ADD: {
                doWhat.append("\u4e3a\u6388\u6743\u5bf9\u8c61:").append(param.getAuthObjectName()).append(LogParam.OptTypeEnum.APP_AUTH_ADD.getDescription()).append("\u5e94\u7528:").append(param.getAuthAppName());
                break;
            }
            case APP_AUTH_DEL: {
                doWhat.append(LogParam.OptTypeEnum.APP_AUTH_DEL.getDescription()).append("\u5bf9\u8c61:").append(param.getAuthObjectName()).append("\u7684\u6388\u6743\u5e94\u7528:").append(param.getAuthAppName());
                break;
            }
            case AUTH_OBJECT_ADD: {
                doWhat.append(LogParam.OptTypeEnum.AUTH_OBJECT_ADD.getDescription()).append(":").append(authObjectName);
                break;
            }
            case AUTH_OBJECT_DEL: {
                doWhat.append(LogParam.OptTypeEnum.AUTH_OBJECT_DEL.getDescription()).append(":").append(authObjectName);
            }
        }
        logEntity.setMemo(whichNode.append((CharSequence)doWhat).toString());
        this.saveOrUpdate((Object)logEntity, false);
    }

    @Override
    public IPage<LogEntity> queryPageSql(String sql, Integer pageNumber, Integer pageSize) {
        Integer total = this.logMapper.queryPageCount(" select count(a.*) from ( " + sql + " ) a ");
        Integer pageIndex = (pageNumber - 1) * pageSize;
        List<LogEntity> list = this.logMapper.queryPageSql(" select a.* from ( " + sql + " ) a order by a.create_time desc limit " + pageIndex + "," + pageSize);
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), (long)total.intValue());
        page.setRecords(list);
        return page;
    }

    private LogEntity gewLogEntity(String userId, String userName, String providerId) {
        JSONObject position = this.ztjApisService.getUserMainPosition(providerId, userId);
        JSONArray array = this.ztjApisService.getOrgPath(providerId, position.getString("id"));
        StringBuilder org = new StringBuilder("");
        StringBuilder dept = new StringBuilder("");
        StringBuilder post = new StringBuilder("");
        for (int i = array.size() - 1; i > -1; --i) {
            JSONObject p = array.getJSONObject(i);
            if (p.get((Object)"virtual") != null && p.getBoolean("virtual").booleanValue()) continue;
            if (p.getInteger("type") == 1) {
                org.append(p.getString("name")).append(" ");
            }
            if (p.getInteger("type") == 2) {
                dept.append(p.getString("name")).append(" ");
            }
            if (p.getInteger("type") != 3) continue;
            post.append(p.getString("name")).append(" ");
        }
        LogEntity logEntity = new LogEntity();
        logEntity.setOpUserId(userId);
        logEntity.setOpUserName(userName);
        logEntity.setOpUserPost(post.toString());
        logEntity.setOpUserDept(dept.toString());
        logEntity.setOpUserOrg(org.toString());
        logEntity.setLogOrgCode(position.getString("code"));
        return logEntity;
    }
}

