package com.ejianc.poc.bean;


import java.io.Serializable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LogParam  implements Serializable {

    private String whichNodeOrgId;/** 授权节点组织id */
    private String whichNodeProviderId;/** 授权节点ProviderId */
    private String whichNodeOrgCode;/** 授权节点组织Code */
    private OptTypeEnum optType ;/** 操作类型 */
    private String authObjectType;/** 授权对象类型 */
    private String authObjectId;/** 授权对象id */
    private String authOrgId;/** 授权对象岗位id */
    private String authObjectName;/** 授权对象名称 */
    private String authObjectProviderId;/** 授权对象ProviderId */
    private String authAppId;/** 授权应用Id */
    private String authAppName;/** 授权应用名称 */

    public enum OptTypeEnum {
        /**
         * 操作类型
         * */
        AUTH_OBJECT_ADD("AUTH_OBJECT_ADD", "新增授权对象"),
        AUTH_OBJECT_DEL("AUTH_OBJECT_DEL", "删除授权对象"),
        APP_AUTH_ADD("APP_AUTH_ADD", "新增授权"),
        APP_AUTH_DEL("APP_AUTH_DEL", "删除授权");

        private final String optTypeCode;
        private final String description;

        private static Map<String, OptTypeEnum> enumMap;

        OptTypeEnum(String optTypeCode, String description) {
            this.optTypeCode = optTypeCode;
            this.description = description;
        }

        public String getOptTypeCode() {
            return optTypeCode;
        }
        public String getDescription() {
            return description;
        }

        static {
            enumMap = EnumSet.allOf(OptTypeEnum.class).stream().collect(Collectors.toMap(OptTypeEnum::getOptTypeCode, Function.identity(), (k1, k2) -> k2));
        }

        public static OptTypeEnum getOptTypeEnumByCode(String optTypeCode) {
            return enumMap.get(optTypeCode);
        }
    }

    public String getWhichNodeOrgId() {
        return whichNodeOrgId;
    }

    public void setWhichNodeOrgId(String whichNodeOrgId) {
        this.whichNodeOrgId = whichNodeOrgId;
    }

    public String getWhichNodeProviderId() {
        return whichNodeProviderId;
    }

    public void setWhichNodeProviderId(String whichNodeProviderId) {
        this.whichNodeProviderId = whichNodeProviderId;
    }

    public String getWhichNodeOrgCode() {
        return whichNodeOrgCode;
    }

    public void setWhichNodeOrgCode(String whichNodeOrgCode) {
        this.whichNodeOrgCode = whichNodeOrgCode;
    }

    public OptTypeEnum getOptType() {
        return optType;
    }

    public void setOptType(OptTypeEnum optType) {
        this.optType = optType;
    }

    public String getAuthObjectType() {
        return authObjectType;
    }

    public void setAuthObjectType(String authObjectType) {
        this.authObjectType = authObjectType;
    }

    public String getAuthObjectId() {
        return authObjectId;
    }

    public void setAuthObjectId(String authObjectId) {
        this.authObjectId = authObjectId;
    }

    public String getAuthOrgId() {
        return authOrgId;
    }

    public void setAuthOrgId(String authOrgId) {
        this.authOrgId = authOrgId;
    }

    public String getAuthObjectName() {
        return authObjectName;
    }

    public void setAuthObjectName(String authObjectName) {
        this.authObjectName = authObjectName;
    }

    public String getAuthObjectProviderId() {
        return authObjectProviderId;
    }

    public void setAuthObjectProviderId(String authObjectProviderId) {
        this.authObjectProviderId = authObjectProviderId;
    }

    public String getAuthAppId() {
        return authAppId;
    }

    public void setAuthAppId(String authAppId) {
        this.authAppId = authAppId;
    }

    public String getAuthAppName() {
        return authAppName;
    }

    public void setAuthAppName(String authAppName) {
        this.authAppName = authAppName;
    }
}
