/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.cache.serializer.Serializer;
import com.ejianc.framework.cache.serializer.impl.DefaultJDKSerializer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.OrgVO;
import com.ejianc.poc.vo.UserVO;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/employee/"})
public class EmployeeManageController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ZtjApisService ztjApisService;
    @Autowired
    private CacheManager cacheManager;
    private final String userCachePrefix = "orgUserList::";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final String ORG_LIST_KEY = "org_list_key";
    private Serializer serializer = new DefaultJDKSerializer();

    @GetMapping(value={"pageList"})
    public CommonResponse<IPage<UserVO>> pageList(@RequestParam(value="pageSize") int pageSize, @RequestParam(value="pageNumber") int pageNumber, @RequestParam(value="providerId", required=false) String providerId, @RequestParam(value="orgId") String orgId, @RequestParam(value="deptId", required=false) String deptId) {
        this.logger.info("\u5206\u9875\u67e5\u8be2\u4eba\u5458\u5217\u8868-\u53c2\u6570\uff1apageSize-{}\uff0cpageNumber-{}\uff0cproviderId-{}\uff0corgId-{}\uff0cdeptId-{}", new Object[]{pageSize, pageNumber, providerId, orgId, deptId});
        long start = System.currentTimeMillis();
        String allOrgUsers = null;
        Page pageUser = new Page();
        pageNumber = pageNumber - 1 <= 0 ? 1 : pageNumber;
        int from = (pageNumber - 1) * pageSize;
        int to = pageNumber * pageSize;
        boolean size = false;
        ArrayList<UserVO> users = new ArrayList<UserVO>();
        Object tmpUserList = null;
        JSONArray userOrgArr = null;
        String orgName = null;
        Object deptName = null;
        pageUser.setSize((long)pageSize);
        pageUser.setCurrent((long)pageNumber);
        pageUser.setRecords(new ArrayList());
        if (OrgVO.rootOrgId.toString().equals(orgId)) {
            JSONArray jsonArray = this.ztjApisService.getAllSecondOrgList();
            JSONObject objJson = null;
            JSONObject orgJson = null;
            for (Object obj : jsonArray) {
                objJson = JSONObject.parseObject((String)JSONObject.toJSONString(obj));
                orgJson = objJson.getJSONObject("root");
                allOrgUsers = this.ztjApisService.queryAllTreeOrgAndUsers(objJson.getString("id"), orgJson.getString("id"));
                if (!StringUtils.isNotBlank((CharSequence)allOrgUsers)) continue;
                orgJson = JSONObject.parseObject((String)allOrgUsers);
                userOrgArr = orgJson.getJSONArray("children");
                orgName = orgJson.getString("name");
                if (null == userOrgArr) continue;
                if (pageUser.getSize() <= (long)pageUser.getRecords().size()) {
                    this.countUser(userOrgArr, (IPage)pageUser);
                    continue;
                }
                users.addAll(this.parseOrgUseJsonList((List<Object>)userOrgArr, null, orgName, null, (IPage)pageUser, "-99999", null));
            }
            this.logger.info("\u67e5\u8be2\u6240\u6709\u7684\u4eba\u5458\u5217\u8868\u7ed3\u679c\uff1a{}", (Object)pageUser.getRecords());
        } else {
            allOrgUsers = this.ztjApisService.queryAllTreeOrgAndUsers(providerId, orgId);
            String lastNotVirtualPid = null;
            orgName = "";
            JSONObject orgJson = null;
            ArrayList<String> treeIdList = new ArrayList<String>();
            JSONArray orgPathJsonArr = this.ztjApisService.getOrgPath(providerId, orgId);
            if (orgPathJsonArr.size() > 0) {
                JSONObject tmpOrg = null;
                for (Object obj : orgPathJsonArr) {
                    tmpOrg = (JSONObject)obj;
                    if ("1".equals(tmpOrg.getString("type")) && !tmpOrg.getBoolean("virtual").booleanValue()) {
                        orgName = tmpOrg.getString("name") + orgName;
                        if (null == lastNotVirtualPid) {
                            lastNotVirtualPid = tmpOrg.getString("id");
                        }
                    }
                    treeIdList.add(tmpOrg.getString("id"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)deptId)) {
                treeIdList.add(deptId);
            }
            if (StringUtils.isNotBlank((CharSequence)allOrgUsers) && null != (userOrgArr = (orgJson = JSONObject.parseObject((String)allOrgUsers)).getJSONArray("children"))) {
                users.addAll(this.parseOrgUseJsonList((List<Object>)userOrgArr, deptId, orgName, null, (IPage)pageUser, providerId, treeIdList));
            }
            this.logger.info("\u67e5\u8be2\u6307\u5b9a\u7ec4\u7ec7\u7684\u7684\u4eba\u5458\u5217\u8868\u7ed3\u679c\uff1a{}", (Object)pageUser.getRecords());
        }
        long end = System.currentTimeMillis();
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u4eba\u5458\u5217\u8868\u8017\u65f6\uff1a-{}\u6beb\u79d2", (Object)(end - start));
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01", (Object)pageUser);
    }

    private void cacheOrgUserInfo(JSONArray jsonArray, String cacheKey) {
        this.cacheManager.removeCache(cacheKey);
        if (jsonArray != null && jsonArray.size() > 0) {
            this.cacheManager.piplineExecute(pipeline -> {
                pipeline.multi();
                String key = cacheKey;
                byte[] keyBytes = ORG_LIST_KEY.getBytes(Charset.forName(DEFAULT_CHARSET));
                byte[] fieldBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
                for (Object orgObj : jsonArray) {
                    byte[] contentBytes = this.serializer.marshalToByte((Serializable)((Object)JSON.toJSONString(orgObj)));
                    pipeline.hset(keyBytes, fieldBytes, contentBytes);
                }
                pipeline.exec();
            });
        }
    }

    public JSONArray getOrgUserInfoCache(String cacheKey) {
        JSONArray resp = new JSONArray();
        String content = (String)((Object)this.cacheManager.hget(ORG_LIST_KEY, cacheKey));
        resp.add((Object)JSON.parseObject((String)content));
        return resp;
    }

    private void countUser(JSONArray orgUserArr, IPage page) {
        String orgType = null;
        Object oneOrgUserList = null;
        JSONObject json = null;
        block9: for (Object obj : orgUserArr) {
            json = (JSONObject)obj;
            switch (orgType = json.get((Object)"type").toString()) {
                case "1": 
                case "2": {
                    if (null == json.get((Object)"children")) continue block9;
                    this.countUser(json.getJSONArray("children"), page);
                    continue block9;
                }
                case "3": {
                    if (null == json.get((Object)"users")) continue block9;
                    page.setTotal(page.getTotal() + (long)json.getJSONArray("users").size());
                    continue block9;
                }
            }
        }
    }

    private List<UserVO> parseOrgUseJsonList(List<Object> orgUserArr, String deptId, String orgName, String deptName, IPage page, String providerId, List<String> treeIds) {
        ArrayList<UserVO> userList = new ArrayList<UserVO>();
        List<UserVO> tmpList = null;
        long takeNum = 0L;
        String orgType = null;
        JSONArray jsonArr = null;
        JSONObject org = null;
        boolean isVirtual = false;
        block10: for (Object obj : orgUserArr) {
            org = (JSONObject)obj;
            orgType = org.getString("type");
            boolean bl = isVirtual = null != org.get((Object)"virtual") ? org.getBoolean("virtual") : true;
            if (StringUtils.isNotBlank((CharSequence)deptId) && !treeIds.contains(org.getString("id"))) continue;
            switch (orgType) {
                case "1": {
                    jsonArr = org.getJSONArray("children");
                    if (null == jsonArr || (tmpList = this.parseOrgUseJsonList((List<Object>)jsonArr, deptId, isVirtual ? orgName : orgName + org.getString("name"), deptName, page, providerId, treeIds)).size() <= 0) continue block10;
                    takeNum += (long)tmpList.size();
                    userList.addAll(tmpList);
                    continue block10;
                }
                case "2": {
                    jsonArr = org.getJSONArray("children");
                    if (null == jsonArr || (tmpList = this.parseOrgUseJsonList((List<Object>)jsonArr, org.getString("id").equals(deptId) ? null : deptId, orgName, StringUtils.isNotBlank((CharSequence)deptName) ? deptName + org.getString("name") : org.getString("name"), page, providerId, treeIds)).size() <= 0) continue block10;
                    userList.addAll(tmpList);
                    takeNum += (long)tmpList.size();
                    continue block10;
                }
                case "3": {
                    long start = (page.getCurrent() - 1L) * page.getSize();
                    long limit = page.getSize() - (long)(null != page.getRecords() ? page.getRecords().size() : 0);
                    start = start > page.getTotal() ? start - page.getTotal() : 0L;
                    long to = start + limit;
                    jsonArr = org.getJSONArray("users");
                    if (null == jsonArr) continue block10;
                    page.setTotal(page.getTotal() + (long)jsonArr.size());
                    if ((long)jsonArr.size() < start || limit <= 0L) continue block10;
                    tmpList = this.pageUsers(jsonArr.subList(Integer.valueOf(start + "").intValue(), to > (long)jsonArr.size() ? jsonArr.size() : Integer.valueOf(to + "").intValue()), providerId, org.getInteger("order"), orgName, deptName, org.getString("name"));
                    page.getRecords().addAll(tmpList);
                    takeNum += (long)tmpList.size();
                    continue block10;
                }
            }
        }
        return userList;
    }

    private List<UserVO> pageUsers(List<Object> userJsonArr, String curProviderId, int postOrder, String orgName, String deptName, String postName) {
        ArrayList<UserVO> resp = new ArrayList<UserVO>();
        JSONObject userJson = null;
        for (Object obj : userJsonArr) {
            userJson = (JSONObject)obj;
            UserVO tmp = new UserVO();
            tmp.setType(Integer.valueOf(4));
            tmp.setName(null != userJson.get((Object)"name") ? userJson.get((Object)"name").toString() : null);
            tmp.setOrder(Integer.valueOf(null != userJson.get((Object)"order") ? Integer.valueOf(userJson.get((Object)"order").toString()) : 9999));
            tmp.setGender(Integer.valueOf(null != userJson.get((Object)"gender") ? Integer.valueOf(userJson.get((Object)"gender").toString()) : 1));
            tmp.setCategory(Integer.valueOf(null != userJson.get((Object)"category") ? Integer.valueOf(userJson.get((Object)"category").toString()) : 101301));
            tmp.setPositionStatus(Integer.valueOf(null != userJson.get((Object)"positionStatus") ? Integer.valueOf(userJson.get((Object)"positionStatus").toString()) : 101401));
            tmp.setProviderId(curProviderId);
            tmp.setPostOrder(Integer.valueOf(postOrder));
            tmp.setId(Long.valueOf(userJson.get((Object)"id").toString()));
            tmp.setMainPosition(Boolean.valueOf(null != userJson.get((Object)"mainPosition") ? Boolean.valueOf(userJson.get((Object)"mainPosition").toString()) : false));
            tmp.setUniqSymbol(UUID.randomUUID().toString().replace("-", ""));
            tmp.setChildren(null);
            tmp.setDeptName(deptName);
            tmp.setOrgName(orgName);
            tmp.setPostName(postName);
            resp.add(tmp);
        }
        return resp;
    }
}

