package com.ejianc.poc.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.util.Date;

/**
 * 授权组织变化、授权人岗位变化记录
 *
 * @author CJ
 * @Description:
 * @date 2021/4/20 17:24
 */
@TableName(value = "ejc_ztjpoc_auth_change_record")
public class AuthChangeRecordEntity extends BaseEntity {

    private static final long serialVersionUID = -955884858096381740L;
    /**
     * 被授权人Id,多个空格分隔
     */
    @TableField(value = "user_id")
    private String userId;

    /**
     * 被授权岗位ID ，多个空格分隔
     */
    @TableField(value = "post_id")
    private String postId;

    /**
     * 原被授权对象岗位路径
     */
    @TableField(value = "original_post_name_path")
    private String originalPostNamePath;

    /**
     * 原被授权对象组织路径
     */
    @TableField(value = "original_org_name_path")
    private String originalOrgNamePath;

    /**
     * 原被授权组织Id
     */
    @TableField(value = "original_org_id")
    private String orignalOrgId;

    /**
     * 原被授权对象岗位ID
     */
    @TableField(value = "original_post_id")
    private String orignalPostId;

    /**
     * 当前授权组织Id
     */
    @TableField(value = "cur_org_id")
    private String curOrgId;

    /**
     * 当前授权对象岗位Id
     */
    @TableField(value = "cur_post_id")
    private String curPostId;

    /**
     * 当前授权组织路径
     */
    @TableField(value = "cur_org_name_path")
    private String curOrgNamePath;

    /**
     * 当前授权人岗位路径
     */
    @TableField(value = "cur_post_name_path")
    private String curPostNamePath;

    /**
     * 记录类型：1-授权组织删除，2-授权对象岗位变化
     */
    @TableField(value = "type")
    private String type;

    /**
     * 授权对象所属二级集团Id
     */
    @TableField(value = "provider_id")
    private String providerId;

    /**
     * 变动时间
     */
    @TableField(value = "change_time")
    private Date changeTime;

    /**
     * 被授权对象名称，多个空格分隔
     */
    @TableField(value = "target_name")
    private String targetName;

    /**
     * 记录所属组织Id
     */
    @TableField(value = "org_id")
    private String orgId;

    /**
     * 记录所属组织编码
     */
    @TableField(value = "org_code")
    private String orgCode;

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPostId() {
        return postId;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public String getTargetName() {
        return targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getOriginalPostNamePath() {
        return originalPostNamePath;
    }

    public void setOriginalPostNamePath(String originalPostNamePath) {
        this.originalPostNamePath = originalPostNamePath;
    }

    public String getOriginalOrgNamePath() {
        return originalOrgNamePath;
    }

    public void setOriginalOrgNamePath(String originalOrgNamePath) {
        this.originalOrgNamePath = originalOrgNamePath;
    }

    public String getOrignalOrgId() {
        return orignalOrgId;
    }

    public void setOrignalOrgId(String orignalOrgId) {
        this.orignalOrgId = orignalOrgId;
    }

    public String getOrignalPostId() {
        return orignalPostId;
    }

    public void setOrignalPostId(String orignalPostId) {
        this.orignalPostId = orignalPostId;
    }

    public String getCurOrgId() {
        return curOrgId;
    }

    public void setCurOrgId(String curOrgId) {
        this.curOrgId = curOrgId;
    }

    public String getCurPostId() {
        return curPostId;
    }

    public void setCurPostId(String curPostId) {
        this.curPostId = curPostId;
    }

    public String getCurOrgNamePath() {
        return curOrgNamePath;
    }

    public void setCurOrgNamePath(String curOrgNamePath) {
        this.curOrgNamePath = curOrgNamePath;
    }

    public String getCurPostNamePath() {
        return curPostNamePath;
    }

    public void setCurPostNamePath(String curPostNamePath) {
        this.curPostNamePath = curPostNamePath;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getProviderId() {
        return providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }
}
