package com.ejianc.poc.controller;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.poc.bean.LogEntity;
import com.ejianc.poc.service.ILogService;

/**
 * 系统日志
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("log")
public class LogController implements Serializable {
	private static final long serialVersionUID = 1L;
	private static final String logId = "436575179625463852";

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ILogService service;

	@Autowired
	private ZtjApisService ztjApisService;

	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<LogVO> saveOrUpdate(@RequestBody LogVO saveorUpdateVO) {
		LogEntity entity = BeanMapper.map(saveorUpdateVO, LogEntity.class);
		service.saveOrUpdate(entity, false);
		LogVO vo = BeanMapper.map(entity, LogVO.class);
		return CommonResponse.success("保存或修改单据成功！", vo);
	}

	/**
	 * @Description queryDetail 查询详情
	 * @param id
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<LogVO> queryDetail(Long id) {
		LogEntity entity = service.selectById(id);
		LogVO vo = BeanMapper.map(entity, LogVO.class);
		return CommonResponse.success("查询详情数据成功！", vo);
	}

	/**
	 * @Description delete 批量删除单据
	 * @Param [ids]
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<LogVO> vos) {
		service.removeByIds(vos.stream().map(LogVO::getId).collect(Collectors.toList()), true);
		return CommonResponse.success("删除成功！");
	}

	/**
	 * @Description queryList 查询列表
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse
	 *         <java.lang.String>
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<LogVO>> queryList(@RequestBody QueryParam param) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		List<BaseFieldVO> tree = ztjApisService.getTreeRootByAppId(logId,4);
		if(ListUtil.isEmpty(tree)){
			return CommonResponse.success("查询列表数据成功！");
		}
		IPage<LogEntity> page = null;
		if(tree.size() == 1){
			BaseFieldVO baseFieldVO = tree.get(0);
			if(baseFieldVO instanceof OrgVO){
				OrgVO orgVO = (OrgVO)baseFieldVO;
				if(!OrgVO.rootOrgCode.equals(orgVO.getCode())){
					param.getParams().put("logOrgCode",new Parameter(QueryParam.LIKE_LEFT,orgVO.getCode()));
				}
			}else if(baseFieldVO instanceof PostVO){
				PostVO orgVO = (PostVO)baseFieldVO;
				param.getParams().put("logOrgCode",new Parameter(QueryParam.LIKE_LEFT,orgVO.getCode()));
			}else if(baseFieldVO instanceof DeptVO){
				DeptVO orgVO = (DeptVO)baseFieldVO;
				param.getParams().put("logOrgCode",new Parameter(QueryParam.LIKE_LEFT,orgVO.getCode()));
			}
			param.getOrderMap().put("createTime", QueryParam.DESC);
			page = service.queryPage(param, false);
		}else {
			page = service.queryPageSql(getSql(tree,param.getParams()),param.getPageIndex(),param.getPageSize());
		}
		IPage<LogVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), LogVO.class));
		return CommonResponse.success("查询列表数据成功！", pageData);
	}
	private String getSql(List<BaseFieldVO> tree, Map<String, Parameter> param){
		StringBuilder sb = new StringBuilder(" ");
		for (int i = 0; i < tree.size(); i++) {
			sb.append(" select * from ejc_ztjpoc_sys_log ").append("l").append(i).append(" where l").append(i).append(".dr = 0");
			BaseFieldVO baseFieldVO = tree.get(i);
			if(baseFieldVO instanceof OrgVO){
				OrgVO orgVO = (OrgVO)baseFieldVO;
				sb.append(" and  l").append(i).append(".log_org_code like '").append(orgVO.getCode()).append("%' ");
			}else if(baseFieldVO instanceof PostVO){
				PostVO orgVO = (PostVO)baseFieldVO;
				sb.append(" and  l").append(i).append(".log_org_code like '").append(orgVO.getCode()).append("%' ");
			}else if(baseFieldVO instanceof DeptVO){
				DeptVO orgVO = (DeptVO)baseFieldVO;
				sb.append(" and  l").append(i).append(".log_org_code like '").append(orgVO.getCode()).append("%' ");
			}
			for(Map.Entry<String, Parameter> entry: param.entrySet()){
				Parameter parameter = entry.getValue();
				if(parameter.getValue() != null && StringUtils.isNotBlank(parameter.getValue().toString())) {
					sb.append(" and l").append(i).append(".").append(CamelAndUnderLineConverter.humpToLine(entry.getKey())).
							append(" like '%").append(parameter.getValue()).append("%'");
				}
			}
			if(i<tree.size()-1){
				sb.append(" union ");
			}
		}
		return sb.toString();
	}
}
