package com.ejianc.poc.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.poc.bean.ZtjAppEntity;
import com.ejianc.poc.mapper.ZtjAppMapper;
import com.ejianc.poc.service.IZtjAppService;
import com.ejianc.poc.utils.MenuAsTree;
import com.ejianc.poc.vo.ZtjAppVO;
import com.ejianc.support.idworker.util.IdWorker;

/**
 * 中铁建应用表
 * 
 * @author generator
 * 
 */
@Service("ztjAppService")
public class ZtjAppServiceImpl extends BaseServiceImpl<ZtjAppMapper, ZtjAppEntity> implements IZtjAppService{
	
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private ZtjAppMapper ztjAppMapper;

	@Override
	public List<ZtjAppVO> queryMenuListByCurrentUser() {
		List<ZtjAppVO> ztjAppVos = new ArrayList<ZtjAppVO>();
		
		UserContext userContext = sessionManager.getUserContext();
		JSONObject jsonObject = userContext.getUserAuthJson();
		boolean flag = true;
		Long parentId = null;
		String appIds = "";
		for(Map.Entry<String, Object> entry:jsonObject.entrySet()) {
			String appId = entry.getKey();
			appIds += appId+",";
		}
		
		if(StringUtils.isNotBlank(appIds)) {
			
			List<ZtjAppEntity> appEntities = ztjAppMapper.queryAppListByIds(appIds.substring(0, appIds.length()-1));
			for(ZtjAppEntity appEntity:appEntities) {
				if("1221".equals(appEntity.getCode())) {
					ZtjAppVO parentVO = new ZtjAppVO();
					parentVO.setId(IdWorker.getId());
					parentVO.setIcon("icon-renzheng");
					parentVO.setCode("0001");
					parentVO.setName("人员管理");
					parentVO.setSequence(1);
					ztjAppVos.add(parentVO);
					
					ZtjAppVO empAppVo = BeanMapper.map(appEntity, ZtjAppVO.class);
					empAppVo.setParentId(parentVO.getId());
					ztjAppVos.add(empAppVo);
				}
				if("1220".equals(appEntity.getCode()) || "1222".equals(appEntity.getCode()) || "1223".equals(appEntity.getCode())) {
					if(flag) {
						parentId = IdWorker.getId();
						flag = false;
						
						ZtjAppVO parentVO = new ZtjAppVO();
						parentVO.setId(parentId);
						parentVO.setIcon("icon-fuwuxiangmu");
						parentVO.setCode("0002");
						parentVO.setName("系统管理");
						parentVO.setSequence(2);
						ztjAppVos.add(parentVO);
					}
					
					ZtjAppVO appVo = BeanMapper.map(appEntity, ZtjAppVO.class);
					appVo.setParentId(parentId);
					ztjAppVos.add(appVo);
				}
			}
		}
		return MenuAsTree.createTreeData(ztjAppVos);
	}
    
}
