package com.ejianc.poc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.poc.bean.AuthChangeRecordEntity;
import com.ejianc.poc.bean.UserAuthParam;
import com.ejianc.poc.bean.WorkAuthEntity;
import com.ejianc.poc.bean.ZtjAppEntity;
import com.ejianc.poc.mapper.ZtjAppMapper;
import com.ejianc.poc.service.IAuthChangeRecordService;
import com.ejianc.poc.service.IWorkAuthService;
import com.ejianc.poc.service.IWorkAuthSubService;
import com.ejianc.poc.utils.MenuAsTree;
import com.ejianc.poc.vo.AuthChangeRecordVO;
import com.ejianc.poc.vo.ZtjAppVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/4/20 16:04
 */
@RestController
@RequestMapping(value = "/report/")
public class ReportController {

    @Autowired
    private IWorkAuthService workAuthService;

    @Autowired
    private IAuthChangeRecordService authChangeRecordService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ZtjAppMapper ztjAppMapper;
    @Autowired
    private IWorkAuthSubService workAuthSubService;


    /**
     * 刷新当前授权组织、岗位信息，若组织、岗位信息发生变化则生成对应的记录入库
     * @return
     */
    @GetMapping(value = "refreshDelAuthOrgInfo")
    @Scheduled(cron = "0/15 * * * * ? ") // 间隔15秒执行
    public CommonResponse<JSONObject> refreshAuthedOrgInfo() {
        //查询当前工作授权中所有涉及到的组织信息
        List<WorkAuthEntity> authOrgList = workAuthService.queryAllAuthOrgList(null, null);
        authChangeRecordService.checkOrgList(authOrgList);

        return CommonResponse.success("刷新当前授权组织、岗位信息成功！");
    }

    @GetMapping(value = "pageList")
    public CommonResponse<JSONObject> pageList(@RequestParam(value = "orgId") String orgId,
                                               @RequestParam(value = "providerId") String providerId,
                                               @RequestParam(value = "pageSize") int pageSize,
                                               @RequestParam(value = "pageNumber") int pageNumber,
                                               @RequestParam(value = "recordType") int recordType) {
        JSONObject resp = new JSONObject();
        List<WorkAuthEntity> authOrgList = workAuthService.queryAllAuthOrgList(null, null);
        boolean result = authChangeRecordService.checkOrgList(authOrgList);

        if(!result) {
            resp.put("reloadPage", false);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            queryParam.getParams().put("providerId", new Parameter(QueryParam.EQ, providerId));
            queryParam.getParams().put("type", new Parameter(QueryParam.EQ, recordType));
            queryParam.setPageSize(pageSize);
            queryParam.setPageIndex(pageNumber);
            queryParam.getOrderMap().put("createTime", QueryParam.DESC);
            IPage<AuthChangeRecordEntity> page = authChangeRecordService.queryPage(queryParam);

            resp.put("current", page.getCurrent());
            resp.put("size", page.getSize());
            resp.put("pages", page.getPages());
            resp.put("total", page.getTotal());
            resp.put("records", CollectionUtils.isNotEmpty(page.getRecords()) ? BeanMapper.mapList(page.getRecords(), AuthChangeRecordVO.class) : new ArrayList<>());
        } else {
            resp.put("reloadPage", true);
        }
        return CommonResponse.success("分页查询成功！", resp);
    }

    /**
     * 授权组织删除记录导出
     *
     * @param paramJson
     * @param response
     */
    @PostMapping(value = "authOrgDelRecordsExport")
    public void authOrgDelRecordsExport(@RequestBody JSONObject paramJson, HttpServletResponse response) {
        String orgId = paramJson.getString("orgId");
        String providerId = paramJson.getString("providerId");
        String recordType = paramJson.getString("recordType");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        List<AuthChangeRecordVO> list = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        queryParam.getParams().put("providerId", new Parameter(QueryParam.EQ, providerId));
        queryParam.getParams().put("type", new Parameter(QueryParam.EQ, recordType));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);

        List<AuthChangeRecordEntity> records = authChangeRecordService.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(records)) {
            records.forEach(r -> {
                r.setType(sdf.format(r.getChangeTime()));
            });
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", records);
        ExcelExport.getInstance().export("auth-org-del-record-export.xlsx", beans, response);
    }

    @GetMapping(value = "queryReportMenuListByCurrentUser")
    public CommonResponse<List<ZtjAppVO>> queryReportMenuListByCurrentUser() {
        List<ZtjAppVO> ztjAppVos = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        List<UserAuthParam> userAuthParams = workAuthSubService.queryUserAuthList(userContext.getDeptCode());
        if(ListUtil.isEmpty(userAuthParams)){
            return CommonResponse.error("");
        }
        String appIds = "";
        for(UserAuthParam entry:userAuthParams) {
            String appId = entry.getAuthId();
            appIds += appId+",";
        }
        if(StringUtils.isNotBlank(appIds)) {
            List<ZtjAppEntity> appEntities = ztjAppMapper.queryAppListByIds(appIds.substring(0, appIds.length()-1));
            for(ZtjAppEntity appEntity:appEntities) {
                if("1225".equals(appEntity.getCode()) || "1226".equals(appEntity.getCode()) || "1227".equals(appEntity.getCode())) {
                    ZtjAppVO appVo = BeanMapper.map(appEntity, ZtjAppVO.class);
                    ztjAppVos.add(appVo);
                }
            }
        }
        return CommonResponse.success(ztjAppVos);
    }
}
