/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.poc.bean.AuthChangeRecordEntity;
import com.ejianc.poc.bean.WorkAuthEntity;
import com.ejianc.poc.mapper.AuthChangeRecordMapper;
import com.ejianc.poc.service.IAuthChangeRecordService;
import com.ejianc.poc.service.IWorkAuthService;
import com.ejianc.poc.service.IWorkAuthSubService;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.OrgVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="authChangeService")
public class AuthChangeServiceImpl
extends BaseServiceImpl<AuthChangeRecordMapper, AuthChangeRecordEntity>
implements IAuthChangeRecordService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ZtjApisService ztjApisService;
    @Autowired
    private IWorkAuthService workAuthService;
    @Autowired
    private IWorkAuthSubService workAuthSubService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean checkOrgList(List<WorkAuthEntity> authOrgList) {
        HashMap<String, String> namePathCache = new HashMap<String, String>();
        HashSet<String> orgIds = new HashSet<String>();
        HashSet userIds = new HashSet();
        HashMap userMap = new HashMap();
        HashMap postMap = new HashMap();
        HashMap<String, JSONObject> orgMap = new HashMap<String, JSONObject>();
        HashMap recordMap = new HashMap();
        JSONObject tmpOrg = null;
        JSONObject tmpPost = null;
        String uniqOrg = null;
        String uniqTarget = null;
        JSONObject tmpTarget = null;
        AuthChangeRecordEntity tmpRecord = null;
        ArrayList<AuthChangeRecordEntity> recordList = new ArrayList<AuthChangeRecordEntity>();
        ArrayList<Long> removeAuthId = new ArrayList<Long>();
        for (WorkAuthEntity auth : authOrgList) {
            this.logger.info("\u5f85\u68c0\u6d4b\u6388\u6743\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)auth)));
            tmpOrg = null;
            tmpPost = null;
            if (auth.getCorpPk().equals(OrgVO.rootOrgId.toString())) continue;
            uniqOrg = auth.getCorpProviderId() + auth.getCorpPk();
            uniqTarget = auth.getCorpProviderId() + auth.getTargetId();
            if (1 == auth.getTargetType()) {
                tmpTarget = (JSONObject)userMap.get(uniqTarget);
                if (null == tmpTarget) {
                    tmpTarget = this.ztjApisService.getUser(auth.getCorpProviderId(), auth.getTargetId());
                    tmpPost = this.ztjApisService.getUserMainPosition(auth.getCorpProviderId(), auth.getTargetId());
                    if (null != tmpPost) {
                        tmpTarget.put("mainPostId", (Object)tmpPost.getString("id"));
                    }
                }
            } else {
                tmpTarget = (JSONObject)postMap.get(uniqTarget);
                if (null == tmpTarget) {
                    tmpTarget = this.ztjApisService.getPosition(auth.getCorpProviderId(), auth.getTargetId());
                }
            }
            if (null == tmpTarget) {
                this.logger.error("\u751f\u6210\u6388\u6743\u7ec4\u7ec7\u5220\u9664\u8bb0\u5f55\u5931\u8d25\uff0c\u83b7\u53d6\u6388\u6743\u5bf9\u8c61\u4e3a\u7a7a\uff01");
                continue;
            }
            if (!orgIds.contains(uniqOrg)) {
                tmpOrg = this.ztjApisService.getSureOrg(auth.getCorpProviderId(), auth.getCorpPk());
                if (null != tmpOrg && tmpOrg.size() > 0) {
                    orgMap.put(uniqOrg, tmpOrg);
                    continue;
                }
                tmpRecord = this.generateRecord(auth, tmpTarget, namePathCache, orgMap);
                if (null == tmpRecord) continue;
                recordList.add(tmpRecord);
                orgIds.add(uniqOrg);
                removeAuthId.add(auth.getId());
                continue;
            }
            tmpRecord = this.generateRecord(auth, tmpTarget, namePathCache, orgMap);
            if (null == tmpRecord) continue;
            recordList.add(tmpRecord);
            removeAuthId.add(auth.getId());
        }
        if (CollectionUtils.isNotEmpty(removeAuthId)) {
            this.workAuthService.removeByIds(removeAuthId, false);
            QueryWrapper subDelQuery = new QueryWrapper();
            subDelQuery.in((Object)"pid", removeAuthId);
            this.workAuthSubService.remove((Wrapper)subDelQuery, false);
            super.saveOrUpdateBatch(recordList, recordList.size(), false);
            return true;
        }
        return false;
    }

    private AuthChangeRecordEntity generateRecord(WorkAuthEntity auth, JSONObject target, Map<String, String> namePathCache, Map<String, JSONObject> orgMap) {
        AuthChangeRecordEntity resp = new AuthChangeRecordEntity();
        String namePath = null;
        String uniqPostId = null;
        StringBuilder sp = new StringBuilder();
        Object tmpJson = null;
        resp.setTargetName(target.getString("name"));
        resp.setType("1");
        resp.setProviderId(auth.getCorpProviderId());
        resp.setOrgId(auth.getCorpParentPk());
        JSONObject orgParentJson = orgMap.get(auth.getProviderId() + auth.getCorpParentPk());
        if (orgParentJson == null) {
            orgParentJson = this.ztjApisService.getSureOrg(auth.getProviderId(), auth.getCorpParentPk());
        }
        if (null == orgParentJson || orgParentJson.size() <= 0) {
            this.logger.error("\u751f\u6210\u6388\u6743\u7ec4\u7ec7\u5220\u9664\u8bb0\u5f55\u5931\u8d25\uff0c\u83b7\u53d6\u5220\u9664\u6388\u6743\u7ec4\u7ec7\u7684\u7236\u7ea7\u7ec4\u7ec7\u4e3a\u7a7a\uff01");
            return null;
        }
        resp.setOrgCode(orgParentJson.getString("code"));
        if (1 == auth.getTargetType()) {
            resp.setUserId(auth.getTargetId());
            uniqPostId = auth.getProviderId() + target.getString("mainPostId");
            resp.setOrignalPostId(target.getString("mainPostId"));
        } else {
            resp.setPostId(auth.getTargetId());
            uniqPostId = auth.getProviderId() + auth.getTargetId();
        }
        resp.setChangeTime(new Date());
        resp.setOrignalOrgId(auth.getCorpPk());
        namePath = namePathCache.get(uniqPostId);
        if (null == namePath) {
            sp.delete(0, sp.length());
            this.queryNamePath(auth.getProviderId(), 1 == auth.getTargetType() ? target.getString("mainPostId") : target.getString("id"), namePathCache, sp);
            if (sp.length() > 0) {
                resp.setOriginalPostNamePath(sp.toString());
            }
        } else {
            resp.setOriginalPostNamePath(namePath);
        }
        if (null == (namePath = namePathCache.get(auth.getCorpProviderId() + auth.getCorpPk()))) {
            sp.delete(0, sp.length());
            this.queryNamePath(auth.getProviderId(), auth.getCorpParentPk(), namePathCache, sp);
            if (sp.length() > 0) {
                resp.setOriginalOrgNamePath(sp.toString() + auth.getCorpName());
            }
        } else {
            resp.setOriginalOrgNamePath(namePath);
        }
        return resp;
    }

    private void queryNamePath(String providerId, String orgId, Map<String, String> namePathCache, StringBuilder sp) {
        JSONObject tmpJson = null;
        JSONArray pathArr = this.ztjApisService.getOrgPath(providerId, orgId);
        if (null != pathArr && pathArr.size() > 0) {
            for (int i = pathArr.size() - 1; i >= 0; --i) {
                tmpJson = pathArr.getJSONObject(i);
                sp.append(tmpJson.getString("name"));
                if (namePathCache.containsKey(providerId + tmpJson.get((Object)"id"))) continue;
                namePathCache.put(providerId + tmpJson.get((Object)"id"), sp.toString());
            }
        }
    }
}

