package com.ejianc.poc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.poc.mapper.UserPositionMapper;
import com.ejianc.poc.bean.UserPositionEntity;
import com.ejianc.poc.service.IUserPositionService;

import java.util.List;

/**
 * 授权对象岗位记录
 * 
 * @author generator
 * 
 */
@Service("userPositionService")
public class UserPositionServiceImpl extends BaseServiceImpl<UserPositionMapper, UserPositionEntity> implements IUserPositionService{

    @Autowired
    private ZtjApisService ztjApisService;

    @Override
    public void saveUserPosition(String userId, String providerId) {
        JSONArray pos = ztjApisService.getUserAllPosition(providerId,userId);
        QueryParam param = new QueryParam();
        param.getParams().put("userId",new Parameter(QueryParam.EQ,userId));
        List<UserPositionEntity> dbList = queryList(param);
        if(ListUtil.isEmpty(dbList)){
            for (Object po : pos) {
                JSONObject position = (JSONObject)po;
                UserPositionEntity entity = new UserPositionEntity();
                entity.setUserId(userId);
                entity.setPositionId(position.getString("id"));
                entity.setProviderId(providerId);
                entity.setUserName(ztjApisService.getUser(providerId,userId).getString("name"));
                entity.setPositionName(ztjApisService.getOrgPath(providerId,position.getString("id"),true));
                saveOrUpdate(entity);
            }
        }
    }
}
