package com.ejianc.business.ztpc.billcode.api;

import com.ejianc.business.ztpc.billcode.bean.BillCodeApiVO;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleSNVO;
import com.ejianc.business.ztpc.billcode.hystrix.BillCodeRuleHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Map;

@FeignClient(
        name = "ejc-ztpccom-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-ztpccom-web",
        fallback = BillCodeRuleHystrix.class
)
public interface IBillCodeRuleApi {

    /**
     * 根据项目id+分类id+规则类型确定取号编码规则，这里会实时返回一个编码，必须配合着commitBillCode一起使用
     * 先取号，再交号
     * 取号
     * @param apiVO
     * @return
     */
    @RequestMapping(value = "/api/ztpcBillCode/generateBillCode", method= RequestMethod.POST)
    @ResponseBody
    CommonResponse<BillCodeApiVO> generateBillCode(@RequestBody BillCodeApiVO apiVO);

    /**
     * 确定此号后，将返回的编码提交取号系统确认
     * 先取号，再交号
     * 提号
     * @param apiVO
     * @return
     */
    @RequestMapping(value = "/api/ztpcBillCode/commitBillCode", method= RequestMethod.POST)
    @ResponseBody
    CommonResponse commitBillCode(@RequestBody BillCodeApiVO apiVO);


    /**
     * 还号
     * @param generateBillCode  编号，可传多个值，以List的形式
     * @return
     */
    @RequestMapping(value = "/api/ztpcBillCode/releaseBillCode", method= RequestMethod.POST)
    @ResponseBody
    CommonResponse releaseBillCode(@RequestBody Map<String, Object> generateBillCode);
}
