package com.ejianc.business.ztpc.billcode.bean;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum RuleTypeEnum {
    内部编码("0", "内部编码"),
    外部编码("1", "外部编码");


    private String code;

    private String name;
    private String className;

    private static Map<String, RuleTypeEnum> enumMap = new HashMap();

    private RuleTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }



    public static void setEnumMap(Map<String, RuleTypeEnum> enumMap) {
        RuleTypeEnum.enumMap = enumMap;
    }

    public static RuleTypeEnum getByCode(String code) {
        return (RuleTypeEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(RuleTypeEnum.class).stream().collect(Collectors.toMap(RuleTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
