package com.ejianc.business.pub.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pub.bean.BillCodeRuleAttrEntity;
import com.ejianc.business.pub.bean.BillCodeRuleEntity;
import com.ejianc.business.pub.bean.BillCodeRuleSNEntity;
import com.ejianc.business.pub.service.IBillCodeRuleAttrService;
import com.ejianc.business.pub.service.IBillCodeRuleSNService;
import com.ejianc.business.pub.service.IBillCodeRuleService;
import com.ejianc.business.pub.vo.BillCodeRuleSNVO;
import com.ejianc.business.pub.vo.BillCodeRuleVO;
import com.ejianc.business.pub.vo.enumvo.RuleElemType;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleApiVO;
import com.ejianc.business.ztpc.billcode.bean.GenerateBillCodeSNVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/ztpcBillCode/")
public class BillCodeRuleApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeRuleService codeService;

    @Autowired
    private IBillCodeRuleAttrService attrService;

    @Autowired
    private IBillCodeRuleSNService snService;

    @RequestMapping(value = "generateBillCode", method= RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GenerateBillCodeSNVO> generateBillCode(@RequestBody BillCodeRuleApiVO apiVO) {
        //查询编码规则
        QueryWrapper<BillCodeRuleEntity> ruleQuery = new QueryWrapper<>();
        ruleQuery.eq("project_id", apiVO.getProjectId());
        ruleQuery.eq("category_id", apiVO.getCategoryId());
        ruleQuery.eq("rule_type", apiVO.getRuleType());

        BillCodeRuleEntity billCodeRuleEntity = codeService.getOne(ruleQuery, false);

        if(billCodeRuleEntity == null ){
            return CommonResponse.error("未匹配到取号编码规则，请检查!");
        }

        GenerateBillCodeSNVO retSnVO = new GenerateBillCodeSNVO();

        //幂等
        QueryWrapper<BillCodeRuleSNEntity> snDuplicateWrapper = new QueryWrapper<>();
        snDuplicateWrapper.eq("rule_id",billCodeRuleEntity.getId());
        snDuplicateWrapper.eq("source_pid",apiVO.getSourcePid());

        BillCodeRuleSNEntity snDuplicateEntity = snService.getOne(snDuplicateWrapper, false);
        if(snDuplicateEntity != null){
            retSnVO = BeanMapper.map(snDuplicateEntity, GenerateBillCodeSNVO.class);
            retSnVO.setProjectId(apiVO.getProjectId());
            retSnVO.setCategoryId(apiVO.getCategoryId());
            retSnVO.setRuleType(apiVO.getRuleType());
            return CommonResponse.success(apiVO.getSourceCode()+"已生成编码",retSnVO);
        }

        //查询编码规则明细
        QueryParam attQuery = new QueryParam();
        attQuery.getParams().put("rule_id",new Parameter(QueryParam.EQ, billCodeRuleEntity.getId()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("id", QueryParam.DESC);

        List<BillCodeRuleAttrEntity> ruleAttrEntities = attrService.queryList(attQuery, false);

        /**开始组装编码start**/
        StringBuffer sb = new StringBuffer();
//        BillCodeRuleSNEntity saveEntity = new BillCodeRuleSNEntity();
        for (BillCodeRuleAttrEntity attrEntity : ruleAttrEntities) {
            if(RuleElemType.常量.getCode().equals(attrEntity.getRuleElemType())){
                sb.append(attrEntity.getElemValue()).append("—");
            }else if( RuleElemType.自定义流水依据.getCode().equals(attrEntity.getRuleElemType())){
                String ruleElemCode = attrEntity.getRuleElemCode();
                try {
                    Object fieldValue = getFieldValue(apiVO, ruleElemCode);
                    sb.append(fieldValue.toString()).append("—");
                } catch (NoSuchFieldException e) {
                    e.printStackTrace();
                    return CommonResponse.error("字段【 " + ruleElemCode + "】未传入对应的值！!");
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return CommonResponse.error("字段【 " + ruleElemCode + "】未传入对应的值！!");
                }
            }else if(RuleElemType.流水号.getCode().equals(attrEntity.getRuleElemType())){
                QueryWrapper<BillCodeRuleSNEntity> snWrapper = new QueryWrapper<>();
                snWrapper.select("start_sn,id");
                snWrapper.eq("rule_id",billCodeRuleEntity.getId());
                snWrapper.orderByAsc("id");
                List<BillCodeRuleSNEntity> snEntities = snService.list(snWrapper);
                Map<Integer, Long> snMap = snEntities.stream().collect(Collectors.toMap(BillCodeRuleSNEntity::getStartSn,BillCodeRuleSNEntity::getId));

                int initialNumber = attrEntity.getStartNum() == null ? 0 : attrEntity.getStartNum();
                Object[] objArr = generateSerialNumber(initialNumber, attrEntity.getElemLength(), snMap);
                sb.append(objArr[1].toString()).append("—");

                retSnVO.setStartSn( Integer.parseInt(objArr[0].toString()) );//序列数值
                retSnVO.setCurrSn(objArr[1].toString());//序列格式化
            }
        }
        String generateBillCode = sb.substring(0, sb.length() - 1);

        //保存规则sn流水
        retSnVO.setProjectId(apiVO.getProjectId());
        retSnVO.setCategoryId(apiVO.getCategoryId());
        retSnVO.setRuleType(apiVO.getRuleType());

        retSnVO.setIsInit("1");//非初始化
        retSnVO.setRuleId(billCodeRuleEntity.getId());//规则id
        retSnVO.setSourcePid(apiVO.getSourcePid());//来源id
        retSnVO.setSourceCode(apiVO.getSourceCode());//来源单据编码
        retSnVO.setSourceType(apiVO.getSourceType());//来源单据类型
        retSnVO.setGenerateBillCode(generateBillCode);//序列化编码
//        snService.saveOrUpdate(saveEntity);
        /**组装编码end**/

        return CommonResponse.success("生成编码成功",retSnVO);
    }


    @RequestMapping(value = "commitBillCode", method= RequestMethod.POST)
    @ResponseBody
    public CommonResponse commitBillCode(@RequestBody GenerateBillCodeSNVO generateBillCodeSNVO) {
        BillCodeRuleSNEntity snEntity = BeanMapper.map(generateBillCodeSNVO, BillCodeRuleSNEntity.class);
        snService.saveOrUpdate(snEntity);
        return CommonResponse.success("处理成功！");
    }

    @RequestMapping(value = "releaseBillCode", method= RequestMethod.POST)
    @ResponseBody
    public CommonResponse releaseBillCode(@RequestBody Map<String, Object> generateBillCode) {
        if(generateBillCode.get("generateBillCode") == null){
            return CommonResponse.error("generateBillCode不能为空");
        }

        ArrayList<String> generateBillCodeList = (ArrayList<String>)generateBillCode.get("generateBillCode");
        QueryWrapper<BillCodeRuleSNEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.in("generate_bill_code", generateBillCodeList);
        boolean flag = snService.remove(deleteWrapper,false);
        if(flag){
            return CommonResponse.success("还号成功");
        }else{
            return CommonResponse.error("还号失败");
        }
    }


    /**
     * @param initialNumber     初始化值
     * @param digitCount    流水号位数
     * @param snMap    流水号集合
     * @return
     */
    public static Object[] generateSerialNumber(int initialNumber, int digitCount,Map snMap) {
        int nextSerialNumber = getNextSerialNumber(initialNumber); // 将流水号递增1
        while (snMap.containsKey(nextSerialNumber)) {
            nextSerialNumber = getNextSerialNumber(nextSerialNumber);
        }

        String format = "%0" + digitCount + "d"; // 根据位数生成格式化字符串
        String serialNumber = String.format(format, nextSerialNumber);

        Object[] objArr = new Object[]{nextSerialNumber,serialNumber};
        return objArr;
    }

    private static int getNextSerialNumber(int currentSerialNumber) {
        return currentSerialNumber + 1;
    }
    public static <T, V> V getFieldValue(T object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (V) field.get(object);
    }
}
