package com.ejianc.business.pub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pub.bean.BillCodeRuleSNEntity;
import com.ejianc.business.pub.bean.DataDictionaryEntity;
import com.ejianc.business.pub.service.IBillCodeRuleSNService;
import com.ejianc.business.pub.util.Constants;
import com.ejianc.business.pub.vo.BillCodeRuleAttrVO;
import com.ejianc.business.pub.vo.BillCodeRuleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pub.mapper.BillCodeRuleMapper;
import com.ejianc.business.pub.bean.BillCodeRuleEntity;
import com.ejianc.business.pub.service.IBillCodeRuleService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 取号编码规则
 * 
 * @author generator
 * 
 */
@Service("billCodeRuleService")
public class BillCodeRuleServiceImpl extends BaseServiceImpl<BillCodeRuleMapper, BillCodeRuleEntity> implements IBillCodeRuleService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IBillCodeRuleService service;

    @Autowired
    private IBillCodeRuleSNService billCodeRuleSNService;



    private static final String BILL_CODE = "ZTPC_BILL_CODE";//此处需要根据实际修改

    @Override
    public CommonResponse<BillCodeRuleVO> saveOrUpdate(BillCodeRuleVO saveOrUpdateVO) {

        //数据校验
        List<BillCodeRuleAttrVO> billCodeRuleAttrList = saveOrUpdateVO.getBillCodeRuleAttrList().stream().filter(o -> !"del".equals(o.getRowState())).collect(Collectors.toList());
        Integer startNum = 0;
        if(billCodeRuleAttrList != null && billCodeRuleAttrList.size() > 0){
            for (BillCodeRuleAttrVO billCodeRuleAttrVO : billCodeRuleAttrList) {
                if("rule06".equals(billCodeRuleAttrVO.getRuleElemCode())){
                    if(billCodeRuleAttrVO.getElemLength() == null){
                        return CommonResponse.error("子表【编码规则子元素】序列号必须设置元素长度！");
                    }
                    if(billCodeRuleAttrVO.getStartNum() == null){
                        return CommonResponse.error("子表【编码规则子元素】序列号必须设置流水起始号！");
                    }else{
                        startNum = billCodeRuleAttrVO.getStartNum();
                    }
                }
            }
        }else{
            return CommonResponse.error("子表【编码规则子元素】不能为空！");
        }
        //保存DB
        BillCodeRuleEntity entity = BeanMapper.map(saveOrUpdateVO, BillCodeRuleEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setId(IdWorker.getId());
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        BillCodeRuleVO vo = BeanMapper.map(entity, BillCodeRuleVO.class);

        //保存流水号
        QueryWrapper<BillCodeRuleSNEntity> SNQuery1 = new QueryWrapper<>();
        SNQuery1.eq("rule_id", entity.getId());
        SNQuery1.eq("is_init", "1");

        BillCodeRuleSNEntity snServiceOne = billCodeRuleSNService.getOne(SNQuery1, false);
        if(snServiceOne != null ){
            return CommonResponse.error("该取号规则已被单据引用，不允许修改！");
        }else{
            //没有被引用，新增或更新
            QueryWrapper<BillCodeRuleSNEntity> SNQuery2 = new QueryWrapper<>();
            SNQuery2.eq("rule_id", entity.getId());
            SNQuery2.eq("is_init", "0");
            BillCodeRuleSNEntity snInitOne = billCodeRuleSNService.getOne(SNQuery2, false);
            if(snInitOne == null){
                //不存在初始化的数据则新增
                snInitOne = new BillCodeRuleSNEntity();
                snInitOne.setRuleId(entity.getId());
                snInitOne.setIsInit("0");
                snInitOne.setStartSn(startNum);
            }else{
                snInitOne.setStartSn(startNum);
            }
            billCodeRuleSNService.saveOrUpdate(snInitOne);
        }

        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
