/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pub.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pub.bean.BillCodeRuleAttrEntity;
import com.ejianc.business.pub.bean.BillCodeRuleEntity;
import com.ejianc.business.pub.bean.BillCodeRuleSNEntity;
import com.ejianc.business.pub.service.IBillCodeRuleAttrService;
import com.ejianc.business.pub.service.IBillCodeRuleSNService;
import com.ejianc.business.pub.service.IBillCodeRuleService;
import com.ejianc.business.pub.vo.enumvo.RuleElemType;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleApiVO;
import com.ejianc.business.ztpc.billcode.bean.GenerateBillCodeSNVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ztpcBillCode/"})
public class BillCodeRuleApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeRuleService codeService;
    @Autowired
    private IBillCodeRuleAttrService attrService;
    @Autowired
    private IBillCodeRuleSNService snService;

    @RequestMapping(value={"generateBillCode"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GenerateBillCodeSNVO> generateBillCode(@RequestBody BillCodeRuleApiVO apiVO) {
        QueryWrapper ruleQuery = new QueryWrapper();
        ruleQuery.eq((Object)"project_id", (Object)apiVO.getProjectId());
        ruleQuery.eq((Object)"category_id", (Object)apiVO.getCategoryId());
        ruleQuery.eq((Object)"rule_type", (Object)apiVO.getRuleType());
        BillCodeRuleEntity billCodeRuleEntity = (BillCodeRuleEntity)((Object)this.codeService.getOne((Wrapper)ruleQuery, false));
        if (billCodeRuleEntity == null) {
            return CommonResponse.error((String)"\u672a\u5339\u914d\u5230\u53d6\u53f7\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5!");
        }
        GenerateBillCodeSNVO retSnVO = new GenerateBillCodeSNVO();
        QueryWrapper snDuplicateWrapper = new QueryWrapper();
        snDuplicateWrapper.eq((Object)"rule_id", (Object)billCodeRuleEntity.getId());
        snDuplicateWrapper.eq((Object)"source_pid", (Object)apiVO.getSourcePid());
        BillCodeRuleSNEntity snDuplicateEntity = (BillCodeRuleSNEntity)((Object)this.snService.getOne((Wrapper)snDuplicateWrapper, false));
        if (snDuplicateEntity != null) {
            retSnVO = (GenerateBillCodeSNVO)BeanMapper.map((Object)((Object)snDuplicateEntity), GenerateBillCodeSNVO.class);
            retSnVO.setProjectId(apiVO.getProjectId());
            retSnVO.setCategoryId(apiVO.getCategoryId());
            retSnVO.setRuleType(apiVO.getRuleType());
            return CommonResponse.success((String)(apiVO.getSourceCode() + "\u5df2\u751f\u6210\u7f16\u7801"), (Object)retSnVO);
        }
        QueryParam attQuery = new QueryParam();
        attQuery.getParams().put("rule_id", new Parameter("eq", (Object)billCodeRuleEntity.getId()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("id", "desc");
        List ruleAttrEntities = this.attrService.queryList(attQuery, false);
        StringBuffer sb = new StringBuffer();
        for (BillCodeRuleAttrEntity attrEntity : ruleAttrEntities) {
            if (RuleElemType.\u5e38\u91cf.getCode().equals(attrEntity.getRuleElemType())) {
                sb.append(attrEntity.getElemValue()).append("\u2014");
                continue;
            }
            if (RuleElemType.\u81ea\u5b9a\u4e49\u6d41\u6c34\u4f9d\u636e.getCode().equals(attrEntity.getRuleElemType())) {
                String ruleElemCode = attrEntity.getRuleElemCode();
                try {
                    Object fieldValue = BillCodeRuleApi.getFieldValue(apiVO, ruleElemCode);
                    sb.append(fieldValue.toString()).append("\u2014");
                    continue;
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                    return CommonResponse.error((String)("\u5b57\u6bb5\u3010 " + ruleElemCode + "\u3011\u672a\u4f20\u5165\u5bf9\u5e94\u7684\u503c\uff01!"));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return CommonResponse.error((String)("\u5b57\u6bb5\u3010 " + ruleElemCode + "\u3011\u672a\u4f20\u5165\u5bf9\u5e94\u7684\u503c\uff01!"));
                }
            }
            if (!RuleElemType.\u6d41\u6c34\u53f7.getCode().equals(attrEntity.getRuleElemType())) continue;
            QueryWrapper snWrapper = new QueryWrapper();
            snWrapper.select(new String[]{"start_sn,id"});
            snWrapper.eq((Object)"rule_id", (Object)billCodeRuleEntity.getId());
            snWrapper.orderByAsc((Object)"id");
            List snEntities = this.snService.list((Wrapper)snWrapper);
            Map<Integer, Long> snMap = snEntities.stream().collect(Collectors.toMap(BillCodeRuleSNEntity::getStartSn, BaseEntity::getId));
            int initialNumber = attrEntity.getStartNum() == null ? 0 : attrEntity.getStartNum();
            Object[] objArr = BillCodeRuleApi.generateSerialNumber(initialNumber, attrEntity.getElemLength(), snMap);
            sb.append(objArr[1].toString()).append("\u2014");
            retSnVO.setStartSn(Integer.valueOf(Integer.parseInt(objArr[0].toString())));
            retSnVO.setCurrSn(objArr[1].toString());
        }
        String generateBillCode = sb.substring(0, sb.length() - 1);
        retSnVO.setProjectId(apiVO.getProjectId());
        retSnVO.setCategoryId(apiVO.getCategoryId());
        retSnVO.setRuleType(apiVO.getRuleType());
        retSnVO.setIsInit("1");
        retSnVO.setRuleId(billCodeRuleEntity.getId());
        retSnVO.setSourcePid(apiVO.getSourcePid());
        retSnVO.setSourceCode(apiVO.getSourceCode());
        retSnVO.setSourceType(apiVO.getSourceType());
        retSnVO.setGenerateBillCode(generateBillCode);
        return CommonResponse.success((String)"\u751f\u6210\u7f16\u7801\u6210\u529f", (Object)retSnVO);
    }

    @RequestMapping(value={"commitBillCode"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse commitBillCode(@RequestBody GenerateBillCodeSNVO generateBillCodeSNVO) {
        BillCodeRuleSNEntity snEntity = (BillCodeRuleSNEntity)((Object)BeanMapper.map((Object)generateBillCodeSNVO, BillCodeRuleSNEntity.class));
        this.snService.saveOrUpdate((Object)snEntity);
        return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01");
    }

    @RequestMapping(value={"releaseBillCode"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse releaseBillCode(@RequestBody Map<String, Object> generateBillCode) {
        if (generateBillCode.get("generateBillCode") == null) {
            return CommonResponse.error((String)"generateBillCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList generateBillCodeList = (ArrayList)generateBillCode.get("generateBillCode");
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.in((Object)"generate_bill_code", (Collection)generateBillCodeList);
        boolean flag = this.snService.remove((Wrapper)deleteWrapper, false);
        if (flag) {
            return CommonResponse.success((String)"\u8fd8\u53f7\u6210\u529f");
        }
        return CommonResponse.error((String)"\u8fd8\u53f7\u5931\u8d25");
    }

    public static Object[] generateSerialNumber(int initialNumber, int digitCount, Map snMap) {
        int nextSerialNumber = BillCodeRuleApi.getNextSerialNumber(initialNumber);
        while (snMap.containsKey(nextSerialNumber)) {
            nextSerialNumber = BillCodeRuleApi.getNextSerialNumber(nextSerialNumber);
        }
        String format = "%0" + digitCount + "d";
        String serialNumber = String.format(format, nextSerialNumber);
        Object[] objArr = new Object[]{nextSerialNumber, serialNumber};
        return objArr;
    }

    private static int getNextSerialNumber(int currentSerialNumber) {
        return currentSerialNumber + 1;
    }

    public static <T, V> V getFieldValue(T object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (V)field.get(object);
    }
}

