/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pub.bean.DataDictionaryEntity;
import com.ejianc.business.pub.mapper.DataDictionaryMapper;
import com.ejianc.business.pub.service.IDataDictionaryService;
import com.ejianc.business.pub.vo.DataDictionaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dataDictionaryService")
public class DataDictionaryServiceImpl
extends BaseServiceImpl<DataDictionaryMapper, DataDictionaryEntity>
implements IDataDictionaryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDataDictionaryService service;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "DICTIONARY";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<DataDictionaryVO> saveOrUpdate(DataDictionaryVO saveOrUpdateVO) {
        DataDictionaryEntity entity = (DataDictionaryEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), DataDictionaryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            QueryWrapper query1 = new QueryWrapper();
            query1.eq((Object)"category_id", (Object)saveOrUpdateVO.getCategoryId());
            query1.eq((Object)"level", (Object)"\u516c\u5171\u7ea7");
            query1.eq((Object)"dictionary_code", (Object)saveOrUpdateVO.getDictionaryCode());
            int count1 = this.service.count((Wrapper)query1);
            if (count1 > 0) {
                return CommonResponse.error((String)("\u4fdd\u5b58\u5931\u8d25\uff01\u8be5\u7f16\u7801\u5728\u516c\u5171\u7ea7\u5df2\u521b\u5efa\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\uff1a" + saveOrUpdateVO.getDictionaryCode()));
            }
            QueryWrapper query2 = new QueryWrapper();
            query2.eq((Object)"category_id", (Object)saveOrUpdateVO.getCategoryId());
            query2.eq((Object)"level", (Object)"\u516c\u5171\u7ea7");
            query2.eq((Object)"dictionary_name", (Object)saveOrUpdateVO.getDictionaryName());
            int count2 = this.service.count((Wrapper)query2);
            if (count2 > 0) {
                return CommonResponse.error((String)("\u4fdd\u5b58\u5931\u8d25\uff01\u8be5\u540d\u79f0\u5728\u516c\u5171\u7ea7\u5df2\u521b\u5efa\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\uff1a" + saveOrUpdateVO.getDictionaryName()));
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            entity = (DataDictionaryEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
            entity.setDictionaryCode(saveOrUpdateVO.getDictionaryCode());
            entity.setDictionaryName(saveOrUpdateVO.getDictionaryName());
            entity.setLine(saveOrUpdateVO.getLine());
        }
        UserContext userContext = this.sessionManager.getUserContext();
        int orgType = userContext.getOrgType();
        if (orgType == 1) {
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgCode("group");
            entity.setOrgName(userContext.getOrgName());
            entity.setLevel("\u516c\u5171\u7ea7");
        } else {
            if (orgType != 5) return CommonResponse.error((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u65b0\u589e\u6216\u4fee\u6539");
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgCode(userContext.getOrgId() + "");
            entity.setOrgName(userContext.getOrgName());
            entity.setLevel("\u9879\u76ee\u7ea7");
            CommonResponse projectVOCommonResponse = this.projectPoolApi.queryProjectByProjectDepartmentId(userContext.getOrgId());
            ProjectVO projectVO = (ProjectVO)projectVOCommonResponse.getData();
            entity.setProjectId(projectVO.getId());
            entity.setProjectCode(projectVO.getBillCode());
            entity.setProjectName(projectVO.getProjectName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        DataDictionaryVO vo = (DataDictionaryVO)((Object)BeanMapper.map((Object)((Object)entity), DataDictionaryVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f", (Object)((Object)vo));
    }
}

